/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.fullscreen;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.advance.supplier.ks.R;
import com.kwad.sdk.KsAdSDKImpl;
import com.kwad.sdk.api.KsFullScreenVideoAd;
import com.kwad.sdk.api.KsVideoPlayConfig;
import com.kwad.sdk.api.core.KsAdSdkDynamicImpl;
import com.kwad.sdk.api.proxy.app.FeedDownloadActivity;
import com.kwad.sdk.api.proxy.app.KsFullScreenLandScapeVideoActivity;
import com.kwad.sdk.api.proxy.app.KsFullScreenVideoActivity;
import com.kwad.sdk.contentalliance.detail.video.DetailVideoView;
import com.kwad.sdk.core.response.model.AdInfo;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.core.view.AdBaseFrameLayout;
import com.kwad.sdk.fullscreen.a.a;
import com.kwad.sdk.fullscreen.a.a.c;
import com.kwad.sdk.mvp.Presenter;
import com.kwad.sdk.plugin.f;
import com.kwad.sdk.plugin.g;
import com.kwad.sdk.reward.b.d;
import com.kwad.sdk.reward.b.d.b;
import com.kwad.sdk.utils.j;
import com.kwad.sdk.utils.q;
import java.io.File;
import java.io.Serializable;
import org.json.JSONObject;

@KsAdSdkDynamicImpl(value=KsFullScreenVideoActivity.class)
@Keep
public class KsFullScreenVideoActivityProxy
extends com.kwad.sdk.core.e.a<com.kwad.sdk.reward.a> {
    private static final String TAG = "FullScreenVideo";
    public static final String KEY_VIDEO_PLAY_CONFIG = "key_video_play_config";
    public static final String KEY_TEMPLATE = "key_template_json";
    public static KsFullScreenVideoAd.FullScreenVideoAdInteractionListener mInteractionListener;
    private AdBaseFrameLayout mRootContainer;
    private DetailVideoView mDetailVideoView;
    private AdTemplate mAdTemplate;
    private AdInfo mAdInfo;
    private KsVideoPlayConfig mVideoPlayConfig;
    public int mScreenOrientation;
    private JSONObject mReportExtData;
    private boolean mIsBackEnable;
    private boolean mPageDismissCalled;
    private Activity mContext;
    private com.kwad.sdk.reward.a.f mPageListener = new com.kwad.sdk.reward.a.f(){

        @Override
        public void a() {
            KsFullScreenVideoActivityProxy.this.mIsBackEnable = true;
        }
    };
    private com.kwad.sdk.reward.a.b mAdOpenInteractionListener = new com.kwad.sdk.reward.a.c(){

        @Override
        public void a() {
            if (mInteractionListener != null) {
                mInteractionListener.onAdClicked();
            }
        }

        @Override
        public void b() {
            if (mInteractionListener != null) {
                mInteractionListener.onSkippedVideo();
            }
        }

        @Override
        public void c() {
            if (mInteractionListener != null) {
                mInteractionListener.onVideoPlayStart();
            }
        }

        @Override
        public void a(int n2, int n3) {
            if (mInteractionListener != null) {
                mInteractionListener.onVideoPlayError(n2, n3);
            }
        }

        @Override
        public void d() {
            if (mInteractionListener != null) {
                mInteractionListener.onVideoPlayEnd();
            }
        }

        @Override
        public void a(boolean bl2) {
            KsFullScreenVideoActivityProxy.this.notifyPageDismiss();
        }
    };

    public static void launch(Context context, @NonNull AdTemplate adTemplate, @NonNull KsVideoPlayConfig ksVideoPlayConfig, KsFullScreenVideoAd.FullScreenVideoAdInteractionListener fullScreenVideoAdInteractionListener) {
        j.b(adTemplate);
        if (!ksVideoPlayConfig.isShowLandscape()) {
            KsAdSDKImpl.putComponentProxy(FeedDownloadActivity.class, KsFullScreenVideoActivityProxy.class);
        }
        Intent intent = new Intent(context, ksVideoPlayConfig.isShowLandscape() ? KsFullScreenLandScapeVideoActivity.class : FeedDownloadActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra(KEY_TEMPLATE, adTemplate.toJson().toString());
        intent.putExtra(KEY_VIDEO_PLAY_CONFIG, (Serializable)ksVideoPlayConfig);
        mInteractionListener = fullScreenVideoAdInteractionListener;
        context.startActivity(intent);
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mContext = this.getActivity();
        if (!this.initData()) {
            this.finish();
            return;
        }
        this.setContentView(R.layout.ksad_activity_fullscreen_video);
        this.initView();
        this.onActivityCreated((View)this.mRootContainer);
    }

    private boolean initData() {
        File file;
        Object object;
        Serializable serializable = this.mContext.getIntent().getSerializableExtra(KEY_VIDEO_PLAY_CONFIG);
        if (!(serializable instanceof KsVideoPlayConfig)) {
            com.kwad.sdk.core.d.a.e(TAG, "data is not instanceof VideoPlayConfigImpl:" + serializable);
            return false;
        }
        String string = this.getIntent().getStringExtra(KEY_TEMPLATE);
        try {
            object = new AdTemplate();
            ((com.kwad.sdk.core.response.a.a)object).parseJson(new JSONObject(string));
            this.mAdTemplate = object;
        }
        catch (Throwable throwable) {
            com.kwad.sdk.core.d.a.a(throwable);
        }
        if (this.mAdTemplate == null) {
            com.kwad.sdk.core.d.a.e(TAG, "data is null:" + string);
            return false;
        }
        this.mAdInfo = com.kwad.sdk.core.response.b.c.h(this.mAdTemplate);
        object = com.kwad.sdk.core.response.b.a.a(this.mAdInfo);
        int n2 = com.kwad.sdk.core.config.c.C();
        if (!(n2 >= 0 || (file = com.kwad.sdk.core.diskcache.b.a.a().b((String)object)) != null && file.exists())) {
            return false;
        }
        this.mVideoPlayConfig = (KsVideoPlayConfig)serializable;
        this.mScreenOrientation = this.mVideoPlayConfig.isShowLandscape() ? 1 : 0;
        this.mAdTemplate.mInitVoiceStatus = this.mVideoPlayConfig.isVideoSoundEnable() ? 2 : 1;
        this.initVideoPlayConfig(this.mVideoPlayConfig);
        return true;
    }

    private void initVideoPlayConfig(@NonNull KsVideoPlayConfig ksVideoPlayConfig) {
        this.mContext.setRequestedOrientation(ksVideoPlayConfig.isShowLandscape() ? 0 : 1);
        if (!TextUtils.isEmpty((CharSequence)ksVideoPlayConfig.getShowScene())) {
            this.mReportExtData = null;
            this.mReportExtData = new JSONObject();
            q.a(this.mReportExtData, "ext_showscene", ksVideoPlayConfig.getShowScene());
        }
    }

    private void initView() {
        this.mRootContainer = (AdBaseFrameLayout)this.mContext.findViewById(R.id.ksad_root_container);
        this.mDetailVideoView = (DetailVideoView)this.mRootContainer.findViewById(R.id.ksad_video_player);
        this.mDetailVideoView.setAd(true);
    }

    @Override
    protected com.kwad.sdk.reward.a onCreateCallerContext() {
        com.kwad.sdk.reward.c.a a2;
        com.kwad.sdk.reward.a a3 = new com.kwad.sdk.reward.a();
        a3.g = this.mContext;
        a3.b = this.mAdOpenInteractionListener;
        a3.e = this.mScreenOrientation;
        a3.c = this.mVideoPlayConfig;
        a3.d = this.mReportExtData;
        a3.h = this.mRootContainer;
        a3.f = this.mAdTemplate;
        a3.i = a2 = new com.kwad.sdk.reward.c.a(this.mAdTemplate, this.mDetailVideoView, this.mVideoPlayConfig);
        a3.a.add(a2);
        if (com.kwad.sdk.core.response.b.a.v(this.mAdInfo)) {
            a3.j = new com.kwad.sdk.core.download.b.b(this.mAdTemplate, this.mReportExtData);
        }
        a3.k = new com.kwad.sdk.reward.b.b.a.a(this.mAdTemplate, this.mScreenOrientation);
        a3.a(this.mPageListener);
        if (com.kwad.sdk.core.response.b.b.j(this.mAdTemplate)) {
            a3.l = new com.kwad.sdk.d.c(this.mReportExtData);
        }
        if (com.kwad.sdk.core.response.b.c.o(this.mAdTemplate)) {
            a3.m = new com.kwad.sdk.d.a().a(false);
        }
        a3.q = false;
        return a3;
    }

    private boolean isShowNewStyle() {
        int n2 = com.kwad.sdk.core.response.b.a.d(this.mAdInfo);
        int n3 = com.kwad.sdk.core.response.b.a.e(this.mAdInfo);
        boolean bl2 = this.mCallerContext.e == 1 ? n2 <= n3 : n2 >= n3;
        return bl2;
    }

    @Override
    protected Presenter onCreatePresenter() {
        g g2;
        Presenter presenter = new Presenter();
        presenter.a(new d());
        if (com.kwad.sdk.core.response.b.a.J(this.mAdInfo)) {
            presenter.a(new com.kwad.sdk.reward.b.b.a());
        }
        if ((g2 = f.a(g.class)) != null && g2.b()) {
            this.mCallerContext.s = true;
            presenter.a(new b());
            if (com.kwad.sdk.core.response.b.a.L(this.mAdInfo) && this.isShowNewStyle()) {
                presenter.a(new com.kwad.sdk.reward.b.d.d());
            } else {
                presenter.a(new com.kwad.sdk.reward.b.d.c(com.kwad.sdk.core.response.b.b.i(this.mAdTemplate)));
            }
            presenter.a(new a());
        } else {
            presenter.a(new a());
            presenter.a(new c());
            presenter.a(new com.kwad.sdk.fullscreen.a.b.a());
            if (com.kwad.sdk.core.response.b.a.K(this.mAdInfo) && this.isShowNewStyle()) {
                presenter.a(new com.kwad.sdk.reward.b.b.c());
            }
            presenter.a(new com.kwad.sdk.reward.b.b.a.b());
            if (com.kwad.sdk.core.response.b.b.i(this.mAdTemplate)) {
                presenter.a(new com.kwad.sdk.reward.b.b.a.c());
            }
        }
        if (com.kwad.sdk.core.response.b.a.K(this.mAdInfo) && this.isShowNewStyle()) {
            presenter.a(new com.kwad.sdk.reward.b.b.c());
        }
        FrameLayout frameLayout = (FrameLayout)this.findViewById(R.id.ksad_interactive_landing_page_container);
        presenter.a(new com.kwad.sdk.reward.b.c.a((Context)this.getActivity(), this.mAdTemplate, false, frameLayout));
        presenter.a(new com.kwad.sdk.reward.b.a.a());
        return presenter;
    }

    @Override
    public void onBackPressed() {
        if (this.mIsBackEnable) {
            super.onBackPressed();
        }
    }

    @Override
    public void finish() {
        this.notifyPageDismiss();
        this.mContext.finish();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.notifyPageDismiss();
        if (this.mAdInfo != null) {
            String string = com.kwad.sdk.core.response.b.a.a(this.mAdInfo);
            com.kwad.sdk.core.videocache.c.a.a((Context)this.getActivity()).c(string);
        }
        mInteractionListener = null;
    }

    @Override
    protected String getPageName() {
        return "KsFullScreenVideoActivityProxy";
    }

    private void notifyPageDismiss() {
        if (this.mPageDismissCalled) {
            return;
        }
        this.mPageDismissCalled = true;
        com.kwad.sdk.core.report.a.a(this.mAdTemplate, 6, this.mReportExtData);
        if (mInteractionListener != null) {
            mInteractionListener.onPageDismiss();
        }
    }
}

