/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.glide.framesequence;

import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class FrameSequence
implements Serializable {
    private static final AtomicBoolean ISLOADED = new AtomicBoolean(false);
    private long mNativeFrameSequence;
    private int mWidth;
    private int mHeight;
    private boolean mOpaque;
    private int mFrameCount;
    private int mDefaultLoopCount;

    public static boolean isEnable() {
        return ISLOADED.get();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getFrameCount() {
        return this.mFrameCount;
    }

    public int getDefaultLoopCount() {
        return this.mDefaultLoopCount;
    }

    private static native FrameSequence nativeDecodeByteArray(byte[] var0, int var1, int var2);

    private static native FrameSequence nativeDecodeStream(InputStream var0, byte[] var1);

    private static native FrameSequence nativeDecodeByteBuffer(ByteBuffer var0, int var1, int var2);

    private static native void nativeDestroyFrameSequence(long var0);

    private static native long nativeCreateState(long var0);

    private static native void nativeDestroyState(long var0);

    private static native long nativeGetFrame(long var0, int var2, Bitmap var3, int var4);

    public FrameSequence() {
    }

    private FrameSequence(long l2, int n2, int n3, boolean bl2, int n4, int n5) {
        this.mNativeFrameSequence = l2;
        this.mWidth = n2;
        this.mHeight = n3;
        this.mOpaque = bl2;
        this.mFrameCount = n4;
        this.mDefaultLoopCount = n5;
    }

    @Nullable
    public static FrameSequence decodeByteArray(byte[] byArray) {
        if (!ISLOADED.get()) {
            return null;
        }
        return FrameSequence.decodeByteArray(byArray, 0, byArray.length);
    }

    @Nullable
    public static FrameSequence decodeByteArray(byte[] byArray, int n2, int n3) {
        if (!ISLOADED.get()) {
            return null;
        }
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("invalid offset/length parameters");
        }
        return FrameSequence.nativeDecodeByteArray(byArray, n2, n3);
    }

    @Nullable
    public static FrameSequence decodeByteBuffer(ByteBuffer byteBuffer) {
        if (!ISLOADED.get()) {
            return null;
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException();
        }
        if (!byteBuffer.isDirect()) {
            if (byteBuffer.hasArray()) {
                byte[] byArray = byteBuffer.array();
                return FrameSequence.decodeByteArray(byArray, byteBuffer.position(), byteBuffer.remaining());
            }
            throw new IllegalArgumentException("Cannot have non-direct ByteBuffer with no byte array");
        }
        return FrameSequence.nativeDecodeByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    @Nullable
    public static FrameSequence decodeStream(InputStream inputStream) {
        if (!ISLOADED.get()) {
            return null;
        }
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[16384];
        return FrameSequence.nativeDecodeStream(inputStream, byArray);
    }

    State createState() {
        if (this.mNativeFrameSequence == 0L) {
            throw new IllegalStateException("attempted to use incorrectly built FrameSequence");
        }
        long l2 = FrameSequence.nativeCreateState(this.mNativeFrameSequence);
        if (l2 == 0L) {
            return null;
        }
        return new State(l2);
    }

    public void destroy() {
        if (this.mNativeFrameSequence != 0L) {
            FrameSequence.nativeDestroyFrameSequence(this.mNativeFrameSequence);
        }
    }

    static {
        try {
            System.loadLibrary("framesequencev2");
            ISLOADED.set(true);
        }
        catch (Throwable throwable) {
            ISLOADED.set(false);
        }
    }

    static class State
    implements Serializable {
        private long mNativeState;

        public State(long l2) {
            this.mNativeState = l2;
        }

        public void destroy() {
            if (this.mNativeState != 0L) {
                FrameSequence.nativeDestroyState(this.mNativeState);
                this.mNativeState = 0L;
            }
        }

        public long getFrame(int n2, Bitmap bitmap, int n3) {
            if (bitmap == null || bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                throw new IllegalArgumentException("Bitmap passed must be non-null and ARGB_8888");
            }
            if (this.mNativeState == 0L) {
                throw new IllegalStateException("attempted to draw destroyed FrameSequenceState");
            }
            return FrameSequence.nativeGetFrame(this.mNativeState, n2, bitmap, n3);
        }
    }
}

