/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.glide.framesequence;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import com.kwad.sdk.glide.framesequence.FrameSequence;
import java.io.InputStream;

public class FrameSequenceDrawable
extends Drawable
implements Animatable,
Runnable {
    private static final String TAG = "FrameSequenceDrawable";
    private static final long MIN_DELAY_MS = 20L;
    private static final long DEFAULT_DELAY_MS = 100L;
    private static final Object sLock = new Object();
    private static HandlerThread sDecodingThread;
    private static Handler sDecodingThreadHandler;
    private static a sAllocatingBitmapProvider;
    public static final int LOOP_FINITE = 1;
    public static final int LOOP_INF = 2;
    public static final int LOOP_DEFAULT = 3;
    @Deprecated
    public static final int LOOP_ONCE = 1;
    private final FrameSequence mFrameSequence;
    private final FrameSequence.State mFrameSequenceState;
    private final Paint mPaint;
    private BitmapShader mFrontBitmapShader;
    private BitmapShader mBackBitmapShader;
    private final Rect mSrcRect;
    private boolean mCircleMaskEnabled;
    private final Object mLock = new Object();
    private final a mBitmapProvider;
    private boolean mDestroyed = false;
    private Bitmap mFrontBitmap;
    private Bitmap mBackBitmap;
    private static final int STATE_SCHEDULED = 1;
    private static final int STATE_DECODING = 2;
    private static final int STATE_WAITING_TO_SWAP = 3;
    private static final int STATE_READY_TO_SWAP = 4;
    private int mState;
    private int mCurrentLoop;
    private int mLoopBehavior = 3;
    private int mLoopCount = 1;
    private long mLastSwap;
    private long mNextSwap;
    private int mNextFrameToDecode;
    private b mOnFinishedListener;
    private RectF mTempRectF = new RectF();
    private Runnable mDecodeRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bitmap bitmap;
            int n2;
            Object object = FrameSequenceDrawable.this.mLock;
            synchronized (object) {
                if (FrameSequenceDrawable.this.mDestroyed) {
                    return;
                }
                n2 = FrameSequenceDrawable.this.mNextFrameToDecode;
                if (n2 < 0) {
                    return;
                }
                bitmap = FrameSequenceDrawable.this.mBackBitmap;
                FrameSequenceDrawable.this.mState = 2;
            }
            int n3 = n2 - 2;
            boolean bl2 = false;
            long l2 = 0L;
            try {
                l2 = FrameSequenceDrawable.this.mFrameSequenceState.getFrame(n2, bitmap, n3);
            }
            catch (Exception exception) {
                Log.e((String)FrameSequenceDrawable.TAG, (String)("exception during decode: " + exception));
                bl2 = true;
            }
            if (l2 < 20L) {
                l2 = 100L;
            }
            boolean bl3 = false;
            Bitmap bitmap2 = null;
            Object object2 = FrameSequenceDrawable.this.mLock;
            synchronized (object2) {
                if (FrameSequenceDrawable.this.mDestroyed) {
                    bitmap2 = FrameSequenceDrawable.this.mBackBitmap;
                    FrameSequenceDrawable.this.mBackBitmap = null;
                } else if (FrameSequenceDrawable.this.mNextFrameToDecode >= 0 && FrameSequenceDrawable.this.mState == 2) {
                    bl3 = true;
                    FrameSequenceDrawable.this.mNextSwap = bl2 ? Long.MAX_VALUE : l2 + FrameSequenceDrawable.this.mLastSwap;
                    FrameSequenceDrawable.this.mState = 3;
                }
            }
            if (bl3) {
                FrameSequenceDrawable.this.scheduleSelf(FrameSequenceDrawable.this, FrameSequenceDrawable.this.mNextSwap);
            }
            if (bitmap2 != null) {
                FrameSequenceDrawable.this.mBitmapProvider.a(bitmap2);
            }
        }
    };
    private Runnable mFinishedCallbackRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = FrameSequenceDrawable.this.mLock;
            synchronized (object) {
                FrameSequenceDrawable.this.mNextFrameToDecode = -1;
                FrameSequenceDrawable.this.mState = 0;
            }
            if (FrameSequenceDrawable.this.mOnFinishedListener != null) {
                FrameSequenceDrawable.this.mOnFinishedListener.a(FrameSequenceDrawable.this);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeDecodingThread() {
        Object object = sLock;
        synchronized (object) {
            if (sDecodingThread != null) {
                return;
            }
            sDecodingThread = new HandlerThread("FrameSequence decoding thread", 10);
            sDecodingThread.start();
            sDecodingThreadHandler = new Handler(sDecodingThread.getLooper());
        }
    }

    public void setOnFinishedListener(b b2) {
        this.mOnFinishedListener = b2;
    }

    public void setLoopCount(int n2) {
        this.mLoopCount = n2;
    }

    private static Bitmap acquireAndValidateBitmap(a a2, int n2, int n3) {
        Bitmap bitmap = a2.a(n2, n3);
        if (bitmap.getWidth() < n2 || bitmap.getHeight() < n3 || bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Invalid bitmap provided");
        }
        return bitmap;
    }

    public FrameSequenceDrawable(InputStream inputStream) {
        this(FrameSequence.decodeStream(inputStream));
    }

    public FrameSequenceDrawable(FrameSequence frameSequence) {
        this(frameSequence, sAllocatingBitmapProvider);
    }

    public FrameSequenceDrawable(FrameSequence frameSequence, a a2) {
        if (frameSequence == null || a2 == null) {
            throw new IllegalArgumentException();
        }
        this.mFrameSequence = frameSequence;
        this.mFrameSequenceState = frameSequence.createState();
        int n2 = frameSequence.getWidth();
        int n3 = frameSequence.getHeight();
        this.mBitmapProvider = a2;
        this.mFrontBitmap = FrameSequenceDrawable.acquireAndValidateBitmap(a2, n2, n3);
        this.mBackBitmap = FrameSequenceDrawable.acquireAndValidateBitmap(a2, n2, n3);
        this.mSrcRect = new Rect(0, 0, n2, n3);
        this.mPaint = new Paint();
        this.mPaint.setFilterBitmap(true);
        this.mFrontBitmapShader = new BitmapShader(this.mFrontBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBackBitmapShader = new BitmapShader(this.mBackBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mLastSwap = 0L;
        this.mNextFrameToDecode = -1;
        this.mFrameSequenceState.getFrame(0, this.mFrontBitmap, -1);
        FrameSequenceDrawable.initializeDecodingThread();
    }

    public final void setCircleMaskEnabled(boolean bl2) {
        if (this.mCircleMaskEnabled != bl2) {
            this.mCircleMaskEnabled = bl2;
            this.mPaint.setAntiAlias(bl2);
            this.invalidateSelf();
        }
    }

    public final boolean getCircleMaskEnabled() {
        return this.mCircleMaskEnabled;
    }

    private void checkDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot perform operation on recycled drawable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Bitmap bitmap;
        if (this.mBitmapProvider == null) {
            throw new IllegalStateException("BitmapProvider must be non-null");
        }
        Bitmap bitmap2 = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            bitmap = this.mFrontBitmap;
            this.mFrontBitmap = null;
            if (this.mState != 2) {
                bitmap2 = this.mBackBitmap;
                this.mBackBitmap = null;
            }
            this.mDestroyed = true;
        }
        this.mBitmapProvider.a(bitmap);
        if (bitmap2 != null) {
            this.mBitmapProvider.a(bitmap2);
        }
        this.mFrameSequenceState.destroy();
        this.mFrameSequence.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas canvas) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                return;
            }
            if (this.mState == 3 && this.mNextSwap - SystemClock.uptimeMillis() <= 0L) {
                this.mState = 4;
            }
            if (this.isRunning() && this.mState == 4) {
                Bitmap bitmap = this.mBackBitmap;
                this.mBackBitmap = this.mFrontBitmap;
                this.mFrontBitmap = bitmap;
                BitmapShader bitmapShader = this.mBackBitmapShader;
                this.mBackBitmapShader = this.mFrontBitmapShader;
                this.mFrontBitmapShader = bitmapShader;
                this.mLastSwap = SystemClock.uptimeMillis();
                boolean bl2 = true;
                if (this.mNextFrameToDecode == this.mFrameSequence.getFrameCount() - 1) {
                    ++this.mCurrentLoop;
                    if (this.mLoopBehavior == 1 && this.mCurrentLoop == this.mLoopCount || this.mLoopBehavior == 3 && this.mCurrentLoop == this.mFrameSequence.getDefaultLoopCount()) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this.scheduleDecodeLocked();
                } else {
                    this.unscheduleSelf(this.mFinishedCallbackRunnable);
                    this.scheduleSelf(this.mFinishedCallbackRunnable, 0L);
                }
            }
        }
        if (this.mCircleMaskEnabled) {
            object = this.getBounds();
            int n2 = this.getIntrinsicWidth();
            int n3 = this.getIntrinsicHeight();
            float f2 = 1.0f * (float)object.width() / (float)n2;
            float f3 = 1.0f * (float)object.height() / (float)n3;
            canvas.save();
            canvas.translate((float)((Rect)object).left, (float)((Rect)object).top);
            canvas.scale(f2, f3);
            float f4 = Math.min(object.width(), object.height());
            float f5 = f4 / f2;
            float f6 = f4 / f3;
            this.mTempRectF.set(((float)n2 - f5) / 2.0f, ((float)n3 - f6) / 2.0f, ((float)n2 + f5) / 2.0f, ((float)n3 + f6) / 2.0f);
            this.mPaint.setShader((Shader)this.mFrontBitmapShader);
            canvas.drawOval(this.mTempRectF, this.mPaint);
            canvas.restore();
        } else {
            this.mPaint.setShader(null);
            canvas.drawBitmap(this.mFrontBitmap, this.mSrcRect, this.getBounds(), this.mPaint);
        }
    }

    private void scheduleDecodeLocked() {
        this.mState = 1;
        this.mNextFrameToDecode = (this.mNextFrameToDecode + 1) % this.mFrameSequence.getFrameCount();
        if (sDecodingThreadHandler != null) {
            sDecodingThreadHandler.removeCallbacks(this.mDecodeRunnable);
            sDecodingThreadHandler.post(this.mDecodeRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl2 = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNextFrameToDecode >= 0 && this.mState == 3) {
                this.mState = 4;
                bl2 = true;
            }
        }
        if (bl2) {
            this.invalidateSelf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.isRunning()) {
            if (this.isDestroyed()) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.mState == 1) {
                    return;
                }
                this.mCurrentLoop = 0;
                this.scheduleDecodeLocked();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.unscheduleSelf(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextFrameToDecode > -1 && !this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unscheduleSelf(Runnable runnable) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNextFrameToDecode = -1;
            this.mState = 0;
        }
        super.unscheduleSelf(runnable);
    }

    public boolean setVisible(boolean bl2, boolean bl3) {
        boolean bl4 = super.setVisible(bl2, bl3);
        return bl4;
    }

    public void setFilterBitmap(boolean bl2) {
        this.mPaint.setFilterBitmap(bl2);
    }

    public void setAlpha(int n2) {
        this.mPaint.setAlpha(n2);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return this.mFrameSequence.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mFrameSequence.getHeight();
    }

    public int getOpacity() {
        return this.mFrameSequence.isOpaque() ? -1 : -2;
    }

    public int getSize() {
        return this.mFrameSequence.getWidth() * this.mFrameSequence.getHeight() * 4;
    }

    static {
        sAllocatingBitmapProvider = new a(){

            @Override
            public Bitmap a(int n2, int n3) {
                return Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }

            @Override
            public void a(Bitmap bitmap) {
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
            }
        };
    }

    public static interface a {
        public Bitmap a(int var1, int var2);

        public void a(Bitmap var1);
    }

    public static interface b {
        public void a(FrameSequenceDrawable var1);
    }
}

