/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras;

import io.github.flbulgarelli.jpa.extras.WithEntityManager;
import java.util.function.Supplier;
import javax.persistence.EntityTransaction;

public interface TransactionalOps
extends WithEntityManager {
    default public void withTransaction(Runnable action) {
        this.withTransaction(() -> {
            action.run();
            return null;
        });
    }

    default public <A> A withTransaction(Supplier<A> action) {
        this.beginTransaction();
        try {
            A result = action.get();
            this.commitTransaction();
            return result;
        }
        catch (Throwable e) {
            this.rollbackTransaction();
            throw e;
        }
    }

    default public EntityTransaction getTransaction() {
        return this.entityManager().getTransaction();
    }

    default public EntityTransaction beginTransaction() {
        EntityTransaction tx = this.getTransaction();
        if (!tx.isActive()) {
            tx.begin();
        }
        return tx;
    }

    default public void commitTransaction() {
        EntityTransaction tx = this.getTransaction();
        if (tx.isActive()) {
            tx.commit();
        }
    }

    default public void rollbackTransaction() {
        EntityTransaction tx = this.getTransaction();
        if (tx.isActive()) {
            tx.rollback();
        }
    }
}

