/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class LambdaConverter
implements AttributeConverter<Object, byte[]> {
    public byte[] convertToDatabaseColumn(Object lambda) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
        try {
            objectOutputStream.writeObject(lambda);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        objectOutputStream.close();
        return byArray;
    }

    public Object convertToEntityAttribute(byte[] lambdaClassBytes) {
        Object object;
        ByteArrayInputStream in = new ByteArrayInputStream(lambdaClassBytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(in);
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        objectInputStream.close();
        return object;
    }
}

