/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras.export;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hibernate.boot.Metadata;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public class JpaSchemaExport {
    public static void main(String[] args) {
        CommandLine cmd = JpaSchemaExport.parse(args).orElseGet(() -> {
            System.exit(1);
            return null;
        });
        JpaSchemaExport.execute(cmd.getOptionValue("target", "simple-persistence-unit"), cmd.getOptionValue("output", "schema.sql"), cmd.hasOption("format"));
    }

    public static Optional<CommandLine> parse(String[] args) {
        Options options = new Options().addOption("h", "help", false, "Print this message.").addOption("f", "format", false, "If the output file should be formatted. Defaults to 'false'.").addOption("o", "output", true, "Output file. Defaults to 'schema.sql'.").addOption("t", "target", true, "Target persistence unit. Defaults to 'simple-persistence-unit'.");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            return Optional.of(parser.parse(options, args));
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("JpaSchemaExport [...options]", options);
            return Optional.empty();
        }
    }

    public static void execute(final String persistenceUnitName, final String destination, final boolean format) {
        System.out.println("Starting schema export");
        new HibernatePersistenceProvider(){
            {
                EntityManagerFactoryBuilderImpl emfb = (EntityManagerFactoryBuilderImpl)this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, new HashMap());
                emfb.generateSchema();
                SchemaExport schemaExport = new SchemaExport().setOutputFile(destination).setFormat(format);
                schemaExport.createOnly(EnumSet.of(TargetType.DATABASE, TargetType.SCRIPT), (Metadata)emfb.getMetadata());
                System.out.println("Schema exported to " + destination);
            }
        };
    }
}

