/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras.perthread;

import io.github.flbulgarelli.jpa.extras.perthread.PerThreadEntityManagerProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class PerThreadEntityManagerAccess {
    private final String persistenceUnitName;
    private final ConcurrentHashMap<String, EntityManagerFactory> emfHolder;
    private final ThreadLocal<EntityManager> threadLocal;
    private final PerThreadEntityManagerProperties properties;

    public PerThreadEntityManagerAccess(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
        this.emfHolder = new ConcurrentHashMap(1);
        this.threadLocal = new ThreadLocal();
        this.properties = new PerThreadEntityManagerProperties();
    }

    private void ensureNotInitialized() {
        if (this.emfHolder.containsKey(this.persistenceUnitName)) {
            throw new IllegalStateException("Can not set properties after initialization");
        }
    }

    public void configure(Consumer<PerThreadEntityManagerProperties> propertiesConsumer) {
        this.ensureNotInitialized();
        propertiesConsumer.accept(this.properties);
    }

    private EntityManagerFactory getEmf() {
        return this.emfHolder.computeIfAbsent(this.persistenceUnitName, name -> Persistence.createEntityManagerFactory((String)name, (Map)this.properties.get()));
    }

    public void shutdown() {
        this.getEmf().close();
    }

    public boolean isActive() {
        return this.getEmf().isOpen();
    }

    private void ensureActive() {
        if (!this.getEmf().isOpen()) {
            throw new IllegalStateException("Can not get an entity manager before initialize or after shutdown");
        }
    }

    public EntityManager get() {
        this.ensureActive();
        EntityManager manager = this.threadLocal.get();
        if (manager == null || !manager.isOpen()) {
            manager = this.getEmf().createEntityManager();
            this.threadLocal.set(manager);
        }
        return manager;
    }

    public boolean isAttached() {
        this.ensureActive();
        return this.threadLocal.get() != null;
    }

    public void dispose() {
        this.ensureActive();
        EntityManager em = this.threadLocal.get();
        if (em != null) {
            em.close();
            this.threadLocal.remove();
        }
    }
}

