/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras.perthread;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;

public class PerThreadEntityManagerProperties {
    private final Properties properties = new Properties();

    public PerThreadEntityManagerProperties set(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public <K, V> PerThreadEntityManagerProperties putAll(Map<K, V> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public PerThreadEntityManagerProperties load(String path) {
        try (InputStream stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            this.properties.load(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public Properties get() {
        return this.properties;
    }
}

