/*
 * Decompiled with CFR 0.152.
 */
package io.github.flbulgarelli.jpa.extras.simple;

import io.github.flbulgarelli.jpa.extras.EntityManagerOps;
import io.github.flbulgarelli.jpa.extras.TransactionalOps;
import io.github.flbulgarelli.jpa.extras.perthread.PerThreadEntityManagerAccess;
import io.github.flbulgarelli.jpa.extras.perthread.PerThreadEntityManagerProperties;
import io.github.flbulgarelli.jpa.extras.perthread.WithPerThreadEntityManager;
import java.util.function.Consumer;

public interface WithSimplePersistenceUnit
extends WithPerThreadEntityManager,
EntityManagerOps,
TransactionalOps {
    public static final String SIMPLE_PERSISTENCE_UNIT_NAME = "simple-persistence-unit";
    public static final PerThreadEntityManagerAccess PER_THREAD_ENTITY_MANAGER_ACCESS = new PerThreadEntityManagerAccess("simple-persistence-unit");

    @Override
    default public PerThreadEntityManagerAccess perThreadEntityManagerAccess() {
        return PER_THREAD_ENTITY_MANAGER_ACCESS;
    }

    public static void configure(Consumer<PerThreadEntityManagerProperties> propertiesConsumer) {
        PER_THREAD_ENTITY_MANAGER_ACCESS.configure(propertiesConsumer);
    }

    public static void shutdown() {
        WithSimplePersistenceUnit.dispose();
        PER_THREAD_ENTITY_MANAGER_ACCESS.shutdown();
    }

    public static void dispose() {
        if (PER_THREAD_ENTITY_MANAGER_ACCESS.isAttached()) {
            if (PER_THREAD_ENTITY_MANAGER_ACCESS.get().getTransaction().isActive()) {
                throw new IllegalStateException("Can not dispose entity manager if a transaction is active. Ensure it has been already terminated");
            }
            PER_THREAD_ENTITY_MANAGER_ACCESS.dispose();
        }
    }
}

