/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api;

import io.github.floriansw.ondus.api.WebFormLogin;
import io.github.floriansw.ondus.api.actions.ApplianceAction;
import io.github.floriansw.ondus.api.actions.DashboardAction;
import io.github.floriansw.ondus.api.actions.NotificationAction;
import io.github.floriansw.ondus.api.actions.RefreshTokenAction;
import io.github.floriansw.ondus.api.client.ApiClient;
import io.github.floriansw.ondus.api.model.ApplianceStatus;
import io.github.floriansw.ondus.api.model.BaseAppliance;
import io.github.floriansw.ondus.api.model.BaseApplianceCommand;
import io.github.floriansw.ondus.api.model.BaseApplianceData;
import io.github.floriansw.ondus.api.model.Notification;
import io.github.floriansw.ondus.api.model.RefreshTokenResponse;
import io.github.floriansw.ondus.api.model.Room;
import io.github.floriansw.ondus.api.model.guard.Appliance;
import io.github.floriansw.ondus.api.model.guard.ApplianceCommand;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.security.auth.login.LoginException;

public class OndusService {
    private static final String BASE_URL = "https://idp2-apigw.cloud.grohe.com";
    private RefreshTokenResponse refreshTokenResponse;
    ApiClient apiClient;

    public static OndusService login(String refreshToken) throws IOException, LoginException {
        return OndusService.login(refreshToken, new ApiClient(BASE_URL));
    }

    public static OndusService loginWebform(String username, String password) throws IOException, LoginException {
        RefreshTokenResponse response = new WebFormLogin(BASE_URL, username, password).login();
        return OndusService.login(response.getRefreshToken());
    }

    static OndusService login(String refreshToken, ApiClient apiClient) throws IOException, LoginException {
        OndusService service = new OndusService();
        service.apiClient = apiClient;
        RefreshTokenAction refreshTokenAction = apiClient.getAction(RefreshTokenAction.class);
        service.refreshTokenResponse = refreshTokenAction.refresh(refreshToken);
        apiClient.setToken(service.refreshTokenResponse.accessToken);
        return service;
    }

    OndusService() {
    }

    public Instant authorizationExpiresAt() {
        if (this.refreshTokenResponse == null) {
            return Instant.MAX;
        }
        return this.refreshTokenResponse.expiresAt();
    }

    public String refreshAuthorization() throws IOException, LoginException {
        if (this.refreshTokenResponse == null) {
            return null;
        }
        RefreshTokenAction refreshTokenAction = this.apiClient.getAction(RefreshTokenAction.class);
        this.refreshTokenResponse = refreshTokenAction.refresh(this.refreshTokenResponse.refreshToken);
        this.apiClient.setToken(this.refreshTokenResponse.accessToken);
        return this.refreshTokenResponse.refreshToken;
    }

    public List<BaseAppliance> appliances() throws IOException {
        DashboardAction action = this.apiClient.getAction(DashboardAction.class);
        return action.appliances();
    }

    public Optional<BaseAppliance> getAppliance(Room inRoom, String applianceId) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        return action.getAppliance(inRoom, applianceId);
    }

    public Optional<BaseApplianceData> applianceData(BaseAppliance appliance) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        return action.getApplianceData(appliance);
    }

    public Optional<BaseApplianceData> applianceData(BaseAppliance appliance, Instant from, Instant to) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        return action.getApplianceData(appliance, from, to);
    }

    public Optional<BaseApplianceCommand> applianceCommand(BaseAppliance appliance) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        return action.getApplianceCommand(appliance);
    }

    public Optional<ApplianceStatus> applianceStatus(BaseAppliance appliance) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        return action.getApplianceStatus(appliance);
    }

    public void setValveOpen(Appliance appliance, boolean open) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        Optional<BaseApplianceCommand> applianceCommandOptional = this.applianceCommand(appliance);
        if (!applianceCommandOptional.isPresent()) {
            return;
        }
        ApplianceCommand applianceCommand = (ApplianceCommand)applianceCommandOptional.get();
        ApplianceCommand.Command command = applianceCommand.getCommand();
        command.setValveOpen(open);
        applianceCommand.setCommand(command);
        action.putApplianceCommand(appliance, applianceCommand);
    }

    public void updateAppliance(BaseAppliance appliance) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        action.putAppliance(appliance);
    }

    public void sendCommand(BaseApplianceCommand command) throws IOException {
        ApplianceAction action = this.apiClient.getAction(ApplianceAction.class);
        BaseAppliance appliance = this.appliances().stream().filter(a -> a.getApplianceId().equals(command.applianceId)).findFirst().orElseThrow(() -> new IllegalArgumentException("The appliance with the ID " + command.applianceId + " does not exist in your account"));
        action.putApplianceCommand(appliance, command);
    }

    public List<Notification> notifications(BaseAppliance appliance) throws IOException {
        NotificationAction action = this.apiClient.getAction(NotificationAction.class);
        return action.notifications(appliance);
    }

    public void read(BaseAppliance appliance, Notification notification) throws IOException {
        NotificationAction action = this.apiClient.getAction(NotificationAction.class);
        action.read(appliance, notification);
    }
}

