/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.floriansw.ondus.api.client.HttpClient;
import io.github.floriansw.ondus.api.model.RefreshTokenResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.apache.commons.text.StringEscapeUtils;

class WebFormLogin {
    private static final Pattern ACTION_PATTERN = Pattern.compile("action=\"([^\"]*)\"");
    private static final String WRONG_USERNAME_PASSWORD = "Invalid email address or password";
    private String baseUrl;
    private String username;
    private String password;
    private HttpClient httpClient;

    WebFormLogin(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
        this.httpClient = HttpClient.createDefault();
    }

    void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    RefreshTokenResponse login() throws IOException, LoginException {
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        URL url = new URL(this.baseUrl + "/v3/iot/oidc/login");
        HttpURLConnection connection = this.httpClient.openConnection(url);
        connection.setRequestMethod("GET");
        try (InputStream inputStream = connection.getInputStream();){
            RefreshTokenResponse refreshTokenResponse = this.login(this.formTargetOf(this.extractContentFromResponse(inputStream)));
            return refreshTokenResponse;
        }
    }

    private String extractContentFromResponse(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toString();
    }

    private String formTargetOf(String page) throws IOException {
        Matcher matcher = ACTION_PATTERN.matcher(page);
        if (matcher.find()) {
            return StringEscapeUtils.unescapeHtml4((String)matcher.group(1));
        }
        throw new IOException("Unexpected result from Grohe API (login form target url not found)");
    }

    private RefreshTokenResponse login(String actionUrl) throws IOException, LoginException {
        URL url = new URL(actionUrl);
        HttpURLConnection connection = this.httpClient.openConnection(url);
        connection.setRequestMethod("POST");
        connection.setInstanceFollowRedirects(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
        connection.setRequestProperty("referer", actionUrl);
        connection.setRequestProperty("origin", this.baseUrl);
        connection.setDoOutput(true);
        try (DataOutputStream output = new DataOutputStream(connection.getOutputStream());){
            output.writeBytes(this.buildLoginRequest());
            output.flush();
        }
        this.assertOkResponse(connection);
        return this.fetchToken(this.fetchLocation(connection));
    }

    private String fetchLocation(HttpURLConnection connection) throws LoginException, IOException {
        String locationHeader = connection.getHeaderField("Location");
        if (locationHeader != null) {
            return locationHeader.replace("ondus://", "https://");
        }
        String content = this.extractContentFromResponse(connection.getInputStream());
        if (this.isWrongCredentials(content)) {
            throw new LoginException("Invalid username/password");
        }
        throw new LoginException("Unexpected response from grohe webservice");
    }

    private void assertOkResponse(HttpURLConnection connection) throws LoginException, IOException {
        int statusCode = connection.getResponseCode();
        if (statusCode != 200 && statusCode != 302) {
            throw new LoginException(String.format("Unknown response with code %d", statusCode));
        }
    }

    private boolean isWrongCredentials(String content) {
        return content.contains(WRONG_USERNAME_PASSWORD);
    }

    private String buildLoginRequest() throws UnsupportedEncodingException {
        return "username=" + URLEncoder.encode(this.username, "UTF-8") + "&password=" + URLEncoder.encode(this.password, "UTF-8");
    }

    private RefreshTokenResponse fetchToken(String location) throws IOException {
        URL url = new URL(location);
        HttpURLConnection connection = this.httpClient.openConnection(url);
        String tokenJson = this.extractContentFromResponse(connection.getInputStream());
        return (RefreshTokenResponse)new ObjectMapper().readValue(tokenJson, RefreshTokenResponse.class);
    }
}

