/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.floriansw.ondus.api.actions.AbstractAction;
import io.github.floriansw.ondus.api.client.ApiResponse;
import io.github.floriansw.ondus.api.model.RefreshTokenResponse;
import java.io.IOException;
import javax.security.auth.login.LoginException;

public class RefreshTokenAction
extends AbstractAction {
    private static final String REFRESH_URL = "/v3/iot/oidc/refresh";

    public RefreshTokenResponse refresh(String refreshToken) throws IOException, LoginException {
        ApiResponse<RefreshTokenResponse> refreshTokenResponse = this.getApiClient().post(REFRESH_URL, new RefreshTokenRequest(refreshToken), new TypeReference<RefreshTokenResponse>(){});
        if (refreshTokenResponse.getStatusCode() == 401) {
            throw new LoginException("401 - Unauthorized");
        }
        return refreshTokenResponse.getContent().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown response with code %d", refreshTokenResponse.getStatusCode())));
    }

    public static class RefreshTokenRequest {
        @JsonProperty(value="refresh_token")
        private String refreshToken;

        public RefreshTokenRequest(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshTokenRequest)) {
                return false;
            }
            RefreshTokenRequest other = (RefreshTokenRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshTokenRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            return result;
        }
    }
}

