/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.floriansw.ondus.api.actions.Action;
import io.github.floriansw.ondus.api.client.ApiResponse;
import io.github.floriansw.ondus.api.client.HttpClient;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;

public class ApiClient {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private String baseUrl;
    private HttpClient httpClient;
    private String token;
    private ObjectMapper mapper = new ObjectMapper();

    public ApiClient(String baseUrl) {
        this(baseUrl, HttpClient.createDefault());
    }

    ApiClient(String baseUrl, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
    }

    public <T> ApiResponse<T> get(String requestUrl, TypeReference<T> returnType) throws IOException {
        URL url = new URL(this.baseUrl + requestUrl);
        HttpURLConnection conn = this.httpClient.openConnection(url);
        conn.setRequestMethod("GET");
        conn.setRequestProperty(HEADER_AUTHORIZATION, this.authorization());
        return new ApiResponse<T>(conn, returnType);
    }

    private String authorization() {
        if (this.token == null) {
            return null;
        }
        return "Bearer " + this.token;
    }

    public <T> ApiResponse<T> post(String requestUrl, TypeReference<T> returnType) throws IOException {
        return this.post(requestUrl, Collections.emptyMap(), returnType);
    }

    public <T> ApiResponse<T> post(String requestUrl, Object body, TypeReference<T> returnType) throws IOException {
        URL url = new URL(this.baseUrl + requestUrl);
        HttpURLConnection conn = this.httpClient.openConnection(url);
        conn.setRequestMethod("POST");
        if (this.authorization() != null) {
            conn.setRequestProperty(HEADER_AUTHORIZATION, this.authorization());
        }
        conn.setRequestProperty(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
        this.writeBody(body, conn);
        return new ApiResponse<T>(conn, returnType);
    }

    public <T> ApiResponse<T> put(String requestUrl, Object body, TypeReference<T> returnType) throws IOException {
        URL url = new URL(this.baseUrl + requestUrl);
        HttpURLConnection conn = this.httpClient.openConnection(url);
        conn.setRequestMethod("PUT");
        if (this.authorization() != null) {
            conn.setRequestProperty(HEADER_AUTHORIZATION, this.authorization());
        }
        conn.setRequestProperty(HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
        this.writeBody(body, conn);
        return new ApiResponse<T>(conn, returnType);
    }

    private void writeBody(Object body, HttpURLConnection conn) throws IOException {
        String serializedParameters = this.mapper.writeValueAsString(body);
        conn.setDoOutput(true);
        DataOutputStream stream = new DataOutputStream(conn.getOutputStream());
        stream.writeBytes(serializedParameters);
        stream.flush();
        stream.close();
    }

    public <T extends Action> T getAction(Class<T> actionType) {
        Action action;
        try {
            action = (Action)actionType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        action.setApiClient(this);
        return (T)action;
    }

    public String apiPath() {
        return "/v3/";
    }

    public void setToken(String token) {
        this.token = token;
    }
}

