/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Optional;

public class ApiResponse<T> {
    private T mappedContent;
    private final int statusCode;
    private String content;

    public ApiResponse(HttpURLConnection conn, TypeReference<T> targetClass) throws IOException {
        this.statusCode = conn.getResponseCode();
        if (this.statusCode < 200 || this.statusCode > 299) {
            try (InputStream inputStream = conn.getErrorStream();){
                this.extractContentFromResponse(inputStream);
            }
            this.mappedContent = null;
        } else {
            if (targetClass.getType().equals(Void.class)) {
                return;
            }
            try (InputStream inputStream = conn.getInputStream();){
                this.extractContentFromResponse(inputStream);
                ObjectMapper mapper = new ObjectMapper();
                this.mappedContent = mapper.readValue(this.content, targetClass);
            }
        }
        if ("1".equals(System.getProperty("org.grohe.ondus.api.client::debug"))) {
            System.out.println("Received response for " + conn.getRequestMethod() + " " + conn.getURL().toString() + ". Status: " + this.statusCode + ", Content: " + this.content);
        }
    }

    private void extractContentFromResponse(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        this.content = buf.toString();
    }

    public Optional<T> getContent() {
        return Optional.ofNullable(this.mappedContent);
    }

    public <E extends T> Optional<E> getContentAs(Class<E> targetClass) {
        Object contentForTargetClass = null;
        try {
            contentForTargetClass = new ObjectMapper().readValue(this.content, targetClass);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.ofNullable(contentForTargetClass);
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

