/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.github.floriansw.ondus.api.model.BaseAppliance;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApplianceStatus {
    private static final String TYPE_BATTERY = "battery";
    private static final String TYPE_UPDATE_AVAILABLE = "update_available";
    private BaseAppliance appliance = new BaseAppliance();
    private List<ApplianceStatusModel> statuses;

    public ApplianceStatus(BaseAppliance appliance) {
        this.appliance = appliance;
    }

    public ApplianceStatus(BaseAppliance appliance, ApplianceStatusModel[] applianceStatuses) {
        this(appliance);
        this.statuses = Arrays.asList(applianceStatuses);
    }

    public String getApplianceId() {
        return this.appliance.getApplianceId();
    }

    public int getBatteryStatus() {
        return this.statuses.stream().filter(status -> TYPE_BATTERY.equals(status.getType())).findFirst().map(applianceStatusModel -> Integer.valueOf(applianceStatusModel.getValue())).orElse(-1);
    }

    public boolean isUpdateAvailable() {
        return this.statuses.stream().filter(status -> TYPE_UPDATE_AVAILABLE.equals(status.getType())).findFirst().map(applianceStatusModel -> applianceStatusModel.getValue().equals("1")).orElse(false);
    }

    public BaseAppliance getAppliance() {
        return this.appliance;
    }

    public List<ApplianceStatusModel> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<ApplianceStatusModel> statuses) {
        this.statuses = statuses;
    }

    public ApplianceStatus() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplianceStatus)) {
            return false;
        }
        ApplianceStatus other = (ApplianceStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseAppliance this$appliance = this.getAppliance();
        BaseAppliance other$appliance = other.getAppliance();
        return !(this$appliance == null ? other$appliance != null : !((Object)this$appliance).equals(other$appliance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplianceStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseAppliance $appliance = this.getAppliance();
        result = result * 59 + ($appliance == null ? 43 : ((Object)$appliance).hashCode());
        return result;
    }

    public void setAppliance(BaseAppliance appliance) {
        this.appliance = appliance;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplianceStatusModel {
        private String type;
        private String value;

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public ApplianceStatusModel() {
        }

        public ApplianceStatusModel(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplianceStatusModel)) {
                return false;
            }
            ApplianceStatusModel other = (ApplianceStatusModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplianceStatusModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

