/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.floriansw.ondus.api.model.BaseAppliance;
import io.github.floriansw.ondus.api.model.Location;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Room {
    private int id;
    private String name;
    private int type;
    private String role;
    @JsonIgnore
    private Location location = new Location();
    @JsonProperty(value="appliances")
    private List<JsonNode> appliancesAsJson = Collections.emptyList();
    @JsonIgnore
    private ObjectMapper mapper = new ObjectMapper();

    public List<BaseAppliance> getAppliances() {
        return this.appliancesAsJson.stream().map(node -> {
            try {
                Class<? extends BaseAppliance> clazz = BaseAppliance.classOfType(node.get("type").asInt());
                return (BaseAppliance)this.mapper.readValue(node.toString(), clazz);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert appliance from string.", e);
            }
        }).collect(Collectors.toList());
    }

    public Room(int id, Location location) {
        this.id = id;
        this.location = location;
    }

    public Room() {
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getRole() {
        return this.role;
    }

    public Location getLocation() {
        return this.location;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setAppliancesAsJson(List<JsonNode> appliancesAsJson) {
        this.appliancesAsJson = appliancesAsJson;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Room)) {
            return false;
        }
        Room other = (Room)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Room;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        return result;
    }
}

