/*
 * Decompiled with CFR 0.152.
 */
package io.github.floriansw.ondus.api.model.blue;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Config {
    @JsonProperty(value="co2_type")
    private int co2Type;
    @JsonProperty(value="hose_length")
    private int hoseLength;
    @JsonProperty(value="co2_consumption_medium")
    private int co2ConsumptionMedium;
    @JsonProperty(value="co2_consumption_carbonated")
    private int co2ConsumptionCarbonated;
    @JsonProperty(value="guest_mode_active")
    private boolean guestModeActive;
    @JsonProperty(value="auto_flush_active")
    private boolean autoFlushActive;
    @JsonProperty(value="flush_confirmed")
    private boolean flushConfirmed;
    @JsonProperty(value="f_parameter")
    private int fParameter;
    @JsonProperty(value="l_parameter")
    private int lParameter;
    @JsonProperty(value="flow_rate_still")
    private int flowRateStill;
    @JsonProperty(value="flow_rate_medium")
    private int flowRateMedium;
    @JsonProperty(value="flow_rate_carbonated")
    private int flowRateCarbonated;

    public void hoseLength(int newLength) {
        if (newLength < 0 || newLength > 500) {
            throw new IllegalArgumentException("Hose length needs to be between 0 and 500 cm.");
        }
        this.hoseLength = newLength;
    }

    public int getCo2Type() {
        return this.co2Type;
    }

    public int getHoseLength() {
        return this.hoseLength;
    }

    public int getCo2ConsumptionMedium() {
        return this.co2ConsumptionMedium;
    }

    public int getCo2ConsumptionCarbonated() {
        return this.co2ConsumptionCarbonated;
    }

    public boolean isGuestModeActive() {
        return this.guestModeActive;
    }

    public boolean isAutoFlushActive() {
        return this.autoFlushActive;
    }

    public boolean isFlushConfirmed() {
        return this.flushConfirmed;
    }

    public int getFParameter() {
        return this.fParameter;
    }

    public int getLParameter() {
        return this.lParameter;
    }

    public int getFlowRateStill() {
        return this.flowRateStill;
    }

    public int getFlowRateMedium() {
        return this.flowRateMedium;
    }

    public int getFlowRateCarbonated() {
        return this.flowRateCarbonated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCo2Type() != other.getCo2Type()) {
            return false;
        }
        if (this.getHoseLength() != other.getHoseLength()) {
            return false;
        }
        if (this.getCo2ConsumptionMedium() != other.getCo2ConsumptionMedium()) {
            return false;
        }
        if (this.getCo2ConsumptionCarbonated() != other.getCo2ConsumptionCarbonated()) {
            return false;
        }
        if (this.isGuestModeActive() != other.isGuestModeActive()) {
            return false;
        }
        if (this.isAutoFlushActive() != other.isAutoFlushActive()) {
            return false;
        }
        if (this.isFlushConfirmed() != other.isFlushConfirmed()) {
            return false;
        }
        if (this.getFParameter() != other.getFParameter()) {
            return false;
        }
        if (this.getLParameter() != other.getLParameter()) {
            return false;
        }
        if (this.getFlowRateStill() != other.getFlowRateStill()) {
            return false;
        }
        if (this.getFlowRateMedium() != other.getFlowRateMedium()) {
            return false;
        }
        return this.getFlowRateCarbonated() == other.getFlowRateCarbonated();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCo2Type();
        result = result * 59 + this.getHoseLength();
        result = result * 59 + this.getCo2ConsumptionMedium();
        result = result * 59 + this.getCo2ConsumptionCarbonated();
        result = result * 59 + (this.isGuestModeActive() ? 79 : 97);
        result = result * 59 + (this.isAutoFlushActive() ? 79 : 97);
        result = result * 59 + (this.isFlushConfirmed() ? 79 : 97);
        result = result * 59 + this.getFParameter();
        result = result * 59 + this.getLParameter();
        result = result * 59 + this.getFlowRateStill();
        result = result * 59 + this.getFlowRateMedium();
        result = result * 59 + this.getFlowRateCarbonated();
        return result;
    }
}

