/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.util.Auxiliary;
import java.nio.ByteBuffer;

public abstract class Base {
    public static final int ALL = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int NONE = 5;
    public static int LOGLEVEL = 0;

    public void debug(String message) {
        this.out("[DEBUG] ", message, 1);
    }

    public void debug(Object ... message) {
        this.out("[DEBUG] ", message, 1);
    }

    public void info(String message) {
        this.out("[INFO] ", message, 2);
    }

    public void info(Object ... message) {
        this.out("[INFO] ", message, 2);
    }

    public void warning(String message) {
        this.out("[WARNING] ", message, 3);
    }

    public void warning(Object ... message) {
        this.out("[WARNING] ", message, 3);
    }

    public void err(String message) {
        this.out("[ERROR] ", message, 4);
    }

    public void err(Object ... message) {
        this.out("[ERROR] ", message, 4);
    }

    private String objectArrayToMessage(Object[] message) {
        StringBuilder builder = new StringBuilder(message.length);
        for (Object o : message) {
            if (null == o) {
                builder.append("null");
                continue;
            }
            if (o instanceof byte[]) {
                builder.append(Auxiliary.bytesToHex((byte[])o));
                continue;
            }
            if (o instanceof ByteBuffer) {
                builder.append(Auxiliary.bytesToHex((ByteBuffer)o));
                continue;
            }
            builder.append(o.toString());
        }
        return builder.toString();
    }

    private void out(String prefix, String message, int level) {
        if (LOGLEVEL <= level) {
            System.out.println(prefix + message);
        }
    }

    private void out(String prefix, Object[] message, int level) {
        if (LOGLEVEL <= level) {
            System.out.println(prefix + this.objectArrayToMessage(message));
        }
    }

    public void debug(Object messageObject) {
        if (LOGLEVEL <= 1) {
            this.debug(messageObject.toString());
        }
    }

    public void info(Object messageObject) {
        if (LOGLEVEL <= 2) {
            this.info(messageObject.toString());
        }
    }

    public void warning(Object messageObject) {
        if (LOGLEVEL <= 3) {
            this.warning(messageObject.toString());
        }
    }
}

