/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Job;
import fqlite.base.SqliteInternalRow;
import fqlite.descriptor.TableDescriptor;
import fqlite.pattern.MatchingMode;
import fqlite.pattern.SerialTypeMatcher;
import fqlite.util.Auxiliary;
import fqlite.util.CarvingResult;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class Carver
extends Base {
    ByteBuffer block;
    BitSet bs;
    Job job;
    int pagenumber;

    public Carver(Job job, ByteBuffer bl, BitSet bs, int pagenumber) {
        this.job = job;
        this.block = bl;
        this.bs = bs;
        this.pagenumber = pagenumber;
    }

    public int carve(int fromidx, int toidx, SerialTypeMatcher mat, int headertype, TableDescriptor tbd, StringBuffer firstcol) {
        Auxiliary c = new Auxiliary(this.job);
        switch (headertype) {
            case 0: {
                mat.setMatchingMode(MatchingMode.NORMAL);
                break;
            }
            case 1: {
                mat.setMatchingMode(MatchingMode.NOHEADER);
                break;
            }
            case 2: {
                mat.setMatchingMode(MatchingMode.NO1stCOL);
            }
        }
        if (toidx - fromidx <= 4) {
            return -1;
        }
        mat.region(fromidx, toidx);
        mat.setPattern(tbd.getHpattern());
        while (mat.find()) {
            int from;
            String m = mat.group2Hex();
            if (m.length() < 2 || m.startsWith("00000000") || this.bs.get(from = mat.start())) continue;
            int end = mat.end();
            this.debug("Match (0..NORMAL, 1..NOLENGTH, 2..FIRSTCOLMISSING) : ", headertype);
            this.debug("found ", m);
            this.debug("Match: ", m, " on pos:", (this.pagenumber - 1) * this.job.ps + from);
            boolean missing = false;
            if (headertype == 0) {
                if (m.length() >= 4) {
                    firstcol.insert(0, m.substring(2, 4));
                } else {
                    missing = true;
                }
            }
            if (headertype == 1 && m.length() >= 2) {
                firstcol.insert(0, m.substring(0, 2));
                m = this.addHeaderByte(m);
            }
            if (headertype == 2 || missing) {
                m = null != firstcol && firstcol.length() >= 2 && !firstcol.subSequence(0, 2).equals("00") ? firstcol.substring(0, 2) + m : (tbd.primarykeycolumns != null ? "00" + m : "02" + m);
                m = this.addHeaderByte(m);
            }
            try {
                CarvingResult res;
                if (this.pagenumber > this.job.numberofpages || null == (res = c.readDeletedRecord(this.job, end, this.block, m, this.bs, this.pagenumber))) continue;
                SqliteInternalRow row = res.row;
                if (headertype > 1 && res.rcursor + 4 <= toidx) {
                    mat.region(res.rcursor + 4, toidx);
                }
                if (null == row) continue;
                row.setTableName(tbd.tblname);
                row.setRecordType("D");
                this.job.addRow(row);
            }
            catch (Exception err) {
                this.warning("Could not read record", err);
                return -1;
            }
        }
        return 0;
    }

    private String addHeaderByte(String s) {
        int hl = s.length() / 2 + 1;
        String hls = Integer.toHexString(hl);
        if (hls.length() == 1) {
            hls = "0" + hls;
        }
        return hls + s;
    }
}

