/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Global;
import fqlite.base.RecoveryTask;
import fqlite.base.RollbackJournalReaderBase;
import fqlite.base.SqliteInternalRow;
import fqlite.base.SqliteRow;
import fqlite.base.WALReaderBase;
import fqlite.descriptor.AbstractDescriptor;
import fqlite.descriptor.IndexDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.parser.SQLiteSchemaParser;
import fqlite.util.Auxiliary;
import fqlite.util.ByteSeqSearcher;
import fqlite.util.Logger;
import fqlite.util.LongPositionByteBuffer;
import fqlite.util.LongPositionByteBufferWrapper;
import fqlite.util.RandomAccessFileReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Job
extends Base {
    public boolean readWAL = false;
    String walpath = null;
    WALReaderBase wal = null;
    public boolean readRollbackJournal = false;
    public boolean collectInternalRows = true;
    String rollbackjournalpath = null;
    RollbackJournalReaderBase rol = null;
    static final String MAGIC_HEADER_STRING = "53514c69746520666f726d6174203300";
    static final String NO_AUTO_VACUUM = "00000000";
    static final String NO_MORE_ENTRIES = "00000000";
    static final String LEAF_PAGE = "0d";
    static final String INTERIOR_PAGE = "05";
    static final String ROW_ID = "00";
    String path;
    public RandomAccessFileReader file;
    public Charset db_encoding = StandardCharsets.UTF_8;
    private Queue<SqliteInternalRow> ll = new ConcurrentLinkedQueue<SqliteInternalRow>();
    private Map<String, List<SqliteRow>> tableRows = new LinkedHashMap<String, List<SqliteRow>>();
    private Map<String, Map<String, Integer>> colIdxMaps = new HashMap<String, Map<String, Integer>>();
    private Auxiliary aux = new Auxiliary(this);
    String headerstring;
    byte ffwversion;
    byte ffrversion;
    byte reservedspace;
    byte maxpayloadfrac;
    byte minpayloadfrac;
    byte leafpayloadfrac;
    long filechangecounter;
    long inheaderdbsize;
    long sizeinpages;
    long schemacookie;
    long schemaformatnumber;
    long defaultpagecachesize;
    long userversion;
    long vacuummode;
    long versionvalidfornumber;
    long avacc;
    public Map<String, TableDescriptor> virtualTables = new LinkedHashMap<String, TableDescriptor>();
    int scanned_entries = 0;
    Hashtable<String, String> tblSig;
    boolean is_default = false;
    public Map<String, TableDescriptor> headers = new LinkedHashMap<String, TableDescriptor>();
    public Map<String, IndexDescriptor> indices = new LinkedHashMap<String, IndexDescriptor>();
    public AtomicInteger runningTasks = new AtomicInteger();
    AtomicInteger numberofcells = new AtomicInteger();
    Set<Integer> allreadyvisit;
    public AbstractDescriptor[] pages;
    int[] pagetype;
    public int ps = 0;
    public int numberofpages = 0;
    int fpnumber = 0;
    int fphead = 0;
    String sqliteversion = "";
    boolean autovacuum = false;
    AtomicReferenceArray<Boolean> checked;
    public AtomicInteger hits = new AtomicInteger();
    private Deque<Closeable> resourcesToClose = new LinkedList<Closeable>();
    public boolean recoverOnlyDeletedRecords = false;
    public SQLiteSchemaParser schemaParser = new SQLiteSchemaParser();
    private Object lock = new Object();

    private RandomAccessFileReader readWAL(String walpath) throws IOException {
        Path p = Paths.get(walpath, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            return null;
        }
        RandomAccessFileReader file = new RandomAccessFileReader(p);
        this.resourcesToClose.addFirst(file);
        return file;
    }

    protected void tableDescriptorReady(TableDescriptor td) {
    }

    protected void indexDescriptorReady(IndexDescriptor id) {
    }

    protected void unassignedTableCreated(TableDescriptor td) {
    }

    protected void linesReady() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processDB() throws InterruptedException, ExecutionException, IOException {
        this.allreadyvisit = ConcurrentHashMap.newKeySet();
        LinkedList<TableDescriptor> recoveryTables = new LinkedList<TableDescriptor>();
        try {
            Path p = Paths.get(this.path, new String[0]);
            this.file = new RandomAccessFileReader(p);
            this.resourcesToClose.add(this.file);
            ByteBuffer buffer = this.file.allocateAndReadBuffer(100);
            if (buffer == null) {
                int n = -1;
                return n;
            }
            byte[] header = new byte[16];
            buffer.get(header);
            this.headerstring = Auxiliary.bytesToHex(header);
            char[] charArray = new char[16];
            int cn = 0;
            for (byte b : header) {
                charArray[cn] = (char)b;
                ++cn;
            }
            String txt = new String(charArray);
            this.headerstring = txt + " (0x" + this.headerstring + ")";
            if (!Auxiliary.bytesToHex(header).equals(MAGIC_HEADER_STRING)) {
                this.info("sorry. doesn't seem to be an sqlite file. Wrong header.");
                this.err("Doesn't seem to be an valid sqlite file. Wrong header");
                int n = -1;
                return n;
            }
            this.info("header is okay. seems to be an sqlite database file.");
            buffer.position(18);
            this.ffwversion = buffer.get();
            this.info("File format write version. 1 for legacy; 2 for WAL. ", this.ffwversion);
            buffer.position(19);
            this.ffrversion = buffer.get();
            this.info("File format read version. 1 for legacy; 2 for WAL. ", this.ffrversion);
            buffer.position(20);
            this.reservedspace = buffer.get();
            this.info("Bytes of unused \"reserved\" space at the end of each page. Usually 0. ", this.reservedspace);
            this.maxpayloadfrac = buffer.get();
            this.info("Maximum embedded payload fraction. Must be 64.", this.maxpayloadfrac);
            this.minpayloadfrac = buffer.get();
            this.info("Minimum embedded payload fraction. Must be 32.", this.maxpayloadfrac);
            this.leafpayloadfrac = buffer.get();
            this.info("Leaf payload fraction. Must be 32.  ", this.leafpayloadfrac);
            buffer.position(16);
            this.inheaderdbsize = Integer.toUnsignedLong(buffer.getInt());
            if (this.inheaderdbsize == 1L) {
                this.inheaderdbsize = 65536L;
            }
            buffer.position(24);
            this.filechangecounter = Integer.toUnsignedLong(buffer.getInt());
            this.info("File change counter ", this.filechangecounter);
            buffer.position(28);
            this.sizeinpages = Integer.toUnsignedLong(buffer.getInt());
            this.info("Size of the database file in pages ", this.sizeinpages);
            buffer.position(40);
            this.schemacookie = Integer.toUnsignedLong(buffer.getInt());
            this.info("The schema cookie. (offset 40) ", this.schemacookie);
            this.schemaformatnumber = Integer.toUnsignedLong(buffer.getInt());
            this.info("The schema format number. (offset 44) ", this.schemaformatnumber);
            this.defaultpagecachesize = Integer.toUnsignedLong(buffer.getInt());
            this.info("Default page cache size. (offset 48) ", this.defaultpagecachesize);
            buffer.position(60);
            this.userversion = Integer.toUnsignedLong(buffer.getInt());
            this.info("User version (offset 60) ", this.userversion);
            this.vacuummode = Integer.toUnsignedLong(buffer.getInt());
            this.info("Incremential vacuum-mode (offset 64) ", this.vacuummode);
            buffer.position(92);
            this.versionvalidfornumber = Integer.toUnsignedLong(buffer.getInt());
            this.info("The version-valid-for number.  ", this.versionvalidfornumber);
            this.is_default = true;
            this.tblSig = new Hashtable();
            this.tblSig.put("", "default");
            this.info("found unkown sqlite-database.");
            buffer.position(52);
            this.avacc = Integer.toUnsignedLong(buffer.getInt());
            if (this.avacc == 0L) {
                this.info("Seems to be no AutoVacuum db. Nice :-).");
                this.autovacuum = true;
            } else {
                this.autovacuum = false;
            }
            byte[] encoding = new byte[4];
            buffer.position(56);
            buffer.get(encoding);
            int codepage = ByteBuffer.wrap(encoding).getInt();
            switch (codepage) {
                case 0: 
                case 1: {
                    this.db_encoding = StandardCharsets.UTF_8;
                    this.info("Database encoding: UTF_8");
                    break;
                }
                case 3: {
                    this.db_encoding = StandardCharsets.UTF_16BE;
                    this.info("Database encoding: UTF_16BE");
                    break;
                }
                case 2: {
                    this.db_encoding = StandardCharsets.UTF_16LE;
                    this.info("Database encoding: UTF_16LE");
                }
            }
            byte[] pagesize = new byte[2];
            buffer.position(16);
            buffer.get(pagesize);
            ByteBuffer psize = ByteBuffer.wrap(pagesize);
            this.ps = Auxiliary.TwoByteBuffertoInt(psize);
            if (this.ps == 0 || this.ps == 1) {
                this.ps = 65536;
            }
            this.info("page size ", this.ps, " Bytes ");
            long totalbytes = this.file.size();
            this.numberofpages = (int)(totalbytes / (long)this.ps);
            this.info("Number of pages:", this.numberofpages);
            byte[] version = new byte[4];
            buffer.position(96);
            buffer.get(version);
            Integer v = ByteBuffer.wrap(version).getInt();
            this.sqliteversion = "" + v;
            this.pages = new AbstractDescriptor[this.numberofpages + 1];
            this.pagetype = new int[this.numberofpages];
            this.checked = new AtomicReferenceArray<Boolean>(new Boolean[this.numberofpages]);
            byte[] tpattern = null;
            byte[] ipattern = null;
            int goback = 0;
            if (this.db_encoding == StandardCharsets.UTF_8) {
                tpattern = new byte[]{116, 97, 98, 108, 101};
                ipattern = new byte[]{105, 110, 100, 101, 120};
                goback = 11;
            } else if (this.db_encoding == StandardCharsets.UTF_16LE) {
                tpattern = new byte[]{116, 0, 97, 0, 98, 0, 108, 0, 101};
                ipattern = new byte[]{105, 0, 110, 0, 100, 0, 101, 0, 120};
                goback = 15;
            } else if (this.db_encoding == StandardCharsets.UTF_16BE) {
                tpattern = new byte[]{0, 116, 0, 97, 0, 98, 0, 108, 0, 101};
                ipattern = new byte[]{0, 105, 0, 110, 0, 100, 0, 101, 0, 120};
                goback = 15;
            }
            int goBack = goback;
            ByteSeqSearcher btsearch = new ByteSeqSearcher(tpattern);
            ByteSeqSearcher bisearch = new ByteSeqSearcher(ipattern);
            boolean again = false;
            int round = 0;
            RandomAccessFileReader bb = this.file;
            this.exploreBTree(1, pageNumber -> this.readDBSchema(new LongPositionByteBufferWrapper(this.readPageWithNumber(pageNumber - 1, this.ps)), goBack, btsearch, bisearch, 1, true));
            while (++round != 2 || this.readWAL) {
                this.readDBSchema(bb, goback, btsearch, bisearch, round, false);
                this.info("headers:::: ", this.headers.size());
                if (this.headers.size() == 0 && this.readWAL) {
                    this.info("Could not find a schema definition inside the main db-file. Try to find something inside the WAL archive");
                    bb = this.readWAL(this.path + "-wal");
                    if (null != bb) {
                        again = true;
                    }
                }
                if (again && round < 2 && this.readWAL && !this.readRollbackJournal) continue;
            }
            for (IndexDescriptor id : this.indices.values()) {
                TableDescriptor td;
                String tbn = id.tablename;
                if (null == tbn || null == (td = this.headers.get(tbn))) continue;
                List<String> idname = id.columnnames;
                List<String> tdnames = td.columnnames;
                for (int z = 0; z < idname.size(); ++z) {
                    if (!tdnames.contains(idname.get(z))) continue;
                    try {
                        int match = tdnames.indexOf(idname.get(z));
                        String type = td.getColumntypes().get(match);
                        id.columntypes.add(type);
                        this.info("ADDING IDX TYPE::: ", type, " FOR TABLE ", td.tblname, " INDEx ", id.idxname);
                        continue;
                    }
                    catch (Exception err) {
                        id.columntypes.add("");
                    }
                }
                id.columnnames.add("rowid");
                id.columntypes.add("INT");
                Auxiliary.addHeadPattern2Idx(id);
                this.exploreBTree(id.getRootOffset(), pageNumber -> {
                    if (null == this.pages[pageNumber]) {
                        this.pages[pageNumber] = id;
                    }
                });
            }
            for (TableDescriptor td : this.headers.values()) {
                td.printTableDefinition();
                this.info(" root offset for component ", td.getRootOffset());
                String signature = td.getSignature();
                this.info(" signature ", signature);
                if (signature != null && signature.length() > 0) {
                    this.tblSig.put(td.getSignature(), td.tblname);
                }
                this.tableDescriptorReady(td);
                if (td.isVirtual()) continue;
                recoveryTables.add(td);
                this.exploreBTree(td.getRootOffset(), pageNumber -> {
                    if (null == this.pages[pageNumber]) {
                        this.pages[pageNumber] = td;
                    }
                });
            }
            for (IndexDescriptor id : this.indices.values()) {
                int r = id.getRootOffset();
                this.info(" root offset for index ", r);
                this.indexDescriptorReady(id);
            }
            ArrayList<String> col = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < 20; ++i) {
                col.add("TEXT");
                names.add("col" + (i + 1));
            }
            TableDescriptor tdefault = new TableDescriptor("__UNASSIGNED", "", col, col, names, null, null, null, false);
            this.headers.put(tdefault.getName(), tdefault);
            this.unassignedTableCreated(tdefault);
            byte[] freepageno = new byte[4];
            buffer.position(36);
            buffer.get(freepageno);
            this.info("Total number of free list pages ", freepageno);
            ByteBuffer no = ByteBuffer.wrap(freepageno);
            this.fpnumber = no.getInt();
            this.info(" no ", this.fpnumber);
            byte[] freelistpage = new byte[4];
            buffer.position(32);
            buffer.get(freelistpage);
            this.info("FreeListPage starts at offset ", freelistpage);
            ByteBuffer freelistoffset = ByteBuffer.wrap(freelistpage);
            int head = freelistoffset.getInt();
            this.info("head:: ", head);
            this.fphead = head;
            int start = (head - 1) * this.ps;
            if (head == 0) {
                this.info("INFO: Couldn't locate any free pages to recover. ");
            }
            if (head > 0) {
                ByteBuffer fplist;
                this.info("first:: ", start, " 0hx ", Integer.toHexString(start));
                long startfp = System.currentTimeMillis();
                this.info("Start free page recovery .....");
                ExecutorService executor = null;
                if (Global.numberofThreads > 0) {
                    executor = Executors.newFixedThreadPool(Global.numberofThreads);
                }
                boolean morelistpages = false;
                int freepagesum = 0;
                while ((fplist = this.file.allocateAndReadBuffer(start, this.ps)) != null) {
                    byte[] nextlistoffset = new byte[4];
                    try {
                        fplist.get(nextlistoffset);
                    }
                    catch (Exception err) {
                        this.debug("Warning Error while parsing free list.");
                    }
                    if (!Auxiliary.bytesToHex(nextlistoffset).equals("00000000")) {
                        ByteBuffer of = ByteBuffer.wrap(nextlistoffset);
                        int nfp = of.getInt();
                        start = (nfp - 1) * this.ps;
                        if (!this.allreadyvisit.contains(nfp)) {
                            this.allreadyvisit.add(nfp);
                            morelistpages = true;
                        } else {
                            this.info("Antiforensiscs found: cyclic freepage list entry");
                            morelistpages = false;
                        }
                    } else {
                        morelistpages = false;
                    }
                    byte[] numberOfEntries = new byte[4];
                    try {
                        fplist.get(numberOfEntries);
                    }
                    catch (Exception nfp) {
                        // empty catch block
                    }
                    ByteBuffer e = ByteBuffer.wrap(numberOfEntries);
                    int entries = e.getInt();
                    this.info(" Number of Entries in freepage list ", entries);
                    this.runningTasks.set(0);
                    for (int zz = 1; zz <= entries; ++zz) {
                        byte[] next = new byte[4];
                        fplist.position(4 * zz);
                        fplist.get(next);
                        ByteBuffer bf = ByteBuffer.wrap(next);
                        int n = bf.getInt();
                        if (n == 0) continue;
                        int offset = (n - 1) * this.ps;
                        RecoveryTask task = new RecoveryTask(this.aux, this, offset, n, this.ps, true, recoveryTables);
                        this.runningTasks.incrementAndGet();
                        if (executor != null) {
                            executor.execute(task);
                            continue;
                        }
                        task.runSingleThread();
                    }
                    freepagesum += entries;
                    if (morelistpages) continue;
                }
                this.info("Task total: ", this.runningTasks.intValue());
                if (executor != null) {
                    executor.shutdown();
                    executor.awaitTermination(1000L, TimeUnit.DAYS);
                }
                this.info("Number of cells ", this.numberofcells.intValue());
                this.info(" Finished. No further free pages. Scanned ", freepagesum);
                long endfp = System.currentTimeMillis();
                this.info("Duration of free page recovery in ms: ", endfp - startfp);
            }
            this.info("Lines after free page recovery: ", this.ll.size());
            this.scan(this.numberofpages, this.ps, recoveryTables);
            if (this.readRollbackJournal) {
                Logger.out.info(" RollbackJournal-File ", this.rollbackjournalpath);
                this.rol = new RollbackJournalReaderBase(this.rollbackjournalpath, this){

                    @Override
                    public void output() {
                    }
                };
                this.rol.ps = this.ps;
                this.rol.parse();
            }
            if (this.readWAL) {
                Logger.out.info(" WAL-File ", this.walpath);
                this.wal = new WALReaderBase(this.walpath, this){

                    @Override
                    public void output() {
                    }
                };
                this.wal.parse();
            }
            this.linesReady();
        }
        finally {
            this.closeResources();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getColIdxMapForTable(String tableName) {
        Object object = this.lock;
        synchronized (object) {
            TableDescriptor td;
            Map<String, Integer> colIdxMap = this.colIdxMaps.get(tableName);
            if (colIdxMap == null && (td = this.headers.get(tableName)) != null) {
                colIdxMap = new HashMap<String, Integer>();
                int id = 0;
                for (String col : td.columnnames) {
                    colIdxMap.put(col, id++);
                }
                this.colIdxMaps.put(tableName, colIdxMap);
            }
            return colIdxMap;
        }
    }

    protected void closeResources() {
        for (Closeable c : this.resourcesToClose) {
            try {
                c.close();
            }
            catch (IOException e) {
                this.err(e);
            }
        }
    }

    private void readDBSchema(LongPositionByteBuffer bb, int goback, ByteSeqSearcher btsearch, ByteSeqSearcher bisearch, int round, boolean isSinglePage) throws IOException {
        block0: for (ByteSeqSearcher bsearch : new ByteSeqSearcher[]{btsearch, bisearch}) {
            long index = bsearch.indexOf(bb, 0L);
            while (index != -1L) {
                int pagenumber;
                ByteBuffer bbb;
                int starthere;
                bb.position(index - (long)goback - 3L);
                int hsize = Math.min(40, (int)(bb.size() - bb.position()));
                if (hsize < 20) continue block0;
                byte[] mheader = new byte[hsize];
                bb.get(mheader);
                int[] valData = this.aux.validateIntactMasterTableHeader(mheader, goback + 3 - 5);
                int headerStart = valData[0];
                int headerSize = valData[1];
                if (headerStart != Integer.MIN_VALUE) {
                    if ((starthere = (int)(index % (long)this.ps) - goback + ++headerStart - 3) >= 0) {
                        bbb = null;
                        if (round == 1) {
                            if (isSinglePage) {
                                bbb = bb.allocateAndReadBuffer(0L, this.ps);
                            } else {
                                pagenumber = (int)(index / (long)this.ps);
                                bbb = this.readPageWithNumber(pagenumber, this.ps);
                            }
                        } else {
                            starthere = (int)((index - 32L) % (long)(this.ps + 24)) - goback + headerStart - 3;
                            bbb = bb.allocateAndReadBuffer(56L + index / (long)this.ps, this.ps);
                        }
                        if (bbb == null) continue block0;
                        this.aux.readMasterTableRecord(starthere, bbb, headerSize);
                    }
                } else {
                    valData = this.aux.validateOverwrittenMasterTableHeader(mheader, goback + 3 - 5);
                    headerStart = valData[0];
                    headerSize = valData[1];
                    if (headerStart != Integer.MIN_VALUE && (starthere = (int)(index % (long)this.ps) - goback - ++headerStart - 3) >= 0) {
                        bbb = null;
                        if (round == 1) {
                            if (isSinglePage) {
                                bbb = bb.allocateAndReadBuffer(0L, this.ps);
                            } else {
                                pagenumber = (int)(index / (long)this.ps);
                                bbb = this.readPageWithNumber(pagenumber, this.ps);
                            }
                        } else {
                            long pagebegin = 0L;
                            if (index < (long)(this.ps + 56)) {
                                pagebegin = 56L;
                                starthere = (int)(index - 56L) - goback - headerStart - 3;
                            } else {
                                pagebegin = (index - 32L) / (long)(this.ps + 24) * (long)(this.ps + 24) - 24L + 32L;
                                starthere = (int)((index - 32L) % (long)(this.ps + 24) + 24L) - goback - headerStart - 3;
                            }
                            bbb = this.file.allocateAndReadBuffer(pagebegin, this.ps);
                        }
                        if (bbb == null) continue block0;
                        this.aux.readMasterTableRecord(starthere, bbb, headerSize);
                    }
                }
                index = bsearch.indexOf(bb, index + 2L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(int number, int ps, List<TableDescriptor> recoveryTables) throws IOException {
        this.info("Start with scan...");
        ThreadPoolExecutor executor = null;
        if (Global.numberofThreads > 0) {
            executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(Global.numberofThreads);
        }
        long begin = System.currentTimeMillis();
        LinkedList<RecoveryTask> tasks = new LinkedList<RecoveryTask>();
        for (int cc = 1; cc < this.pages.length; ++cc) {
            if (null == this.pages[cc]) {
                this.debug("page ", cc, " is no regular leaf page component. Maybe a indices or overflow or dropped component page.");
                continue;
            }
            this.debug("page ", cc, " is a regular leaf page. ");
            long offset = (cc - 1) * ps;
            RecoveryTask task = new RecoveryTask(this.aux, this, offset, cc, ps, false, recoveryTables);
            tasks.add(task);
            this.runningTasks.incrementAndGet();
        }
        if (executor != null) {
            this.debug("Task total: ", this.runningTasks.intValue(), " worker threads ", Global.numberofThreads);
        }
        int c = 1;
        for (RecoveryTask t : tasks) {
            if (executor != null) {
                this.info(" Start worker thread", c++);
                executor.execute(t);
                continue;
            }
            t.runSingleThread();
        }
        try {
            if (executor != null) {
                executor.shutdown();
                executor.awaitTermination(10L, TimeUnit.DAYS);
            }
        }
        catch (InterruptedException e) {
            this.err("tasks interrupted");
        }
        finally {
            if (executor != null) {
                if (!executor.isTerminated()) {
                    System.err.println("cancel non-finished tasks");
                }
                executor.shutdownNow();
                this.info("shutdown finished");
            }
        }
        long ende = System.currentTimeMillis();
        this.info("Duration of scanning all pages in ms : ", ende - begin);
        this.info("End of Scan...");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setWALPath(String path) {
        this.walpath = path;
    }

    public void setRollbackJournalPath(String path) {
        this.rollbackjournalpath = path;
    }

    public void start() {
        if (this.path != null) {
            try {
                this.run(this.path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
    }

    public Job() {
        Base.LOGLEVEL = Global.LOGLEVEL;
    }

    public int run(String p) {
        int hashcode = -1;
        this.path = p;
        long start = System.currentTimeMillis();
        try {
            hashcode = this.processDB();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        this.info("Duration in ms: ", end - start);
        return hashcode;
    }

    public ByteBuffer readPageWithOffset(long offset, int pagesize) throws IOException {
        if (offset > this.file.size() || offset < 0L) {
            this.info(" offset greater than file size ?!", offset, " > ", this.file.size());
            Auxiliary.printStackTrace();
            return null;
        }
        return this.file.allocateAndReadBuffer(offset, pagesize);
    }

    public ByteBuffer readPageWithNumber(long pagenumber, int pagesize) throws IOException {
        if (pagenumber < 0L) {
            return null;
        }
        return this.readPageWithOffset(pagenumber * (long)pagesize, pagesize);
    }

    private void exploreBTree(int pageNumber, BTreePageVisitor visitor) throws IOException {
        int fileOffset = this.ps * (pageNumber - 1);
        if (fileOffset < 0 || pageNumber < 0) {
            return;
        }
        if ((long)fileOffset >= this.file.size()) {
            return;
        }
        int pageHeaderOffset = 0;
        if (pageNumber == 1) {
            pageHeaderOffset = 100;
        }
        this.file.position(fileOffset + pageHeaderOffset);
        byte pageType = this.file.get();
        int typ = Auxiliary.getPageType(pageType);
        if (typ == 2) {
            this.debug(" page number", pageNumber, " is a  INDEXINTERIORPAGE.");
        } else if (typ == 12) {
            this.debug("page number ", pageNumber, " is a interior data page ");
            ByteBuffer buffer = this.readPageWithNumber(pageNumber - 1, this.ps);
            if (buffer == null) {
                return;
            }
            byte[] numberofcells = new byte[2];
            buffer.position(pageHeaderOffset + 3);
            buffer.get(numberofcells);
            int e = Auxiliary.TwoByteBuffertoInt(numberofcells);
            for (int i = 0; i < e; ++i) {
                byte[] celladdr = new byte[2];
                buffer.position(pageHeaderOffset + 12 + 2 * i);
                if (buffer.capacity() <= buffer.position() + 2) continue;
                buffer.get(celladdr);
                int celloff = Auxiliary.TwoByteBuffertoInt(celladdr);
                byte[] pnext = new byte[4];
                if (celloff >= buffer.capacity() || celloff < 0 || celloff > this.ps) continue;
                buffer.position(celloff);
                buffer.get(pnext);
                int p = ByteBuffer.wrap(pnext).getInt();
                this.debug(" child page ", p);
                this.exploreBTree(p, visitor);
            }
            ByteBuffer rightChildptr = this.file.allocateAndReadBuffer(fileOffset + pageHeaderOffset + 8, 4);
            if (rightChildptr != null) {
                this.exploreBTree(rightChildptr.getInt(), visitor);
            }
        } else if (typ == 8 || typ == 10) {
            this.debug("page number ", pageNumber, " is a leaf page set component/index to sqlite schema ");
            if (pageNumber > this.numberofpages) {
                return;
            }
            visitor.visitLeafPage(pageNumber);
        }
    }

    public String[] getHeaderString(String tablename) {
        TableDescriptor td = this.headers.get(tablename);
        if (null != td) {
            return td.columnnames.toArray(new String[0]);
        }
        IndexDescriptor id = this.indices.get(tablename);
        if (null != id) {
            return id.columnnames.toArray(new String[0]);
        }
        return null;
    }

    public void writeResultsToFile(String filename, String[] lines) {
        this.info("Write results to file...");
        this.info("Number of records recovered: ", this.ll.size());
        if (null == filename) {
            Path dbfilename = Paths.get(this.path, new String[0]);
            String name = dbfilename.getFileName().toString();
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ISO_DATE_TIME;
            String date = df.format(now);
            date = date.replace(":", "_");
            filename = "results" + name + date + ".csv";
        }
        Arrays.sort(lines);
        try {
            File file = new File(filename);
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charset.forName("UTF-8"), StandardOpenOption.CREATE);){
                for (String line : lines) {
                    writer.write(line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(SqliteInternalRow row) {
        row.setColumnNamesMap(this.getColIdxMapForTable(row.getTableName()));
        if (this.recoverOnlyDeletedRecords && !row.isDeletedRow()) {
            return;
        }
        if (this.collectInternalRows) {
            this.ll.add(row);
        }
        Object object = this.lock;
        synchronized (object) {
            List<SqliteRow> tables = this.tableRows.get(row.getTableName());
            if (null == tables) {
                tables = new ArrayList<SqliteRow>();
                this.tableRows.put(row.getTableName(), tables);
            }
            SqliteRow decoded = row.decodeRow();
            decoded.setCharset(this.db_encoding);
            tables.add(row.decodeRow());
        }
    }

    public Queue<SqliteInternalRow> getRows() {
        return this.ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SqliteRow> getRowsForTable(String tableName) {
        Object object = this.lock;
        synchronized (object) {
            return this.tableRows.getOrDefault(tableName, Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<String> getTablesNames() {
        Object object = this.lock;
        synchronized (object) {
            return this.tableRows.keySet();
        }
    }

    private static interface BTreePageVisitor {
        public void visitLeafPage(int var1) throws IOException;
    }
}

