/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Job;
import fqlite.base.SqliteElement;
import fqlite.base.SqliteElementData;
import fqlite.base.SqliteInternalRow;
import fqlite.types.SerialTypes;
import fqlite.util.Auxiliary;
import fqlite.util.BufferUtil;
import fqlite.util.CarvingResult;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class PageReader
extends Base {
    private Job job;

    public PageReader(Job job) {
        this.job = job;
    }

    public void readMasterTableRecord(Job job, int start, ByteBuffer buffer, String header) throws IOException {
        buffer.position(start);
        SqliteElement[] columns = Auxiliary.toColumns(header, job.db_encoding);
        if (null == columns) {
            return;
        }
        int pll = Auxiliary.computePayloadLengthS(header);
        int so = Auxiliary.computePayloadS(pll, job.ps);
        int overflow = -1;
        if (so < pll) {
            ByteBuffer bf;
            int phl = header.length() / 2;
            int last = buffer.position();
            this.debug(" spilled payload ::", so);
            this.debug(" pll payload ::", pll);
            buffer.position(buffer.position() + so - phl - 1);
            overflow = buffer.getInt();
            this.debug(" overflow::::::::: ", overflow, " ", Integer.toHexString(overflow));
            buffer.position(last);
            byte[] extended = this.readOverflow(overflow - 1);
            byte[] c = BufferUtil.allocateByteBuffer(pll + job.ps);
            buffer.position(0);
            byte[] originalbuffer = BufferUtil.allocateByteBuffer(job.ps);
            for (int bb = 0; bb < job.ps; ++bb) {
                originalbuffer[bb] = buffer.get(bb);
            }
            buffer.position(last);
            System.arraycopy(originalbuffer, buffer.position(), c, 0, so - phl);
            System.arraycopy(extended, 0, c, so - phl - 1, extended.length);
            buffer = bf = ByteBuffer.wrap(c);
            buffer.position(0);
        }
        int con = 0;
        String tablename = null;
        int rootpage = -1;
        String statement = null;
        for (SqliteElement en : columns) {
            if (en == null) continue;
            byte[] value = null;
            value = BufferUtil.allocateByteBuffer(en.length);
            buffer.get(value);
            if (con == 3) {
                tablename = en.toString(value);
            }
            if (con == 4) {
                rootpage = SqliteElement.decodeInt8(value[0]);
            }
            if (con == 5) {
                statement = en.toString(value);
            }
            ++con;
        }
        job.schemaParser.parse(job, tablename, rootpage, statement);
    }

    public CarvingResult readDeletedRecord(Job job, int start, ByteBuffer buffer, String header, BitSet bs, int pagenumber) throws IOException {
        buffer.position(start);
        int recordstart = start - header.length() / 2 - 2;
        SqliteElement[] columns = Auxiliary.toColumns(header, job.db_encoding);
        if (null == columns) {
            return null;
        }
        SqliteInternalRow row = new SqliteInternalRow();
        String fp = null;
        try {
            fp = Auxiliary.getTableFingerPrint(columns);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null == fp) {
            fp = "unkown";
        }
        boolean error = false;
        row.setOffset((pagenumber - 1) * job.ps + buffer.position());
        int pll = Auxiliary.computePayloadLengthS(header);
        int so = Auxiliary.computePayloadS(pll, job.ps);
        int overflow = -1;
        if (so < pll) {
            ByteBuffer bf;
            int phl = header.length() / 2;
            int last = buffer.position();
            this.debug(" deleted spilled payload ::", so);
            this.debug(" deleted pll payload ::", pll);
            buffer.position(buffer.position() + so - phl - 1);
            overflow = buffer.getInt();
            this.debug(" deleted overflow::::::::: ", overflow, " ", Integer.toHexString(overflow));
            buffer.position(last);
            if (overflow < job.numberofpages) {
                byte[] byArray = this.readOverflow(overflow - 1);
                byte[] c = BufferUtil.allocateByteBuffer(pll + job.ps);
                buffer.position(0);
                byte[] originalbuffer = BufferUtil.allocateByteBuffer(job.ps);
                for (int bb = 0; bb < job.ps; ++bb) {
                    originalbuffer[bb] = buffer.get(bb);
                }
                buffer.position(last);
                System.arraycopy(originalbuffer, buffer.position(), c, 0, so - phl);
                System.arraycopy(byArray, 0, c, so - phl, byArray.length - so);
                bf = ByteBuffer.wrap(c);
            } else {
                pll = so;
                bf = buffer;
            }
            bf.position(0);
            for (SqliteElement en : columns) {
                if (en == null) continue;
                if (en.length == 0) {
                    if (en.type == SerialTypes.INT0) {
                        row.append(new SqliteElementData(en, 0L));
                        continue;
                    }
                    row.append(new SqliteElementData(null, job.db_encoding));
                    continue;
                }
                int len = en.length;
                try {
                    if (len > 0) {
                        byte[] value = BufferUtil.allocateByteBuffer(len);
                        bf.get(value);
                        row.append(new SqliteElementData(en, value));
                        continue;
                    }
                    row.append(new SqliteElementData(null, job.db_encoding));
                }
                catch (BufferUnderflowException bue) {
                    row.append(new SqliteElementData(null, job.db_encoding));
                    this.err("readRecord():: overflow java.nio.BufferUnderflowException");
                }
            }
            buffer.position(last + so - phl - 1);
        } else {
            for (SqliteElement sqliteElement : columns) {
                if (sqliteElement == null) continue;
                byte[] value = BufferUtil.allocateByteBuffer(sqliteElement.length);
                if (buffer.position() + sqliteElement.length > buffer.limit()) {
                    error = true;
                    return null;
                }
                buffer.get(value);
                row.append(new SqliteElementData(sqliteElement, value));
            }
            if (error) {
                return null;
            }
        }
        bs.set(recordstart, buffer.position() - 1, true);
        this.debug("Besucht :: ", recordstart, " to ", buffer.position());
        int cursor = (pagenumber - 1) * job.ps + buffer.position();
        this.debug("Besucht :: ", (pagenumber - 1) * job.ps + recordstart, " bis ", cursor);
        this.debug((Object)row);
        return new CarvingResult(buffer.position(), cursor, row);
    }

    private byte[] readOverflow(int pagenumber) throws IOException {
        byte[] part = null;
        ByteBuffer overflowpage = this.job.readPageWithNumber(pagenumber, this.job.ps);
        overflowpage.position(0);
        int overflow = overflowpage.getInt();
        this.debug(" overflow:: " + overflow);
        if (overflow == 0) {
            this.debug("No further overflow pages");
        } else {
            part = this.readOverflow(overflow);
        }
        byte[] current = BufferUtil.allocateByteBuffer(this.job.ps - 4);
        overflowpage.position(4);
        overflowpage.get(current, 0, this.job.ps - 4);
        if (null != part) {
            byte[] of = BufferUtil.allocateByteBuffer(current.length + part.length);
            System.arraycopy(current, 0, of, 0, current.length);
            System.arraycopy(part, 0, of, current.length, part.length);
            return of;
        }
        return current;
    }

    public SqliteElement[] getColumns(int headerlength, ByteBuffer buffer) throws IOException {
        byte[] header = BufferUtil.allocateByteBuffer(headerlength);
        try {
            buffer.get(header);
        }
        catch (Exception err) {
            this.err("ERROR " + err.toString());
        }
        this.debug("Header: ", header);
        return Auxiliary.convertHeaderToSqliteElements(header, this.job.db_encoding);
    }
}

