/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Carver;
import fqlite.base.Gap;
import fqlite.base.Job;
import fqlite.base.SqliteElementData;
import fqlite.base.SqliteInternalRow;
import fqlite.descriptor.AbstractDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.pattern.SerialTypeMatcher;
import fqlite.util.Auxiliary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;

public class RecoveryTask
extends Base
implements Runnable {
    public int pagesize;
    public long offset;
    public ByteBuffer buffer;
    public BitSet visit;
    private List<TableDescriptor> tables = new LinkedList<TableDescriptor>();
    public int pagenumber;
    private Job job;
    private Auxiliary ct;
    private StringBuffer firstcol = new StringBuffer();
    private boolean freeList = false;

    public RecoveryTask(Auxiliary ct, Job job, long offset, int pagenumber, int pagesize, boolean freeList, List<TableDescriptor> tables) throws IOException {
        if (job.file.size() < offset) {
            throw new IOException("offset is out of bounds");
        }
        this.job = job;
        this.pagesize = pagesize;
        this.offset = offset;
        this.pagenumber = pagenumber;
        this.ct = ct;
        this.freeList = freeList;
        this.tables = tables;
        this.visit = new BitSet(pagesize);
    }

    public int recover() throws IOException {
        SqliteInternalRow row;
        boolean withoutROWID = false;
        this.debug("Offset in recover()::", this.offset);
        this.buffer = this.job.readPageWithOffset(this.offset, this.pagesize);
        if (this.buffer == null) {
            return -1;
        }
        byte pageType = this.buffer.get();
        this.buffer.position(0);
        int type = Auxiliary.getPageType(pageType);
        this.visit.set(0, 2);
        if (type == 0) {
            this.buffer.position(0);
            Integer checksum = this.buffer.getInt();
            if (checksum == 0) {
                this.info(" DROPPED PAGE !!!");
                this.carve(null);
            }
            return 0;
        }
        if (type < 0) {
            this.info("No Data page. ", this.pagenumber);
            return -1;
        }
        if (type == 12) {
            this.info("Internal Table page ", this.pagenumber);
            return -1;
        }
        if (type == 10) {
            this.info("Index leaf page ", this.pagenumber);
            withoutROWID = true;
        } else {
            this.info("Data page ", this.pagenumber, " Offset: ", this.offset);
        }
        if (type == 8) {
            byte[] fboffset = new byte[2];
            this.buffer.position(1);
            this.buffer.get(fboffset);
        }
        int ccrstart = this.job.ps;
        byte[] cpn = new byte[2];
        this.buffer.position(3);
        this.buffer.get(cpn);
        byte[] ccr = new byte[2];
        this.buffer.position(5);
        this.buffer.get(ccr);
        ByteBuffer contentregionstart = ByteBuffer.wrap(ccr);
        ccrstart = Auxiliary.TwoByteBuffertoInt(contentregionstart);
        this.visit.set(2, 8);
        ByteBuffer size = ByteBuffer.wrap(cpn);
        int cp = Auxiliary.TwoByteBuffertoInt(size);
        this.debug(" number of cells: ", cp, " type of page ", type);
        this.job.numberofcells.addAndGet(cp);
        if (0 == cp) {
            this.debug(" Page seems to be dropped. No cell entries.");
        }
        int headerend = 8 + cp * 2;
        this.visit.set(0, headerend);
        int last = 0;
        for (int i = 0; i < cp; ++i) {
            String tbln;
            byte[] pointer = new byte[2];
            if (type == 5) {
                this.buffer.position(12 + 2 * i);
            } else {
                this.buffer.position(8 + 2 * i);
            }
            this.buffer.get(pointer);
            ByteBuffer celladdr = ByteBuffer.wrap(pointer);
            int celloff = Auxiliary.TwoByteBuffertoInt(celladdr);
            if (last > 0 && celloff == last) continue;
            last = celloff;
            SqliteInternalRow row2 = null;
            if (celloff < this.buffer.limit() - 20) {
                row2 = this.ct.readRecord(celloff, this.buffer, this.pagenumber, this.visit, type, Integer.MAX_VALUE, this.firstcol, withoutROWID, -1);
            }
            if (null == row2) continue;
            String tableName = row2.getTableName();
            int p = tableName.indexOf("_node;");
            if (p > 0 && this.job.virtualTables.containsKey(tbln = tableName.substring(0, p))) {
                TableDescriptor tds = this.job.virtualTables.get(tbln);
                String data = row2.getRowData().get(1).toString();
                byte[] binary = Auxiliary.decode(data);
                ByteBuffer bf = ByteBuffer.wrap(binary);
                bf.getShort();
                for (int entries = bf.getShort(); entries > 0; --entries) {
                    SqliteInternalRow vrow = new SqliteInternalRow();
                    vrow.setTableName(tbln);
                    vrow.setRecordType("VT");
                    vrow.setOffset(0L);
                    long primarykey = bf.getLong();
                    vrow.append(new SqliteElementData(primarykey, this.job.db_encoding));
                    for (int number = tds.columnnames.size() - 1; number > 0; --number) {
                        float rv = bf.getFloat();
                        vrow.append(new SqliteElementData(rv, this.job.db_encoding));
                    }
                    this.job.addRow(vrow);
                    this.info(vrow.toString());
                }
            }
            if (this.freeList) {
                row2.setRecordType("F" + row2.getRecordType());
            }
            this.job.addRow(row2);
        }
        this.buffer.position(headerend);
        byte[] garbage = new byte[2];
        int garbageoffset = -1;
        do {
            this.buffer.get(garbage);
            ByteBuffer ignore = ByteBuffer.wrap(garbage);
            garbageoffset = Auxiliary.TwoByteBuffertoInt(ignore);
        } while (this.buffer.position() < this.pagesize && garbageoffset > 0);
        byte zerob = 0;
        while (this.buffer.position() < this.pagesize && zerob == 0) {
            zerob = this.buffer.get();
        }
        this.visit.set(headerend, this.buffer.position());
        this.buffer.position(this.buffer.position() - 1);
        if (ccrstart - this.buffer.position() > 3 && null != (row = this.ct.readRecord(this.buffer.position(), this.buffer, this.pagenumber, this.visit, type, ccrstart - this.buffer.position(), this.firstcol, withoutROWID, -1))) {
            row.setRecordType("D" + row.getRecordType());
            this.job.addRow(row);
        }
        this.carve(null);
        return 0;
    }

    static boolean allCharactersZero(String s) {
        if (!s.startsWith("0000")) {
            return false;
        }
        int n = s.length();
        for (int i = 1; i < n; ++i) {
            if (s.charAt(i) == s.charAt(0)) continue;
            return false;
        }
        return true;
    }

    public LinkedList<Gap> findGaps() {
        LinkedList<Gap> gaps = new LinkedList<Gap>();
        int from = 0;
        for (int i = 0; i < this.pagesize; ++i) {
            if (this.visit.get(i)) continue;
            from = i;
            int to = i;
            while (!this.visit.get(++i) && i < this.pagesize - 1) {
                ++to;
            }
            if (to - from >= 4) {
                boolean isNull = false;
                if (this.buffer.get(from) == 0) {
                    isNull = true;
                    for (int index = from; index < to; ++index) {
                        if (0 == this.buffer.get(index)) continue;
                        isNull = false;
                    }
                }
                if (isNull) {
                    this.visit.set(from, to);
                } else {
                    Gap g = new Gap(from, to);
                    if (!gaps.contains(g)) {
                        this.debug("ohne match : ", this.job.ps * (this.pagenumber - 1) + from, " - ", this.job.ps * (this.pagenumber - 1) + to, " Bytes");
                    }
                    gaps.add(g);
                }
            }
            from = i;
        }
        return gaps;
    }

    public void carve(Carver crv) {
        List<Object> tab;
        AbstractDescriptor ad;
        Carver c = crv;
        if (null == c) {
            c = new Carver(this.job, this.buffer, this.visit, this.pagenumber);
        }
        TableDescriptor tdesc = null;
        if (this.job.pages.length > this.pagenumber && (ad = this.job.pages[this.pagenumber]) instanceof TableDescriptor) {
            tdesc = (TableDescriptor)ad;
        }
        this.debug(" tables :: ", this.tables.size());
        if (null != tdesc) {
            tab = new LinkedList<TableDescriptor>();
            tab.add(tdesc);
            this.debug(" added tdsec ");
        } else {
            this.warning(" No component description!");
            tab = this.tables;
        }
        LinkedList<Gap> gaps = this.findGaps();
        this.info("gaps.size()", gaps.size());
        if (gaps.size() == 0) {
            this.debug("no gaps anymore. Stopp search");
            return;
        }
        for (int n = 0; n < tab.size(); ++n) {
            Gap next;
            int a;
            tdesc = (TableDescriptor)tab.get(n);
            this.debug("pagenumber :: ", this.pagenumber, " component size :: ", tab.size());
            this.debug("n " + n);
            String tablename = ((TableDescriptor)tab.get((int)n)).tblname;
            if (tablename.startsWith("__UNASSIGNED")) continue;
            SerialTypeMatcher stm = new SerialTypeMatcher(this.buffer);
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = (Gap)gaps.get(a);
                if (next.to - next.from <= 5 || c.carve(next.from + 4, next.to, stm, 0, (TableDescriptor)tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP NORMAL finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = (Gap)gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 1, (TableDescriptor)tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP COLUMNSONLY finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = (Gap)gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 2, (TableDescriptor)tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP FIRSTCOLUMNMISSING finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = (Gap)gaps.get(a);
                c.carve(next.from + 4 + 1, next.to, stm, 2, (TableDescriptor)tab.get(n), this.firstcol);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.runSingleThread();
        }
        catch (Exception e) {
            this.err("Error in RecoveryTask: ", e);
        }
    }

    public void runSingleThread() throws IOException {
        try {
            this.recover();
        }
        finally {
            this.job.runningTasks.decrementAndGet();
        }
    }
}

