/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Carver;
import fqlite.base.Gap;
import fqlite.base.Job;
import fqlite.base.SqliteElementData;
import fqlite.base.SqliteInternalRow;
import fqlite.descriptor.AbstractDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.pattern.SerialTypeMatcher;
import fqlite.util.Auxiliary;
import fqlite.util.RandomAccessFileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class RollbackJournalReaderBase
extends Base {
    public static final String MAGIC_HEADER_STRING = "d9d505f920a163d7";
    public RandomAccessFileReader file;
    int ps;
    String path;
    BitSet visit = null;
    Job job;
    int pagenumber_rol;
    int pagenumber_maindb;
    long pagecount;
    long nounce;
    long pages;
    long sectorsize;
    long journalpagesize;
    boolean withoutROWID = false;
    private Auxiliary ct;
    private StringBuffer firstcol = new StringBuffer();
    protected ByteBuffer buffer;
    public List<TableDescriptor> tables = new LinkedList<TableDescriptor>();
    protected Queue<SqliteInternalRow> output = new ConcurrentLinkedQueue<SqliteInternalRow>();
    int journalpointer = 0;

    public RollbackJournalReaderBase(String path, Job job) {
        this.path = path;
        this.job = job;
        this.ct = new Auxiliary(job);
    }

    public void parse() throws IOException {
        Path p = Paths.get(this.path, new String[0]);
        try {
            this.file = new RandomAccessFileReader(p);
        }
        catch (Exception e) {
            this.err("Cannot open RollbackJournal-file", p.getFileName());
            return;
        }
        if (this.file.size() <= 512L) {
            this.info("RollbackJournal-File is empty. Skip analyzing.");
            return;
        }
        ByteBuffer header = this.file.allocateAndReadBuffer(0L, 28);
        byte[] head = new byte[8];
        header.get(head);
        if (Auxiliary.bytesToHex(head).equals(MAGIC_HEADER_STRING)) {
            this.info("header is okay. seems to be an rollback journal file.");
        } else {
            this.info("sorry. doesn't seem to be an rollback journal file. Wrong header.");
            this.err("Doesn't seem to be an valid rollback journal file. Wrong header.");
        }
        this.pagecount = Integer.toUnsignedLong(header.getInt());
        this.info(" pagecount ", this.pagecount);
        this.nounce = Integer.toUnsignedLong(header.getInt());
        this.info(" nounce ", this.nounce);
        this.pages = Integer.toUnsignedLong(header.getInt());
        this.info(" pages ", this.pages);
        this.sectorsize = Integer.toUnsignedLong(header.getInt());
        this.info(" sector size  ", this.sectorsize);
        this.journalpagesize = Integer.toUnsignedLong(header.getInt());
        this.info(" journal page size  ", this.journalpagesize);
        this.journalpointer = 512;
        this.visit = new BitSet(this.ps);
        boolean next = false;
        int numberofpages = 0;
        do {
            this.file.position(this.journalpointer);
            this.pagenumber_maindb = this.file.allocateAndReadBuffer(4).getInt();
            this.debug("pagenumber of journal-entry ", this.pagenumber_maindb);
            this.buffer = this.readPage();
            this.pagenumber_rol = ++numberofpages;
            this.analyzePage();
            this.journalpointer += 4 + this.ps + 4;
        } while (next = (long)(this.journalpointer + this.ps) <= this.file.size());
        this.info("Lines after RollbackJournal-file recovery: ", this.output.size());
        this.info("Number of pages in RollbackJournal-file", numberofpages);
    }

    public int analyzePage() {
        this.withoutROWID = false;
        byte pageType = this.buffer.get();
        this.buffer.get(pageType);
        this.buffer.position(0);
        int type = Auxiliary.getPageType(pageType);
        this.visit.set(0, 2);
        if (type == 0) {
            this.buffer.position(0);
            Integer checksum = this.buffer.getInt();
            if (checksum == 0) {
                this.info(" DROPPED PAGE !!!");
                this.carve(null);
            }
            return 0;
        }
        if (type < 0) {
            this.info("No Data page. ", this.pagenumber_rol);
            return -1;
        }
        if (type == 12) {
            this.info("Internal Table page ", this.pagenumber_rol);
            return -1;
        }
        if (type == 10) {
            this.info("Index leaf page ", this.pagenumber_rol);
            this.withoutROWID = true;
        } else {
            this.info("Data page ", this.pagenumber_rol, " Offset: ", this.file.position() - (long)this.ps);
        }
        if (type == 8) {
            byte[] fboffset = new byte[2];
            this.buffer.position(1);
            this.buffer.get(fboffset);
        }
        byte[] cpn = new byte[2];
        this.buffer.position(3);
        this.buffer.get(cpn);
        byte[] ccr = new byte[2];
        this.buffer.position(5);
        this.buffer.get(ccr);
        ByteBuffer contentregionstart = ByteBuffer.wrap(ccr);
        Auxiliary.TwoByteBuffertoInt(contentregionstart);
        this.visit.set(2, 8);
        ByteBuffer size = ByteBuffer.wrap(cpn);
        int cp = Auxiliary.TwoByteBuffertoInt(size);
        this.debug(" number of cells: ", cp, " type of page ", type);
        this.job.numberofcells.addAndGet(cp);
        if (0 == cp) {
            this.debug(" Page seems to be dropped. No cell entries.");
        }
        int headerend = 8 + cp * 2;
        this.visit.set(0, headerend);
        int last = 0;
        for (int i = 0; i < cp; ++i) {
            String tbln;
            byte[] pointer = new byte[2];
            if (type == 5) {
                this.buffer.position(12 + 2 * i);
            } else {
                this.buffer.position(8 + 2 * i);
            }
            this.buffer.get(pointer);
            ByteBuffer celladdr = ByteBuffer.wrap(pointer);
            int celloff = Auxiliary.TwoByteBuffertoInt(celladdr);
            if (last > 0 && celloff == last) continue;
            last = celloff;
            SqliteInternalRow row = null;
            try {
                row = this.ct.readRecord(celloff, this.buffer, this.pagenumber_maindb, this.visit, type, Integer.MAX_VALUE, this.firstcol, this.withoutROWID, this.journalpointer + 4);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null == row) continue;
            String tableName = row.getTableName();
            int p1 = tableName.indexOf("_node;");
            if (p1 > 0 && this.job.virtualTables.containsKey(tbln = tableName.substring(0, p1))) {
                TableDescriptor tds = this.job.virtualTables.get(tbln);
                String data = row.getRowData().get(1).toString();
                byte[] binary = Auxiliary.decode(data);
                ByteBuffer bf = ByteBuffer.wrap(binary);
                bf.getShort();
                for (int entries = bf.getShort(); entries > 0; --entries) {
                    SqliteInternalRow vrow = new SqliteInternalRow();
                    vrow.setTableName(tbln);
                    vrow.setRecordType("VT");
                    vrow.setOffset(0L);
                    long primarykey = bf.getLong();
                    vrow.append(new SqliteElementData(primarykey, this.job.db_encoding));
                    for (int number = tds.columnnames.size() - 1; number > 0; --number) {
                        float rv = bf.getFloat();
                        vrow.append(new SqliteElementData(rv, this.job.db_encoding));
                    }
                    this.output.add(vrow);
                    this.info(vrow.toString());
                }
            }
            this.output.add(row);
        }
        this.debug("finished STEP2 -> cellpoint array completed");
        return 0;
    }

    static boolean allCharactersZero(String s) {
        if (!s.startsWith("0000")) {
            return false;
        }
        int n = s.length();
        for (int i = 1; i < n; ++i) {
            if (s.charAt(i) == s.charAt(0)) continue;
            return false;
        }
        return true;
    }

    protected ByteBuffer readPage() throws IOException {
        return this.file.allocateAndReadBuffer(this.ps);
    }

    public void carve(ByteBuffer buffer, Carver crv) {
        AbstractDescriptor ad;
        Carver c = crv;
        if (null == c) {
            c = new Carver(this.job, buffer, this.visit, this.ps);
        }
        TableDescriptor tdesc = null;
        if (this.job.pages.length > this.ps && (ad = this.job.pages[this.ps]) instanceof TableDescriptor) {
            tdesc = (TableDescriptor)ad;
        }
        List<TableDescriptor> tab = this.tables;
        this.debug(" tables :: ", this.tables.size());
        if (null != tdesc) {
            tab = new LinkedList<TableDescriptor>();
            tab.add(tdesc);
            this.debug(" added tdsec ");
        } else {
            this.warning(" No component description!");
            tab = this.tables;
        }
        LinkedList<Gap> gaps = this.findGaps();
        if (gaps.size() == 0) {
            this.debug("no gaps anymore. Stopp search");
            return;
        }
        for (int n = 0; n < tab.size(); ++n) {
            Gap next;
            int a;
            tdesc = tab.get(n);
            this.debug("pagenumber :: ", this.pagenumber_maindb, " component size :: ", tab.size());
            this.debug("n ", n);
            String tablename = tab.get((int)n).tblname;
            if (tablename.startsWith("__UNASSIGNED")) continue;
            SerialTypeMatcher stm = new SerialTypeMatcher(buffer);
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (next.to - next.from <= 10 || c.carve(next.from + 4, next.to, stm, 0, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP NORMAL finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 1, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP COLUMNSONLY finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 2, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP FIRSTCOLUMNMISSING finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                c.carve(next.from + 4 + 1, next.to, stm, 2, tab.get(n), this.firstcol);
            }
        }
        this.debug("End of journal parse");
    }

    public abstract void output();

    public LinkedList<Gap> findGaps() {
        LinkedList<Gap> gaps = new LinkedList<Gap>();
        int from = 0;
        for (int i = 0; i < this.ps; ++i) {
            if (this.visit.get(i)) continue;
            from = i;
            int to = i;
            while (!this.visit.get(++i) && i < this.ps - 1) {
                ++to;
            }
            if (to - from > 10) {
                boolean isNull = false;
                if (this.buffer.get(from) == 0) {
                    isNull = true;
                    for (int index = from; index < to; ++index) {
                        if (0 == this.buffer.get(index)) continue;
                        isNull = false;
                    }
                }
                if (isNull) {
                    this.visit.set(from, to);
                } else {
                    gaps.add(new Gap(from, to));
                }
            }
            from = i;
        }
        return gaps;
    }

    public void carve(Carver crv) {
        AbstractDescriptor ad;
        Carver c = crv;
        if (null == c) {
            c = new Carver(this.job, this.buffer, this.visit, this.pagenumber_maindb);
        }
        TableDescriptor tdesc = null;
        if (this.job.pages.length > this.pagenumber_maindb && (ad = this.job.pages[this.pagenumber_maindb]) instanceof TableDescriptor) {
            tdesc = (TableDescriptor)ad;
        }
        List<TableDescriptor> tab = this.tables;
        this.debug(" tables :: ", this.tables.size());
        if (null != tdesc) {
            tab = new LinkedList<TableDescriptor>();
            tab.add(tdesc);
            this.debug(" added tdsec ");
        } else {
            this.warning(" No component description!");
            tab = this.tables;
        }
        LinkedList<Gap> gaps = this.findGaps();
        if (gaps.size() == 0) {
            this.debug("no gaps anymore. Stopp search");
            return;
        }
        for (int n = 0; n < tab.size(); ++n) {
            Gap next;
            int a;
            tdesc = tab.get(n);
            this.debug("pagenumber :: ", this.pagenumber_maindb, " component size :: ", tab.size());
            this.debug("n ", n);
            String tablename = tab.get((int)n).tblname;
            this.debug("Check component : ", tablename);
            if (tablename.startsWith("__UNASSIGNED")) continue;
            SerialTypeMatcher stm = new SerialTypeMatcher(this.buffer);
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (next.to - next.from <= 10 || c.carve(next.from + 4, next.to, stm, 0, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP NORMAL finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 1, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP COLUMNSONLY finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 2, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP FIRSTCOLUMNMISSING finished with matches");
            }
        }
    }
}

