/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Global;
import fqlite.types.SerialTypes;
import fqlite.types.StorageClasses;
import fqlite.util.Auxiliary;
import fqlite.util.DatetimeConverter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class SqliteElement {
    public SerialTypes type;
    public StorageClasses serial;
    public int length;
    public Charset charset;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public SqliteElement(SerialTypes type, StorageClasses serial, int length, Charset charset) {
        this.length = length;
        this.type = type;
        this.serial = serial;
        this.charset = charset;
    }

    public final String toString(byte[] value) {
        if (value.length == 0 && this.type != SerialTypes.INT0 && this.type != SerialTypes.INT1) {
            return "";
        }
        switch (this.type) {
            case INT0: {
                return "0";
            }
            case INT1: {
                return "1";
            }
            case STRING: {
                return SqliteElement.decodeString(value, this.charset).toString();
            }
            case INT8: {
                return String.valueOf(SqliteElement.decodeInt8(value[0]));
            }
            case INT16: {
                return String.valueOf(SqliteElement.decodeInt16(value));
            }
            case INT24: {
                return String.valueOf(SqliteElement.decodeInt24(value));
            }
            case INT32: {
                return String.valueOf(SqliteElement.decodeInt32(value));
            }
            case INT48: 
            case INT64: {
                String strDateTime;
                long lValue = this.type == SerialTypes.INT48 ? SqliteElement.decodeInt48(value) : SqliteElement.decodeInt64(value);
                if (Global.CONVERT_DATETIME && null != (strDateTime = DatetimeConverter.isUnixEpoch(lValue))) {
                    return strDateTime;
                }
                return String.valueOf(lValue);
            }
            case FLOAT64: {
                String strDateTime;
                double dValue = SqliteElement.decodeFloat64(value);
                if (Global.CONVERT_DATETIME && null != (strDateTime = DatetimeConverter.isMacAbsoluteTime(dValue))) {
                    return strDateTime;
                }
                return String.format("%.8f", dValue);
            }
            case BLOB: {
                return String.valueOf(Auxiliary.bytesToHex(value));
            }
            case PRIMARY_KEY: {
                return String.valueOf(SqliteElement.decodeInt64(value));
            }
        }
        return null;
    }

    public static final int decodeInt8(byte v) {
        return v;
    }

    static final int decodeInt16(byte[] v) {
        if (v.length < 2) {
            return 0;
        }
        ByteBuffer bf = ByteBuffer.wrap(v);
        return bf.getShort();
    }

    static final int decodeInt24(byte[] v) {
        int result = SqliteElement.int24bytesToUInt(v);
        return result;
    }

    private static int int24bytesToUInt(byte[] input) {
        if (input.length == 0) {
            return 0;
        }
        if (input.length == 1) {
            return 0 | (input[0] & 0xFF) << 0;
        }
        if (input.length == 2) {
            return 0 | (input[0] & 0xFF) << 8 | (input[1] & 0xFF) << 0;
        }
        return 0 | (input[0] & 0xFF) << 16 | (input[1] & 0xFF) << 8 | (input[2] & 0xFF) << 0;
    }

    static final int decodeInt32(byte[] v) {
        if (v.length < 4) {
            return 0;
        }
        ByteBuffer bf = ByteBuffer.wrap(v);
        return bf.getInt();
    }

    static final long decodeInt48(byte[] v) {
        if (v.length < 6) {
            return 0L;
        }
        ByteBuffer bf = ByteBuffer.wrap(v);
        byte[] value = bf.array();
        byte[] converted = new byte[8];
        for (int i = 0; i < 6; ++i) {
            converted[i + 2] = value[i];
        }
        ByteBuffer result = ByteBuffer.wrap(converted);
        return result.getLong();
    }

    static final long decodeInt64(byte[] v) {
        if (v.length < 8) {
            return 0L;
        }
        ByteBuffer bf = ByteBuffer.wrap(v);
        return bf.getLong();
    }

    static final String convertToDate(long value) {
        Date d = new Date(value / 1000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        return dateFormat.format(d);
    }

    static final double decodeFloat64(byte[] v) {
        if (v.length < 8) {
            return Double.NaN;
        }
        ByteBuffer bf = ByteBuffer.wrap(v);
        return bf.getDouble();
    }

    static final CharBuffer decodeString(byte[] v, Charset charset) {
        return charset.decode(ByteBuffer.wrap(v));
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isStringContent(byte[] value) {
        float threshold = 0.8f;
        int printable = 0;
        for (byte b : value) {
            if (b < 32 || b >= 127) continue;
            ++printable;
        }
        return (float)(printable / value.length) > threshold;
    }
}

