/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Global;
import fqlite.base.SqliteElement;
import fqlite.types.SerialTypes;
import fqlite.types.StorageClasses;
import fqlite.util.DatetimeConverter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class SqliteElementData {
    private SqliteElement column;
    private byte[] data;
    private Charset charset = StandardCharsets.UTF_8;

    public SqliteElementData(SqliteElement column, byte[] data) {
        this.column = column;
        this.data = data;
        this.charset = column.charset;
    }

    public SqliteElementData(String data, Charset charset) {
        this.column = null;
        this.data = (byte[])(null == data ? null : data.getBytes());
        this.charset = charset;
    }

    public SqliteElementData(long data, Charset charset) {
        this(new SqliteElement(SerialTypes.INT64, StorageClasses.INT, 8, charset), data);
    }

    public SqliteElementData(SqliteElement column, long data) {
        this.column = column;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(data);
        this.data = buffer.array();
        this.charset = column.charset;
    }

    public SqliteElementData(double data, Charset charset) {
        this.column = new SqliteElement(SerialTypes.FLOAT64, StorageClasses.FLOAT, 8, charset);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(data);
        this.data = buffer.array();
        this.charset = charset;
    }

    public String toString() {
        if (null == this.column) {
            if (null == this.data) {
                return "NULL";
            }
            return SqliteElement.decodeString(this.data, this.charset).toString();
        }
        return this.column.toString(this.data);
    }

    public long getIntValue() {
        switch (this.column.type) {
            case INT0: {
                return 0L;
            }
            case INT1: {
                return 1L;
            }
            case INT8: {
                return SqliteElement.decodeInt8(this.data[0]);
            }
            case INT16: {
                return SqliteElement.decodeInt16(this.data);
            }
            case INT24: {
                return SqliteElement.decodeInt24(this.data);
            }
            case INT32: {
                return SqliteElement.decodeInt32(this.data);
            }
            case INT48: {
                return SqliteElement.decodeInt48(this.data);
            }
            case INT64: 
            case PRIMARY_KEY: {
                return SqliteElement.decodeInt64(this.data);
            }
        }
        return 0L;
    }

    public String getTextValue() {
        if (this.column == null) {
            if (this.data != null) {
                return SqliteElement.decodeString(this.data, this.charset).toString();
            }
            return "";
        }
        switch (this.column.type) {
            case STRING: {
                return SqliteElement.decodeString(this.data, this.charset).toString();
            }
        }
        return null;
    }

    public byte[] getBlobValue() {
        return this.data;
    }

    public double getFloatValue() {
        switch (this.column.type) {
            case FLOAT64: {
                return SqliteElement.decodeFloat64(this.data);
            }
        }
        return 0.0;
    }

    public Object getObject() {
        if (this.data == null) {
            return null;
        }
        if (this.data.length == 0 && this.column.type != SerialTypes.INT0 && this.column.type != SerialTypes.INT1) {
            return null;
        }
        switch (this.column.type) {
            case INT0: {
                return 0;
            }
            case INT1: {
                return 1;
            }
            case STRING: {
                return SqliteElement.decodeString(this.data, this.charset).toString();
            }
            case INT8: {
                return SqliteElement.decodeInt8(this.data[0]);
            }
            case INT16: {
                return SqliteElement.decodeInt16(this.data);
            }
            case INT24: {
                return SqliteElement.decodeInt24(this.data);
            }
            case INT32: {
                return SqliteElement.decodeInt32(this.data);
            }
            case INT48: 
            case INT64: {
                String strDateTime;
                long lValue = this.column.type == SerialTypes.INT48 ? SqliteElement.decodeInt48(this.data) : SqliteElement.decodeInt64(this.data);
                if (Global.CONVERT_DATETIME && null != (strDateTime = DatetimeConverter.isUnixEpoch(lValue))) {
                    return strDateTime;
                }
                return lValue;
            }
            case FLOAT64: {
                String strDateTime;
                double dValue = SqliteElement.decodeFloat64(this.data);
                if (Global.CONVERT_DATETIME && null != (strDateTime = DatetimeConverter.isMacAbsoluteTime(dValue))) {
                    return strDateTime;
                }
                return dValue;
            }
            case BLOB: {
                return this.data;
            }
            case PRIMARY_KEY: {
                return SqliteElement.decodeInt64(this.data);
            }
        }
        return null;
    }
}

