/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.SqliteElementData;
import fqlite.base.SqliteRow;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqliteInternalRow {
    private List<SqliteElementData> rowData = new ArrayList<SqliteElementData>();
    private long offset = 0L;
    private String tableName = "";
    private String recordType = "";
    private String lineSuffix = "";
    private Map<String, Integer> colIdx = null;

    void setColumnNamesMap(Map<String, Integer> colIdx) {
        this.colIdx = colIdx;
    }

    public Set<String> getColumnNames() {
        if (this.colIdx != null) {
            return this.colIdx.keySet();
        }
        return null;
    }

    public int getColumnIndex(String colName) {
        if (this.colIdx != null && this.colIdx.containsKey(colName)) {
            return this.colIdx.get(colName);
        }
        return -1;
    }

    public void append(SqliteElementData elementData) {
        this.rowData.add(elementData);
    }

    public List<SqliteElementData> getRowData() {
        return this.rowData;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getLineSuffix() {
        return this.lineSuffix;
    }

    public void setLineSuffix(String lineSuffix) {
        this.lineSuffix = lineSuffix;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tableName).append(";");
        builder.append(this.recordType).append(";");
        builder.append(this.offset);
        for (SqliteElementData elementData : this.rowData) {
            builder.append(";").append(elementData.toString());
        }
        builder.append(this.lineSuffix);
        builder.append("\n");
        return builder.toString();
    }

    public long getIntValue(String col) {
        if (this.colIdx == null || !this.colIdx.containsKey(col)) {
            return Long.MIN_VALUE;
        }
        int idx = this.colIdx.get(col);
        if (idx >= this.rowData.size()) {
            return Long.MIN_VALUE;
        }
        try {
            return this.rowData.get(idx).getIntValue();
        }
        catch (ArrayIndexOutOfBoundsException | BufferUnderflowException runtimeException) {
            return Long.MIN_VALUE;
        }
    }

    public String getTextValue(String col) {
        if (this.colIdx == null || !this.colIdx.containsKey(col)) {
            return null;
        }
        int idx = this.colIdx.get(col);
        if (idx >= this.rowData.size()) {
            return null;
        }
        return this.rowData.get(idx).getTextValue();
    }

    public double getFloatValue(String col) {
        if (this.colIdx == null || !this.colIdx.containsKey(col)) {
            return Double.NaN;
        }
        int idx = this.colIdx.get(col);
        if (idx >= this.rowData.size()) {
            return Double.NaN;
        }
        return this.rowData.get(idx).getFloatValue();
    }

    public byte[] getBlobValue(String col) {
        if (this.colIdx == null || !this.colIdx.containsKey(col)) {
            return null;
        }
        int idx = this.colIdx.get(col);
        if (idx >= this.rowData.size()) {
            return null;
        }
        return this.rowData.get(idx).getBlobValue();
    }

    public boolean isDeletedRow() {
        return this.recordType != null && (this.recordType.contains("D") || this.recordType.contains("F") || this.recordType.contains("U"));
    }

    public SqliteRow decodeRow() {
        SqliteRow result = new SqliteRow();
        result.setTableName(this.tableName);
        result.setDeletedRow(this.isDeletedRow());
        result.setColumnNamesMap(this.colIdx);
        Object[] data = new Object[this.rowData.size()];
        for (int i = 0; i < data.length; ++i) {
            SqliteElementData d = this.rowData.get(i);
            if (d == null) continue;
            data[i] = d.getObject();
        }
        result.setRowData(data);
        return result;
    }
}

