/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;

public class SqliteRow {
    private Object[] rowData;
    private String tableName;
    private boolean deleted;
    private Map<String, Integer> colIdx = null;
    private Charset charset = StandardCharsets.UTF_8;

    void setColumnNamesMap(Map<String, Integer> colIdx) {
        this.colIdx = colIdx;
    }

    public Set<String> getColumnNames() {
        if (this.colIdx != null) {
            return this.colIdx.keySet();
        }
        return null;
    }

    public int getColumnIndex(String colName) {
        if (this.colIdx != null && this.colIdx.containsKey(colName)) {
            return this.colIdx.get(colName);
        }
        return -1;
    }

    public void setRowData(Object[] rowData) {
        this.rowData = rowData;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean semicolon = false;
        for (Object elementData : this.rowData) {
            if (semicolon) {
                builder.append(";");
            }
            if (elementData == null) {
                builder.append("NULL");
                continue;
            }
            builder.append(elementData.toString());
        }
        return builder.toString();
    }

    public long getIntValue(int colIdx) {
        Object val;
        long result = Long.MIN_VALUE;
        if (colIdx >= 0 && colIdx < this.rowData.length && (val = this.rowData[colIdx]) != null) {
            if (val instanceof Long) {
                result = (Long)val;
            } else if (val instanceof Integer) {
                result = ((Integer)val).intValue();
            }
        }
        return result;
    }

    public long getIntValue(String col) {
        long result = Long.MIN_VALUE;
        if (this.colIdx != null && this.colIdx.containsKey(col)) {
            result = this.getIntValue(this.colIdx.get(col));
        }
        return result;
    }

    public String getTextValue(int colIdx) {
        Object val;
        String result = null;
        if (colIdx >= 0 && colIdx < this.rowData.length && (val = this.rowData[colIdx]) != null) {
            if (val instanceof byte[]) {
                try {
                    result = new String((byte[])val, this.charset);
                }
                catch (Exception exception) {}
            } else {
                result = val.toString();
            }
        }
        return result;
    }

    public String getTextValue(String col) {
        String result = null;
        if (this.colIdx != null && this.colIdx.containsKey(col)) {
            result = this.getTextValue(this.colIdx.get(col));
        }
        return result;
    }

    public double getFloatValue(int colIdx) {
        Object val;
        double result = Double.NaN;
        if (colIdx >= 0 && colIdx < this.rowData.length && (val = this.rowData[colIdx]) != null) {
            if (val instanceof Double) {
                result = (Double)val;
            } else if (val instanceof Float) {
                result = ((Float)val).floatValue();
            }
        }
        return result;
    }

    public double getFloatValue(String col) {
        double result = Double.NaN;
        if (this.colIdx != null && this.colIdx.containsKey(col)) {
            result = this.getFloatValue(this.colIdx.get(col));
        }
        return result;
    }

    public byte[] getBlobValue(int colIdx) {
        Object val;
        byte[] result = null;
        if (colIdx >= 0 && colIdx < this.rowData.length && (val = this.rowData[colIdx]) != null) {
            if (val instanceof byte[]) {
                result = (byte[])val;
            } else if (val instanceof String) {
                result = ((String)val).getBytes(this.charset);
            }
        }
        return result;
    }

    public byte[] getBlobValue(String col) {
        byte[] result = null;
        if (this.colIdx != null && this.colIdx.containsKey(col)) {
            result = this.getBlobValue(this.colIdx.get(col));
        }
        return result;
    }

    public boolean isDeletedRow() {
        return this.deleted;
    }

    public void setDeletedRow(boolean deleted) {
        this.deleted = deleted;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

