/*
 * Decompiled with CFR 0.152.
 */
package fqlite.base;

import fqlite.base.Base;
import fqlite.base.Carver;
import fqlite.base.Gap;
import fqlite.base.Job;
import fqlite.base.SqliteElementData;
import fqlite.base.SqliteInternalRow;
import fqlite.descriptor.AbstractDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.pattern.SerialTypeMatcher;
import fqlite.util.Auxiliary;
import fqlite.util.RandomAccessFileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class WALReaderBase
extends Base {
    TreeMap<Long, LinkedList<WALFrame>> checkpoints = new TreeMap();
    public RandomAccessFileReader file;
    long size;
    int ffversion;
    int ps;
    int csn;
    long hsalt1;
    long hsalt2;
    long hchecksum1;
    long hchecksum2;
    String path;
    BitSet visit = null;
    boolean withoutROWID = false;
    Job job;
    int pagenumber_maindb;
    int pagenumber_wal;
    int framestart = 0;
    public String headerstring = "";
    private Auxiliary ct;
    private StringBuffer firstcol = new StringBuffer();
    private static final String MAGIC_HEADER_STRING1 = "377f0682";
    private static final String MAGIC_HEADER_STRING2 = "377f0683";
    ByteBuffer buffer;
    public List<TableDescriptor> tables = new LinkedList<TableDescriptor>();
    Queue<SqliteInternalRow> output = new ConcurrentLinkedQueue<SqliteInternalRow>();

    public WALReaderBase(String path, Job job) {
        this.path = path;
        this.job = job;
        this.ct = new Auxiliary(job);
    }

    public void parse() throws IOException {
        int framenumber = 0;
        Path p = Paths.get(this.path, new String[0]);
        this.info("parse WAL-File");
        try {
            this.file = new RandomAccessFileReader(p);
        }
        catch (Exception e) {
            this.err("Cannot open WAL-file", p.getFileName());
            return;
        }
        if (this.file.size() <= 32L) {
            this.info("WAL-File is empty. Skip analyzing.");
            return;
        }
        this.buffer = this.file.allocateAndReadBuffer(0L, 32);
        byte[] header = new byte[4];
        this.buffer.get(header);
        if (Auxiliary.bytesToHex(header).equals(MAGIC_HEADER_STRING1)) {
            this.headerstring = MAGIC_HEADER_STRING1;
            this.info("header is okay. seems to be an write ahead log file.");
        } else if (Auxiliary.bytesToHex(header).equals(MAGIC_HEADER_STRING2)) {
            this.headerstring = MAGIC_HEADER_STRING2;
            this.info("header is okay. seems to be an write ahead log file.");
        } else {
            this.info("sorry. doesn't seem to be an WAL file. Wrong header.");
            this.err("Doesn't seem to be an valid WAL file. Wrong header");
        }
        this.buffer.position(4);
        this.ffversion = this.buffer.getInt();
        this.info(" file format version ", this.ffversion);
        this.ps = this.buffer.getInt();
        if (this.ps == 0 || this.ps == 1) {
            this.ps = 65536;
        }
        this.info("page size ", this.ps, " Bytes ");
        this.csn = this.buffer.getInt();
        this.info(" checkpoint sequence number ", this.csn);
        this.hsalt1 = Integer.toUnsignedLong(this.buffer.getInt());
        this.info(" salt1 ", this.hsalt1);
        this.hsalt2 = Integer.toUnsignedLong(this.buffer.getInt());
        this.info(" salt2 ", this.hsalt2);
        this.hchecksum1 = Integer.toUnsignedLong(this.buffer.getInt());
        this.info(" checksum-1 of first frame header ", this.hchecksum1);
        this.hchecksum2 = Integer.toUnsignedLong(this.buffer.getInt());
        this.info(" checksum-2 second part ot the checksum on the first frame header ", this.hchecksum2);
        this.visit = new BitSet(this.ps);
        this.framestart = 32;
        boolean next = false;
        int numberofpages = 0;
        do {
            ByteBuffer fheader = this.file.allocateAndReadBuffer(this.framestart, 24);
            this.pagenumber_maindb = fheader.getInt();
            int commit = fheader.getInt();
            if (commit > 0) {
                this.info(" Information of the WAL-archive has been commited successful. ");
            } else {
                this.info(" No commit so far. this frame holds the latest! version of the page ");
            }
            long fsalt1 = Integer.toUnsignedLong(fheader.getInt());
            this.info("fsalt1 ", fsalt1);
            long fsalt2 = Integer.toUnsignedLong(fheader.getInt());
            this.info("fsalt2", fsalt2);
            if (this.hsalt1 == fsalt1 && this.hsalt2 == fsalt2) {
                this.info("seems to be an valid frame. Condition 1 is true at least. ");
            }
            this.debug("pagenumber of frame in main db ", this.pagenumber_maindb);
            this.buffer = this.readPage();
            if (this.buffer == null) break;
            this.pagenumber_wal = ++numberofpages;
            WALFrame frame = this.updateCheckpoint(this.pagenumber_maindb, framenumber, fsalt1, fsalt2, commit != 0);
            this.analyzePage(frame);
            this.framestart += this.ps + 24;
            next = (long)(this.framestart + 24 + this.ps) < this.size;
            ++framenumber;
        } while (next);
        this.info("Lines after WAL-file recovery: ", this.output.size());
        this.info("Number of pages in WAL-file", numberofpages);
        this.info("Checkpoints ", this.checkpoints);
    }

    private WALFrame updateCheckpoint(int pagenumber, int framenumber, long salt1, long salt2, boolean committed) {
        WALFrame f = new WALFrame(pagenumber, framenumber, salt1, salt2, committed);
        if (!this.checkpoints.containsKey(salt1)) {
            LinkedList<WALFrame> trx = new LinkedList<WALFrame>();
            trx.add(f);
            this.checkpoints.put(salt1, trx);
        } else {
            LinkedList<WALFrame> trx = this.checkpoints.get(salt1);
            trx.add(f);
        }
        return f;
    }

    public int analyzePage(WALFrame frame) {
        this.withoutROWID = false;
        this.buffer.position(0);
        byte pageType = this.buffer.get();
        this.buffer.get(pageType);
        this.buffer.position(0);
        int type = Auxiliary.getPageType(pageType);
        this.visit.set(0, 2);
        if (type == 0) {
            this.buffer.position(0);
            Integer checksum = this.buffer.getInt();
            if (checksum == 0) {
                this.info(" DROPPED PAGE !!!");
                this.carve(null);
            }
            return 0;
        }
        if (type < 0) {
            this.info("No Data page. ", this.pagenumber_wal);
            return -1;
        }
        if (type == 12) {
            this.info("Internal Table page ", this.pagenumber_wal);
            return -1;
        }
        if (type == 10) {
            this.info("Index leaf page ", this.pagenumber_wal);
            this.withoutROWID = true;
        } else {
            this.info("Data page ", this.pagenumber_wal, " Offset: ", this.file.position());
        }
        if (type == 8) {
            byte[] fboffset = new byte[2];
            this.buffer.position(1);
            this.buffer.get(fboffset);
        }
        int ccrstart = this.job.ps;
        byte[] cpn = new byte[2];
        this.buffer.position(3);
        this.buffer.get(cpn);
        byte[] ccr = new byte[2];
        this.buffer.position(5);
        ByteBuffer contentregionstart = ByteBuffer.wrap(ccr);
        ccrstart = Auxiliary.TwoByteBuffertoInt(contentregionstart);
        this.visit.set(2, 8);
        ByteBuffer size = ByteBuffer.wrap(cpn);
        int cp = Auxiliary.TwoByteBuffertoInt(size);
        this.debug(" number of cells: ", cp, " type of page ", type);
        this.job.numberofcells.addAndGet(cp);
        if (0 == cp) {
            this.debug(" Page seems to be dropped. No cell entries.");
        }
        int headerend = 8 + cp * 2;
        this.visit.set(0, headerend);
        this.info("headerend:", headerend);
        int last = 0;
        for (int i = 0; i < cp; ++i) {
            String tbln;
            byte[] pointer = new byte[2];
            if (type == 5) {
                this.buffer.position(12 + 2 * i);
            } else {
                this.buffer.position(8 + 2 * i);
            }
            this.buffer.get(pointer);
            ByteBuffer celladdr = ByteBuffer.wrap(pointer);
            int celloff = Auxiliary.TwoByteBuffertoInt(celladdr);
            if (last > 0 && celloff == last) continue;
            last = celloff;
            SqliteInternalRow row = null;
            try {
                row = this.ct.readRecord(celloff, this.buffer, this.pagenumber_maindb, this.visit, type, Integer.MAX_VALUE, this.firstcol, this.withoutROWID, this.framestart + 24);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String info = frame.committed + "," + frame.pagenumber + "," + frame.framenumber + "," + frame.salt1 + "," + frame.salt2;
            row.setLineSuffix("#walframe#" + info);
            if (null == row) continue;
            String tableName = row.getTableName();
            int p1 = tableName.indexOf("_node;");
            if (p1 > 0 && this.job.virtualTables.containsKey(tbln = tableName.substring(0, p1))) {
                TableDescriptor tds = this.job.virtualTables.get(tbln);
                String data = row.getRowData().get(1).toString();
                byte[] binary = Auxiliary.decode(data);
                ByteBuffer bf = ByteBuffer.wrap(binary);
                bf.getShort();
                for (int entries = bf.getShort(); entries > 0; --entries) {
                    SqliteInternalRow vrow = new SqliteInternalRow();
                    vrow.setTableName(tbln);
                    vrow.setRecordType("VT");
                    vrow.setOffset(0L);
                    long primarykey = bf.getLong();
                    vrow.append(new SqliteElementData(primarykey, this.job.db_encoding));
                    for (int number = tds.columnnames.size() - 1; number > 0; --number) {
                        float rv = bf.getFloat();
                        vrow.append(new SqliteElementData(rv, this.job.db_encoding));
                    }
                    this.output.add(vrow);
                }
            }
            this.output.add(row);
        }
        this.debug("finished STEP2 -> cellpoint array completed");
        try {
            SqliteInternalRow row;
            this.buffer.position(headerend);
            byte[] garbage = new byte[2];
            int garbageoffset = -1;
            do {
                this.buffer.get(garbage);
                ByteBuffer ignore = ByteBuffer.wrap(garbage);
                garbageoffset = Auxiliary.TwoByteBuffertoInt(ignore);
            } while (this.buffer.position() < this.ps && garbageoffset > 0);
            byte zerob = 0;
            while (this.buffer.position() < this.ps && zerob == 0) {
                zerob = this.buffer.get();
            }
            this.visit.set(headerend, this.buffer.position());
            this.buffer.position(this.buffer.position() - 1);
            if (ccrstart - this.buffer.position() > 3 && null != (row = this.ct.readRecord(this.buffer.position(), this.buffer, this.ps, this.visit, type, ccrstart - this.buffer.position(), this.firstcol, this.withoutROWID, -1))) {
                row.setRecordType("D" + row.getRecordType());
                this.job.addRow(row);
            }
            this.carve(null);
        }
        catch (Exception err) {
            err.printStackTrace();
            return -1;
        }
        return 0;
    }

    static boolean allCharactersZero(String s) {
        if (!s.startsWith("0000")) {
            return false;
        }
        int n = s.length();
        for (int i = 1; i < n; ++i) {
            if (s.charAt(i) == s.charAt(0)) continue;
            return false;
        }
        return true;
    }

    protected ByteBuffer readPage() throws IOException {
        return this.file.allocateAndReadBuffer(this.ps);
    }

    public void carve(ByteBuffer buffer, Carver crv) {
        AbstractDescriptor ad;
        Carver c = crv;
        if (null == c) {
            c = new Carver(this.job, buffer, this.visit, this.ps);
        }
        TableDescriptor tdesc = null;
        if (this.job.pages.length > this.ps && (ad = this.job.pages[this.ps]) instanceof TableDescriptor) {
            tdesc = (TableDescriptor)ad;
        }
        List<TableDescriptor> tab = this.tables;
        this.debug(" tables :: ", this.tables.size());
        if (null != tdesc) {
            tab = new LinkedList<TableDescriptor>();
            tab.add(tdesc);
            this.debug(" added tdsec ");
        } else {
            this.warning(" No component description!");
            tab = this.tables;
        }
        LinkedList<Gap> gaps = this.findGaps();
        if (gaps.size() == 0) {
            this.debug("no gaps anymore. Stopp search");
            return;
        }
        for (int n = 0; n < tab.size(); ++n) {
            Gap next;
            int a;
            tdesc = tab.get(n);
            this.debug("pagenumber :: ", this.pagenumber_maindb, " component size :: ", tab.size());
            this.debug("n ", n);
            String tablename = tab.get((int)n).tblname;
            this.debug("WALReader 713 Check component : ", tablename);
            if (tablename.startsWith("__UNASSIGNED")) continue;
            SerialTypeMatcher stm = new SerialTypeMatcher(buffer);
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (next.to - next.from <= 10 || c.carve(next.from + 4, next.to, stm, 0, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP NORMAL finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 1, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP COLUMNSONLY finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 2, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP FIRSTCOLUMNMISSING finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                c.carve(next.from + 4 + 1, next.to, stm, 2, tab.get(n), this.firstcol);
            }
        }
        this.debug("End of WALReader:parse()");
    }

    public abstract void output();

    public LinkedList<Gap> findGaps() {
        LinkedList<Gap> gaps = new LinkedList<Gap>();
        int from = 0;
        for (int i = 0; i < this.ps; ++i) {
            if (this.visit.get(i)) continue;
            from = i;
            int to = i;
            while (!this.visit.get(++i) && i < this.ps - 1) {
                ++to;
            }
            if (to - from > 10) {
                boolean isNull = false;
                if (this.buffer.get(from) == 0) {
                    isNull = true;
                    for (int index = from; index < to; ++index) {
                        if (0 == this.buffer.get(index)) continue;
                        isNull = false;
                    }
                }
                if (isNull) {
                    this.visit.set(from, to);
                } else {
                    gaps.add(new Gap(from, to));
                }
            }
            from = i;
        }
        return gaps;
    }

    public void carve(Carver crv) {
        AbstractDescriptor ad;
        Carver c = crv;
        if (null == c) {
            c = new Carver(this.job, this.buffer, this.visit, this.pagenumber_maindb);
        }
        TableDescriptor tdesc = null;
        if (this.job.pages.length > this.pagenumber_maindb && (ad = this.job.pages[this.pagenumber_maindb]) instanceof TableDescriptor) {
            tdesc = (TableDescriptor)ad;
        }
        List<TableDescriptor> tab = this.tables;
        this.debug(" tables :: ", this.tables.size());
        if (null != tdesc) {
            tab = new LinkedList<TableDescriptor>();
            tab.add(tdesc);
            this.debug(" added tdsec ");
        } else {
            this.warning(" No component description!");
            tab = this.tables;
        }
        LinkedList<Gap> gaps = this.findGaps();
        if (gaps.size() == 0) {
            this.debug("no gaps anymore. Stopp search");
            return;
        }
        for (int n = 0; n < tab.size(); ++n) {
            Gap next;
            int a;
            tdesc = tab.get(n);
            this.debug("pagenumber :: ", this.pagenumber_maindb, " component size :: ", tab.size());
            this.debug("n ", n);
            String tablename = tab.get((int)n).tblname;
            this.debug("Check component : ", tablename);
            if (tablename.startsWith("__UNASSIGNED")) continue;
            SerialTypeMatcher stm = new SerialTypeMatcher(this.buffer);
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (next.to - next.from <= 10 || c.carve(next.from + 4, next.to, stm, 0, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP NORMAL finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 1, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP COLUMNSONLY finished with matches");
            }
            gaps = this.findGaps();
            for (a = 0; a < gaps.size(); ++a) {
                next = gaps.get(a);
                if (c.carve(next.from + 4, next.to, stm, 2, tab.get(n), this.firstcol) == -1) continue;
                this.debug("*****************************  STEP FIRSTCOLUMNMISSING finished with matches");
            }
        }
    }

    class WALFrame {
        int pagenumber;
        int framenumber;
        long salt1;
        long salt2;
        boolean committed = false;

        public String toString() {
            return "{pagenumber=" + this.pagenumber + " framenumber=" + this.framenumber + " committed=" + this.committed + "}";
        }

        public WALFrame(int pagenumber, int framenumber, long salt1, long salt2, boolean committed) {
            this.salt1 = salt1;
            this.salt2 = salt2;
            this.pagenumber = pagenumber;
            this.framenumber = framenumber;
            this.committed = committed;
        }
    }
}

