/*
 * Decompiled with CFR 0.152.
 */
package fqlite.descriptor;

import fqlite.descriptor.AbstractDescriptor;
import fqlite.pattern.HeaderPattern;
import fqlite.util.Auxiliary;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class IndexDescriptor
extends AbstractDescriptor {
    public List<String> columntypes;
    public List<String> columnnames;
    int size = 0;
    public String idxname = "";
    public String tablename = "";
    public int root = -1;
    public HeaderPattern hpattern = null;
    private String sql = "";

    public boolean checkMatch(String match) {
        try {
            byte[] bcol = Auxiliary.decode(match);
            long[] values = Auxiliary.readVarInt(bcol);
            int headerlength = (int)values[0];
            this.info(Integer.toString(headerlength));
            boolean valid = true;
            for (int i = 1; i < values.length; ++i) {
                String type;
                switch (type = this.columntypes.get(i - 1)) {
                    case "INT": {
                        valid = values[i] >= 0L && values[i] <= 6L;
                        break;
                    }
                    case "REAL": {
                        valid = values[i] == 7L;
                        break;
                    }
                    case "TEXT": {
                        if (values[i] == 0L) {
                            valid = true;
                            break;
                        }
                        if (values[i] % 2L != 0L) {
                            valid = values[i] > 13L;
                            break;
                        }
                        valid = false;
                        break;
                    }
                    case "BLOB": {
                        if (values[i] == 0L) {
                            valid = true;
                            break;
                        }
                        if (values[i] % 2L == 0L) {
                            valid = values[i] > 12L;
                            break;
                        }
                        valid = false;
                        break;
                    }
                    case "NUMERIC": {
                        boolean bl = valid = values[i] >= 0L && values[i] <= 9L;
                    }
                }
                if (valid) continue;
                return false;
            }
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    public IndexDescriptor(String idxname, String tablename, String stmt, List<String> names) {
        this.ROWID = false;
        this.columnnames = names;
        this.idxname = idxname;
        this.tablename = tablename;
        this.columntypes = new LinkedList<String>();
        this.setSql(stmt);
    }

    public String getPattern(int startcolumn, int endcolumn, boolean multicol) {
        String pat = "";
        for (int i = startcolumn; i < endcolumn; ++i) {
            pat = pat + this.getColumn(this.columntypes.get(i), multicol);
        }
        return pat;
    }

    @Override
    public String getName() {
        return this.idxname;
    }

    public int getRootOffset() {
        return this.root;
    }

    public int getLength() {
        return 1 + this.size;
    }

    public int numberofColumns() {
        return this.columntypes.size();
    }

    public Pattern getPatternMultiCol() {
        return Pattern.compile(this.getPattern(0, this.size, true));
    }

    private String getColumn(String serialtype, boolean multicol) {
        switch (serialtype) {
            case "INT": {
                return "0[0-6]";
            }
            case "REAL": {
                return "07";
            }
            case "TEXT": {
                if (multicol) {
                    return "[0-9a-f][0-9a-f]{0,4}";
                }
                return "[0-9a-f][0-9a-f]";
            }
            case "BLOB": {
                if (multicol) {
                    return "[0-9a-f][0-9a-f]{0,4}";
                }
                return "[0-9a-f][0-9a-f]";
            }
        }
        return "[0-9a-f][0-9a-f]";
    }

    public void printIndexDefinition() {
        this.info("Index" + this.idxname);
        this.info("COLUMNS: " + this.columnnames);
    }

    public String toString() {
        String output = "";
        return output;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexDescriptor) {
            IndexDescriptor c = (IndexDescriptor)o;
            return this.idxname.equals(c.idxname);
        }
        return false;
    }
}

