/*
 * Decompiled with CFR 0.152.
 */
package fqlite.descriptor;

import fqlite.descriptor.AbstractDescriptor;
import fqlite.pattern.HeaderPattern;
import fqlite.util.Auxiliary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableDescriptor
extends AbstractDescriptor
implements Comparable<TableDescriptor> {
    String regex = "";
    String delregex = "";
    public List<String> serialtypes;
    public List<String> columnnames;
    public List<String> sqltypes;
    public List<String> constraints;
    public List<String> tableconstraints;
    public List<String> primarykeycolumns;
    int size = 0;
    int numberofmultibytecolumns = 0;
    String signature = "";
    public String tblname = "";
    public int root = -1;
    public boolean ROWID = true;
    private HeaderPattern hpattern = null;
    public boolean virtual = false;
    public String modulname = null;
    public String sql = "";
    public String rowidcolumn = null;

    public boolean checkMatch(String match) {
        try {
            byte[] bcol = Auxiliary.decode(match);
            long[] values = Auxiliary.readVarInt(bcol);
            int headerlength = (int)values[0];
            this.info(Integer.toString(headerlength));
            boolean valid = true;
            for (int i = 1; i < values.length; ++i) {
                String type;
                switch (type = this.getColumntypes().get(i - 1)) {
                    case "INT": {
                        valid = values[i] >= 0L && values[i] <= 6L;
                        break;
                    }
                    case "REAL": {
                        valid = values[i] == 7L;
                        break;
                    }
                    case "TEXT": {
                        if (values[i] == 0L) {
                            valid = true;
                            break;
                        }
                        if (values[i] % 2L != 0L) {
                            valid = values[i] > 13L;
                            break;
                        }
                        valid = false;
                        break;
                    }
                    case "BLOB": {
                        if (values[i] == 0L) {
                            valid = true;
                            break;
                        }
                        if (values[i] % 2L == 0L) {
                            valid = values[i] > 12L;
                            break;
                        }
                        valid = false;
                        break;
                    }
                    case "NUMERIC": {
                        boolean bl = valid = values[i] >= 0L && values[i] <= 9L;
                    }
                }
                if (valid) continue;
                return false;
            }
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.tblname;
    }

    public void setModulname(String name) {
        this.modulname = name;
    }

    public String getModulename() {
        return this.modulname;
    }

    public void signature(List<String> col) {
        this.signature = "";
        Iterator<String> iter = this.getColumntypes().iterator();
        while (iter.hasNext()) {
            this.signature = this.signature + iter.next();
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public TableDescriptor(String tblname, String stmt, List<String> sqltypes, List<String> col, List<String> names, List<String> constraints, List<String> tableconstraints, HeaderPattern pattern, boolean withoutROWID) {
        int i;
        this.setHpattern(pattern);
        this.setColumntypes(col);
        this.signature(col);
        this.sqltypes = sqltypes;
        this.constraints = constraints;
        this.tableconstraints = tableconstraints;
        this.columnnames = names;
        this.ROWID = !withoutROWID;
        this.sql = stmt;
        this.tblname = tblname;
        this.primarykeycolumns = new LinkedList<String>();
        for (i = 0; i < names.size(); ++i) {
            if (null != constraints) {
                this.info("tblname: " + tblname);
            }
            if (tblname.equals("__UNASSIGNED")) break;
            if (!constraints.get(i).contains("PRIMARYKEY")) continue;
            this.primarykeycolumns.add(names.get(i));
        }
        if (null != tableconstraints) {
            for (i = 0; i < tableconstraints.size(); ++i) {
                String constraint = tableconstraints.get(i);
                Matcher m = Pattern.compile("PRIMARYKEY\\((.*?)\\)").matcher(constraint);
                while (m.find()) {
                    String[] parts;
                    String key = m.group(1);
                    this.info("Table Constraint Key " + key);
                    if (!key.contains(",")) {
                        this.primarykeycolumns.add(key);
                        continue;
                    }
                    for (String c : parts = key.split(",")) {
                        this.primarykeycolumns.add(c);
                    }
                }
            }
        }
        if (this.primarykeycolumns.size() == 1) {
            i = names.indexOf(this.primarykeycolumns.get(0));
            this.info("Primary key column :: " + i);
            if (i >= 0 && sqltypes.get(i).toUpperCase().equals("INTEGER") && !constraints.get(i).toUpperCase().contains("DESC")) {
                this.info("Attention! integer primary key: " + names.get(i));
                this.rowidcolumn = names.get(i);
                pattern.change2RowID(i);
            }
        }
        this.setHpattern(pattern);
        for (String columnType : this.getColumntypes()) {
            ++this.size;
            this.regex = this.regex + this.getColumn(columnType, false);
        }
    }

    public void setVirtual(boolean val) {
        this.virtual = val;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public Pattern getStandardPattern() {
        return Pattern.compile((Auxiliary.byteToHex((byte)(this.size + 1)) + this.regex).trim());
    }

    public Pattern getPatternWithoutHeaderLength() {
        return Pattern.compile(this.regex.trim());
    }

    public Pattern getPatternWithoutFirstCol() {
        return Pattern.compile(this.getPattern(1, this.size, false));
    }

    public String getPattern(int startcolumn, int endcolumn, boolean multicol) {
        String pat = "";
        for (int i = startcolumn; i < endcolumn; ++i) {
            pat = pat + this.getColumn(this.getColumntypes().get(i), multicol);
        }
        return pat;
    }

    public int getRootOffset() {
        return this.root;
    }

    public int getLength() {
        return 1 + this.size;
    }

    public int numberofColumns() {
        return this.getColumntypes().size();
    }

    public Pattern getPatternMultiCol() {
        return Pattern.compile(this.getPattern(0, this.size, true));
    }

    private String getColumn(String serialtype, boolean multicol) {
        switch (serialtype) {
            case "INT": {
                return "0[0-6]";
            }
            case "REAL": {
                return "07";
            }
            case "TEXT": {
                if (multicol) {
                    return "[0-9a-f][0-9a-f]{0,4}";
                }
                return "[0-9a-f][0-9a-f]";
            }
            case "BLOB": {
                if (multicol) {
                    return "[0-9a-f][0-9a-f]{0,4}";
                }
                return "[0-9a-f][0-9a-f]";
            }
        }
        return "[0-9a-f][0-9a-f]";
    }

    public Pattern[] getRegex() {
        Pattern[] headers = new Pattern[]{this.getStandardPattern(), this.getPatternWithoutHeaderLength(), this.getPatternMultiCol(), this.getPatternWithoutFirstCol()};
        return headers;
    }

    public void printTableDefinition() {
        this.info("TABLE" + this.tblname);
        this.info("COLUMNS: " + this.columnnames);
    }

    public String toString() {
        Pattern[] elements = this.getRegex();
        String output = "";
        for (Pattern s : elements) {
            output = output + s + "\n";
        }
        return output;
    }

    public boolean equals(Object o) {
        return this.regex.equals(((TableDescriptor)o).regex);
    }

    public List<String> getColumntypes() {
        return this.serialtypes;
    }

    public void setColumntypes(List<String> columntypes) {
        this.serialtypes = columntypes;
    }

    public HeaderPattern getHpattern() {
        return this.hpattern;
    }

    public void setHpattern(HeaderPattern hpattern) {
        this.hpattern = hpattern;
    }

    @Override
    public int compareTo(TableDescriptor o) {
        return this.tblname.compareTo(o.tblname);
    }
}

