/*
 * Decompiled with CFR 0.152.
 */
package fqlite.parser;

import fqlite.base.Job;
import fqlite.descriptor.IndexDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.parser.TableParser;
import fqlite.util.Logger;
import java.util.ArrayList;

public class SQLiteSchemaParser {
    public ArrayList<Integer> roots = new ArrayList();

    public void parse(Job job, String tablename, int root, String sql) {
        int indexrowid;
        boolean rowid = true;
        int indextabledef = sql.indexOf("indexsqlite_autoindex_");
        if (indextabledef != -1) {
            Logger.out.debug(" internal indices component");
        }
        if ((indexrowid = sql.indexOf("WITHOUT ROWID")) != -1) {
            Logger.out.debug(" attention: component " + tablename + " is defined as WITHOUT ROWID");
            rowid = false;
        }
        this.roots.add(root);
        TableParser p = new TableParser();
        if (sql.contains("CREATE TABLE")) {
            TableDescriptor tds = p.parseCREATETABLEStatement(sql);
            if (null != tds) {
                if (tds.isVirtual()) {
                    job.virtualTables.put(tds.tblname, tds);
                }
                Logger.out.debug(tds.getStandardPattern().toString());
                tds.tblname = tablename;
                tds.ROWID = rowid;
                if (!job.headers.containsKey(tablename)) {
                    job.headers.put(tablename, tds);
                    tds.root = root;
                }
            }
        } else if (sql.contains("CREATE INDEX")) {
            IndexDescriptor ids = p.parseCREATEIndexStatement(sql);
            if (null == ids || null == ids.getName()) {
                return;
            }
            if (!job.indices.containsKey(ids.getName())) {
                job.indices.put(ids.getName(), ids);
                ids.root = root;
            }
        }
        int index = -1;
        index = sql.indexOf("CREATE INDEX");
        if (index > 0) {
            byte i = (byte)sql.charAt(index - 1);
            Logger.out.info(" First root page of Index-Table: " + i);
            this.roots.add(Integer.valueOf(i));
            return;
        }
        index = -1;
        index = sql.indexOf("CREATE UNIQUE INDEX");
        if (index > 0) {
            byte i = (byte)sql.charAt(index - 1);
            Logger.out.info(" First root page of Index-Table: " + i);
            this.roots.add(Integer.valueOf(i));
            return;
        }
    }
}

