/*
 * Decompiled with CFR 0.152.
 */
package fqlite.parser;

import fqlite.base.Base;
import fqlite.descriptor.IndexDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.parser.SQLiteBaseListener;
import fqlite.parser.SQLiteLexer;
import fqlite.parser.SQLiteParser;
import fqlite.pattern.HeaderPattern;
import fqlite.pattern.IntegerConstraint;
import fqlite.util.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SimpleSQLiteParser
extends Base {
    static String[] inttypes = new String[]{"INT", "INTEGER", "INTUNSIGNED", "INTSIGNED", "LONG", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "UNSIGNEDBIGINT", "INT2", "INT8"};
    static String[] texttypes = new String[]{"TEXT", "CHARACTER", "CLOB", "VARCHAR", "VARYINGCHARACTER", "NCHAR", "NATIVE CHARACTER", "NVARCHAR"};
    static String[] blobtype = new String[]{"BLOB"};
    static String[] realtype = new String[]{"REAL", "DOUBLE", "DOUBLEPRECISION", "FLOAT"};
    static String[] numerictype = new String[]{"NUMERIC", "DECIMAL", "BOOLEAN", "DATE", "DATETIME"};
    SQLiteLexer lexer;
    String tablename = null;
    String modulname = null;
    List<String> coltypes = new ArrayList<String>();
    List<String> sqltypes = new ArrayList<String>();
    List<String> colconstraints = new ArrayList<String>();
    List<String> colnames = new ArrayList<String>();
    List<String> tableconstraint = new ArrayList<String>();
    Map<Integer, String> constraints = new HashMap<Integer, String>();
    HeaderPattern pattern = new HeaderPattern();
    TableDescriptor tds = null;
    IndexDescriptor ids = null;
    int column;
    String idxname;

    public TableDescriptor parseTable(String stmt) {
        if (stmt.indexOf("CREATE TABLE") >= 0) {
            return this.parseCreateTable(stmt);
        }
        if (stmt.indexOf("CREATE TEMP TABLE") >= 0) {
            Logger.out.debug("Found CREATE TEMP TABLE statement");
        } else if (stmt.indexOf("CREATE VIRTUAL TABLE") >= 0) {
            return this.parseCreateVirtualTable(stmt);
        }
        return null;
    }

    public IndexDescriptor parseIndex(String stmt) {
        if (stmt.indexOf("CREATE INDEX ") >= 0) {
            return this.parseCreateIndex(stmt);
        }
        return null;
    }

    public String trim(String value) {
        if ((value.startsWith("'") || value.startsWith("\"")) && ((value = value.substring(1)).endsWith("'") || value.endsWith("\""))) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private TableDescriptor parseCreateVirtualTable(String stmt) {
        this.column = 0;
        this.modulname = null;
        SQLiteLexer lexer = new SQLiteLexer((CharStream)CharStreams.fromString((String)stmt));
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser parser = new SQLiteParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser.Create_virtual_table_stmtContext tree = parser.create_virtual_table_stmt();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new SQLiteBaseListener(){

            @Override
            public void enterTable_name(SQLiteParser.Table_nameContext ctx) {
                SimpleSQLiteParser.this.tablename = ctx.getText();
                SimpleSQLiteParser.this.tablename = SimpleSQLiteParser.this.trim(SimpleSQLiteParser.this.tablename);
                if (SimpleSQLiteParser.this.tablename.length() == 0) {
                    SimpleSQLiteParser.this.tablename = "<no name>";
                }
                SimpleSQLiteParser.this.info("Tablename " + SimpleSQLiteParser.this.tablename);
            }

            @Override
            public void enterModule_name(SQLiteParser.Module_nameContext ctx) {
                SimpleSQLiteParser.this.modulname = ctx.getText();
                SimpleSQLiteParser.this.info(" name " + SimpleSQLiteParser.this.modulname);
                if (SimpleSQLiteParser.this.modulname.equals("fts4") || SimpleSQLiteParser.this.modulname.equals("fts3")) {
                    SimpleSQLiteParser.this.info("Found FreeTextSearch Module (fts3/4)");
                } else if (SimpleSQLiteParser.this.modulname.equals("rtree")) {
                    SimpleSQLiteParser.this.info("Found rtree Module");
                }
            }

            @Override
            public void enterModule_argument(SQLiteParser.Module_argumentContext ctx) {
                String modulargument = ctx.getText();
                SimpleSQLiteParser.this.info(" arg " + modulargument);
                if (SimpleSQLiteParser.this.modulname.equals("rtree")) {
                    SimpleSQLiteParser.this.colnames.add(modulargument);
                    if (SimpleSQLiteParser.this.column == 0) {
                        SimpleSQLiteParser.this.coltypes.add("INT");
                    } else {
                        SimpleSQLiteParser.this.coltypes.add("NUMERIC");
                    }
                    ++SimpleSQLiteParser.this.column;
                }
            }
        }, (ParseTree)tree);
        this.tds = new TableDescriptor(this.tablename, stmt, this.sqltypes, this.coltypes, this.colnames, this.colconstraints, this.tableconstraint, null, stmt.contains("WITHOUT ROWID"));
        this.tds.setVirtual(true);
        if (null != this.modulname) {
            this.tds.setModulname(this.modulname);
        }
        return this.tds;
    }

    private IndexDescriptor parseCreateIndex(String stmt) {
        this.column = 0;
        SQLiteLexer lexer = new SQLiteLexer((CharStream)CharStreams.fromString((String)stmt));
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser parser = new SQLiteParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser.Create_index_stmtContext tree = parser.create_index_stmt();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new SQLiteBaseListener(){

            @Override
            public void enterIndex_name(SQLiteParser.Index_nameContext ctx) {
                SimpleSQLiteParser.this.idxname = ctx.getText();
                SimpleSQLiteParser.this.info("INDEX " + SimpleSQLiteParser.this.idxname);
            }

            @Override
            public void enterIndexed_column(SQLiteParser.Indexed_columnContext ctx) {
                String colname = ctx.getText();
                colname = SimpleSQLiteParser.this.trim(colname);
                SimpleSQLiteParser.this.colnames.add(colname);
                SimpleSQLiteParser.this.info("Columnname " + colname);
            }

            @Override
            public void enterTable_name(SQLiteParser.Table_nameContext ctx) {
                SimpleSQLiteParser.this.tablename = ctx.getText();
                SimpleSQLiteParser.this.tablename = SimpleSQLiteParser.this.trim(SimpleSQLiteParser.this.tablename);
                if (SimpleSQLiteParser.this.tablename.length() == 0) {
                    SimpleSQLiteParser.this.tablename = "<no name>";
                }
                SimpleSQLiteParser.this.info("Tablename " + SimpleSQLiteParser.this.tablename);
            }
        }, (ParseTree)tree);
        return new IndexDescriptor(this.idxname, this.tablename, stmt, this.colnames);
    }

    private TableDescriptor parseCreateTable(final String stmt) {
        this.column = 0;
        SQLiteLexer lexer = new SQLiteLexer((CharStream)CharStreams.fromString((String)stmt));
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser parser = new SQLiteParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        SQLiteParser.Create_table_stmtContext tree = parser.create_table_stmt();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new SQLiteBaseListener(){
            boolean tblconstraint = false;
            boolean inForeignTable = false;
            String cons = "";
            boolean isTableConstraint = false;

            @Override
            public void enterTable_name(SQLiteParser.Table_nameContext ctx) {
                this.isTableConstraint = false;
                SimpleSQLiteParser.this.tablename = ctx.getText();
                SimpleSQLiteParser.this.tablename = SimpleSQLiteParser.this.trim(SimpleSQLiteParser.this.tablename);
                if (SimpleSQLiteParser.this.tablename.length() == 0) {
                    SimpleSQLiteParser.this.tablename = "<no name>";
                }
                SimpleSQLiteParser.this.info("Tablename " + SimpleSQLiteParser.this.tablename);
            }

            @Override
            public void enterColumn_name(SQLiteParser.Column_nameContext ctx) {
                if (this.inForeignTable) {
                    this.inForeignTable = false;
                    return;
                }
                if (this.isTableConstraint) {
                    return;
                }
                this.cons = "";
                String colname = ctx.getText();
                SimpleSQLiteParser.this.info("enterColumn_name()::colname =" + colname);
                if (!colname.equals("CONSTRAINT")) {
                    colname = SimpleSQLiteParser.this.trim(colname);
                    SimpleSQLiteParser.this.colnames.add(colname);
                    SimpleSQLiteParser.this.info("Columnname " + colname);
                } else {
                    SimpleSQLiteParser.this.info("aha!!!");
                    this.tblconstraint = true;
                }
            }

            @Override
            public void enterForeign_table(SQLiteParser.Foreign_tableContext ctx) {
                SimpleSQLiteParser.this.info("Enter foreign Table!!!");
                this.inForeignTable = true;
            }

            @Override
            public void exitForeign_table(SQLiteParser.Foreign_tableContext ctx) {
                SimpleSQLiteParser.this.info("Exit foreign Table!!!");
            }

            @Override
            public void enterType_name(SQLiteParser.Type_nameContext ctx) {
                String value = ctx.getText();
                value = value.trim();
                if (this.tblconstraint) {
                    SimpleSQLiteParser.this.info("Table Constraint: " + value);
                    SimpleSQLiteParser.this.tableconstraint.add(value);
                    this.tblconstraint = false;
                } else {
                    SimpleSQLiteParser.this.sqltypes.add(value);
                    SimpleSQLiteParser.this.info("SQLType::" + value);
                    String type = SimpleSQLiteParser.this.getType(value);
                    if (type.length() > 0) {
                        SimpleSQLiteParser.this.coltypes.add(type);
                        SimpleSQLiteParser.this.info("Typename " + SimpleSQLiteParser.this.trim(type));
                    }
                }
            }

            @Override
            public void enterKeyword(SQLiteParser.KeywordContext ctx) {
                SimpleSQLiteParser.this.info("Enter keyword ");
            }

            @Override
            public void exitKeyword(SQLiteParser.KeywordContext ctx) {
                SimpleSQLiteParser.this.info("Exit keyword ");
            }

            @Override
            public void enterColumn_constraint(SQLiteParser.Column_constraintContext ctx) {
                String constraint = ctx.getText().toUpperCase();
                if (constraint.contains("NOTNULL")) {
                    SimpleSQLiteParser.this.constraints.put(SimpleSQLiteParser.this.column, constraint);
                }
            }

            @Override
            public void exitColumn_constraint(SQLiteParser.Column_constraintContext ctx) {
                String constraint = ctx.getText();
                SimpleSQLiteParser.this.info("Columnconstraint " + constraint);
                this.cons = this.cons + constraint.toUpperCase() + " ";
            }

            @Override
            public void exitColumn_def(SQLiteParser.Column_defContext ctx) {
                SimpleSQLiteParser.this.info("adding cons:" + this.cons);
                SimpleSQLiteParser.this.colconstraints.add(this.cons);
                ++SimpleSQLiteParser.this.column;
            }

            @Override
            public void enterTable_constraint(SQLiteParser.Table_constraintContext ctx) {
                this.isTableConstraint = true;
                SimpleSQLiteParser.this.info("Table_constraint :: " + ctx.getText());
                SimpleSQLiteParser.this.tableconstraint.add(ctx.getText());
            }

            @Override
            public void exitCreate_table_stmt(SQLiteParser.Create_table_stmtContext ctx) {
                HeaderPattern pattern = new HeaderPattern();
                pattern.addHeaderConstraint(SimpleSQLiteParser.this.colnames.size() + 1, SimpleSQLiteParser.this.colnames.size() * 2);
                int cc = 0;
                ListIterator<String> list = SimpleSQLiteParser.this.coltypes.listIterator();
                while (list.hasNext()) {
                    switch (list.next()) {
                        case "INT": {
                            if (SimpleSQLiteParser.this.constraints.containsKey(cc)) {
                                pattern.add(new IntegerConstraint(true));
                                break;
                            }
                            pattern.add(new IntegerConstraint(false));
                            break;
                        }
                        case "TEXT": {
                            pattern.addStringConstraint();
                            break;
                        }
                        case "BLOB": {
                            pattern.addBLOBConstraint();
                            break;
                        }
                        case "REAL": {
                            pattern.addFloatingConstraint();
                            break;
                        }
                        case "NUMERIC": {
                            pattern.addNumericConstraint();
                        }
                    }
                    ++cc;
                }
                SimpleSQLiteParser.this.tds = new TableDescriptor(SimpleSQLiteParser.this.tablename, stmt, SimpleSQLiteParser.this.sqltypes, SimpleSQLiteParser.this.coltypes, SimpleSQLiteParser.this.colnames, SimpleSQLiteParser.this.colconstraints, SimpleSQLiteParser.this.tableconstraint, pattern, stmt.contains("WITHOUT ROWID"));
                SimpleSQLiteParser.this.info("PATTTERN: " + pattern);
            }
        }, (ParseTree)tree);
        return this.tds;
    }

    private String getType(String s) {
        String type = "";
        s = s.toUpperCase();
        this.info("Datentyp" + s);
        if (s.startsWith("TIMESTAMP")) {
            type = "INT";
        } else if (SimpleSQLiteParser.stringContainsItemFromList(s, texttypes)) {
            type = "TEXT";
        } else if (SimpleSQLiteParser.stringContainsItemFromList(s, inttypes)) {
            type = "INT";
        } else if (SimpleSQLiteParser.stringContainsItemFromList(s, blobtype)) {
            type = "BLOB";
        } else if (SimpleSQLiteParser.stringContainsItemFromList(s, realtype)) {
            type = "REAL";
        } else if (SimpleSQLiteParser.stringContainsItemFromList(s, numerictype)) {
            type = "NUMERIC";
        }
        return type;
    }

    public static boolean stringContainsItemFromList(String inputStr, String[] items) {
        return ((Stream)Arrays.stream(items).parallel()).anyMatch(inputStr::contains);
    }
}

