/*
 * Decompiled with CFR 0.152.
 */
package fqlite.pattern;

import fqlite.pattern.HeaderPattern;
import fqlite.pattern.MatchingMode;
import fqlite.util.Auxiliary;
import fqlite.util.BufferUtil;
import java.nio.ByteBuffer;

public class SerialTypeMatcher {
    HeaderPattern pattern = null;
    ByteBuffer buffer = null;
    int pos = 0;
    int startRegion;
    int endRegion;
    int start;
    int end;
    MatchingMode mode = MatchingMode.NORMAL;

    public SerialTypeMatcher(ByteBuffer buffer) {
        this.buffer = buffer;
        this.startRegion = 0;
        this.endRegion = buffer.capacity();
        buffer.position(0);
    }

    public void setMatchingMode(MatchingMode newMode) {
        this.mode = newMode;
    }

    public MatchingMode getMachtingMode() {
        return this.mode;
    }

    public void setPattern(HeaderPattern pattern) {
        this.pattern = pattern;
    }

    public void region(int from, int to) {
        this.startRegion = from;
        this.endRegion = to;
        this.buffer.position(from);
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }

    public boolean find() {
        int idx = 0;
        switch (this.mode) {
            case NORMAL: {
                idx = 0;
                break;
            }
            case NOHEADER: {
                idx = 1;
                break;
            }
            case NO1stCOL: {
                idx = 2;
            }
        }
        int i = idx;
        if (i < this.pattern.size()) {
            while (i < this.pattern.size()) {
                if (this.buffer.position() < this.endRegion - 4) {
                    int value;
                    int current = this.buffer.position();
                    if (i == idx) {
                        this.pos = current;
                    }
                    if ((value = this.readUnsignedVarInt()) == -1 || !this.pattern.get(i).match(value)) {
                        this.buffer.position(++current);
                        i = idx;
                        continue;
                    }
                    ++i;
                    continue;
                }
                return false;
            }
        } else {
            this.pos = this.buffer.position() + 1;
            return false;
        }
        this.start = this.pos;
        this.end = this.buffer.position();
        return this.end > this.start;
    }

    public ByteBuffer group() {
        byte[] match = BufferUtil.allocateByteBuffer(this.end - this.start);
        this.buffer.position(this.start);
        this.buffer.get(match, 0, this.end - this.start);
        return ByteBuffer.wrap(match);
    }

    public String substring(int start, int end) {
        if (start > end) {
            return "";
        }
        byte[] match = BufferUtil.allocateByteBuffer(end - start);
        this.buffer.position(start);
        this.buffer.get(match, 0, end - start);
        return Auxiliary.bytesToHex(match);
    }

    public String group2Hex() {
        return this.substring(this.start, this.end);
    }

    public int readUnsignedVarInt() {
        int value = 0;
        byte b = 0;
        int counter = 0;
        int shift = 0;
        while (((b = this.buffer.get()) & 0x80) != 0 && counter < 3) {
            ++counter;
            value |= (b & 0x7F) << (shift += 7);
        }
        if ((b & 0x80) != 0) {
            return -1;
        }
        return value | b;
    }
}

