/*
 * Decompiled with CFR 0.152.
 */
package fqlite.util;

import fqlite.base.Base;
import fqlite.base.Job;
import fqlite.base.SqliteElement;
import fqlite.base.SqliteElementData;
import fqlite.base.SqliteInternalRow;
import fqlite.descriptor.IndexDescriptor;
import fqlite.descriptor.TableDescriptor;
import fqlite.pattern.HeaderPattern;
import fqlite.pattern.IntegerConstraint;
import fqlite.types.SerialTypes;
import fqlite.types.StorageClasses;
import fqlite.util.BufferUtil;
import fqlite.util.CarvingResult;
import fqlite.util.Logger;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Auxiliary
extends Base {
    private static final int TABLELEAFPAGE = 13;
    private static final int TABLEINTERIORPAGE = 5;
    private static final int INDEXLEAFPAGE = 10;
    private static final int INDEXINTERIORPAGE = 2;
    private static final int OVERFLOWPAGE = 0;
    private Job job;
    private static byte[] HEX_DIGITS = "0123456789abcdef".getBytes();
    private static final int[] FALSE_INT_ARRAY_RESP = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};

    public Auxiliary(Job job) {
        this.job = job;
    }

    public static int getPageType(byte byteType) {
        boolean skip = false;
        switch (byteType) {
            case 13: {
                return 8;
            }
            case 5: {
                return 12;
            }
            case 10: {
                skip = true;
                return 10;
            }
            case 2: {
                skip = true;
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        skip = true;
        if (skip) {
            return -1;
        }
        return -99;
    }

    public boolean readMasterTableRecord(int start, ByteBuffer buffer, int headerSize) throws IOException {
        buffer.position(start);
        byte[] headerBytes = BufferUtil.allocateByteBuffer(headerSize - 1);
        buffer.get(headerBytes);
        SqliteElement[] columns = Auxiliary.convertHeaderToSqliteElements(headerBytes, this.job.db_encoding);
        if (null == columns) {
            return false;
        }
        int con = 0;
        String tablename = null;
        int rootpage = -1;
        String statement = null;
        for (SqliteElement en : columns) {
            if (en == null) continue;
            byte[] value = BufferUtil.allocateByteBuffer(en.length);
            try {
                buffer.get(value);
            }
            catch (BufferUnderflowException bue) {
                return false;
            }
            if (con == 2) {
                tablename = en.toString(value);
            }
            if (con == 3) {
                if (value.length == 0) {
                    this.debug("Seems to be a virtual component -> no root page ;)");
                } else {
                    rootpage = SqliteElement.decodeInt8(value[0]);
                }
            }
            if (con == 4) {
                statement = en.toString(value);
                break;
            }
            ++con;
        }
        if (tablename == null || statement == null || rootpage < 0) {
            return false;
        }
        this.job.schemaParser.parse(this.job, tablename, rootpage, statement);
        return true;
    }

    public CarvingResult readDeletedRecord(Job job, int start, ByteBuffer buffer, String header, BitSet bs, int pagenumber) throws IOException {
        buffer.position(start);
        int recordstart = start - header.length() / 2;
        header = header.substring(2);
        SqliteElement[] columns = Auxiliary.toColumns(header, job.db_encoding);
        if (null == columns) {
            return null;
        }
        SqliteInternalRow row = new SqliteInternalRow();
        String fp = null;
        try {
            fp = Auxiliary.getTableFingerPrint(columns);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null == fp) {
            fp = "unkown";
        }
        boolean error = false;
        row.setOffset((pagenumber - 1) * job.ps + buffer.position());
        int pll = this.computePayloadLength(header);
        int so = this.computePayload(pll);
        int overflow = -1;
        if (so < pll) {
            ByteBuffer bf;
            int phl = header.length() / 2;
            int last = buffer.position();
            this.debug(" deleted spilled payload ::", so);
            this.debug(" deleted pll payload ::", pll);
            buffer.position(buffer.position() + so - phl - 1);
            overflow = buffer.getInt();
            this.debug(" deleted overflow::::::::: ", overflow, " ", Integer.toHexString(overflow));
            buffer.position(last);
            if (overflow > 0 && overflow < job.numberofpages) {
                byte[] byArray = this.readOverflowIterativ(overflow - 1);
                byte[] c = BufferUtil.allocateByteBuffer(pll + job.ps);
                buffer.position(0);
                byte[] originalbuffer = BufferUtil.allocateByteBuffer(job.ps);
                for (int bb = 0; bb < job.ps; ++bb) {
                    originalbuffer[bb] = buffer.get(bb);
                }
                buffer.position(last);
                bf = null;
                System.arraycopy(originalbuffer, buffer.position(), c, 0, so + 7);
                try {
                    if (null != byArray) {
                        System.arraycopy(byArray, 0, c, so - phl - 1, pll - so);
                    }
                    bf = ByteBuffer.wrap(c);
                }
                catch (ArrayIndexOutOfBoundsException err) {
                    this.info("Error IndexOutOfBounds");
                }
                catch (NullPointerException err2) {
                    this.info("Error NullPointer in ");
                }
            } else {
                pll = so;
                bf = buffer;
            }
            bf.position(0);
            for (SqliteElement en : columns) {
                if (en == null) continue;
                byte[] value = BufferUtil.allocateByteBuffer(en.length);
                bf.get(value);
                row.append(new SqliteElementData(en, value));
            }
            buffer.position(last + so - phl - 1);
        } else {
            for (SqliteElement sqliteElement : columns) {
                if (sqliteElement == null) continue;
                byte[] value = BufferUtil.allocateByteBuffer(sqliteElement.length);
                if (buffer.position() + sqliteElement.length > buffer.limit()) {
                    error = true;
                    return null;
                }
                buffer.get(value);
                row.append(new SqliteElementData(sqliteElement, value));
            }
            if (error) {
                return null;
            }
        }
        bs.set(recordstart, buffer.position() - 1, true);
        this.debug("visited :: ", recordstart, " to ", buffer.position());
        int cursor = (pagenumber - 1) * job.ps + buffer.position();
        this.debug("visited :: ", (pagenumber - 1) * job.ps + recordstart, " to ", cursor);
        row.setLineSuffix("##header##" + header);
        this.debug((Object)row);
        return new CarvingResult(buffer.position(), cursor, row);
    }

    public SqliteInternalRow readRecord(int cellstart, ByteBuffer buffer, int pagenumber_db, BitSet bs, int pagetype, int maxlength, StringBuffer firstcol, boolean withoutROWID, int filepointer) throws IOException {
        int phl;
        boolean unkown = false;
        buffer.position(0);
        SqliteInternalRow row = new SqliteInternalRow();
        if (filepointer > 0) {
            if (this.job.pages.length > pagenumber_db) {
                if (null != this.job.pages[pagenumber_db]) {
                    row.setTableName(this.job.pages[pagenumber_db].getName());
                }
            } else {
                row.setTableName("__UNASSIGNED");
            }
            row.setRecordType(" ");
            row.setOffset(filepointer + cellstart);
        } else if (null != this.job.pages[pagenumber_db]) {
            row.setTableName(this.job.pages[pagenumber_db].getName());
            row.setRecordType(" ");
            row.setOffset((pagenumber_db - 1) * this.job.ps + cellstart);
        } else {
            unkown = true;
        }
        this.info("cellstart for pll: ", (pagenumber_db - 1) * this.job.ps + cellstart);
        buffer.position(cellstart);
        int pll = (int)Auxiliary.readUnsignedVarInt(buffer);
        this.debug("Length of payload int : ", pll, " as hex : ", Integer.toHexString(pll));
        if (pll < 4) {
            return null;
        }
        long rowid = 0L;
        if (!withoutROWID) {
            if (unkown) {
                rowid = Auxiliary.readUnsignedVarInt(buffer);
                this.debug("rowid: ", Long.toHexString(rowid));
            } else if (pagenumber_db < this.job.pages.length && (null == this.job.pages[pagenumber_db] || this.job.pages[pagenumber_db].ROWID)) {
                rowid = Auxiliary.readUnsignedVarInt(buffer);
                this.debug("rowid: ", Long.toHexString(rowid));
            }
        }
        if ((phl = (int)Auxiliary.readUnsignedVarInt(buffer)) == 0) {
            return null;
        }
        this.debug("Header Length int: ", phl, " as hex : ", Integer.toHexString(phl));
        maxlength -= --phl;
        if (phl <= 0) {
            return null;
        }
        int pp = buffer.position();
        String hh = "";
        if (this.job.collectInternalRows) {
            hh = this.getHeaderString(phl, buffer);
        }
        buffer.position(pp);
        SqliteElement[] columns = this.getColumns(phl, buffer, firstcol);
        if (null == columns) {
            this.debug(" No valid header. Skip recovery.");
            return null;
        }
        int co = 0;
        try {
            if (unkown) {
                TableDescriptor td = this.matchTable(columns);
                if (null == td) {
                    row.setTableName("__UNASSIGNED");
                } else {
                    row.setTableName(td.tblname);
                    this.job.pages[pagenumber_db] = td;
                }
                row.setRecordType(" ");
                row.setOffset((pagenumber_db - 1) * this.job.ps + cellstart);
            }
        }
        catch (NullPointerException err) {
            System.err.println(err);
        }
        boolean error = false;
        int so = this.computePayload(pll);
        int overflow = -1;
        if (so < pll) {
            int last = buffer.position();
            this.debug("regular spilled payload ::", so);
            if (buffer.position() + so - phl - 1 > buffer.limit() - 4) {
                return null;
            }
            try {
                buffer.position(buffer.position() + so - phl - 1);
                overflow = buffer.getInt();
            }
            catch (Exception err) {
                return null;
            }
            if (overflow < 0) {
                return null;
            }
            this.debug("regular overflow::::::::: ", overflow, " ", Integer.toHexString(overflow));
            buffer.position(last);
            byte[] extended = this.readOverflowIterativ(overflow - 1);
            byte[] c = BufferUtil.allocateByteBuffer(pll + this.job.ps);
            buffer.position(0);
            byte[] originalbuffer = BufferUtil.allocateByteBuffer(this.job.ps);
            for (int bb = 0; bb < this.job.ps; ++bb) {
                originalbuffer[bb] = buffer.get(bb);
            }
            buffer.position(last);
            int lenToCopy = so + 7;
            if (lenToCopy > c.length) {
                lenToCopy = c.length;
            }
            if (lenToCopy > originalbuffer.length - buffer.position()) {
                lenToCopy = originalbuffer.length - buffer.position();
            }
            System.arraycopy(originalbuffer, buffer.position(), c, 0, lenToCopy);
            try {
                if (null != extended) {
                    System.arraycopy(extended, 0, c, so - phl - 1, pll - so);
                }
            }
            catch (ArrayIndexOutOfBoundsException err) {
                this.err("Error IndexOutOfBounds");
            }
            catch (NullPointerException err2) {
                this.err("Error NullPointer in ");
            }
            ByteBuffer bf = ByteBuffer.wrap(c);
            bf.position(0);
            co = 0;
            for (SqliteElement en : columns) {
                if (en == null) continue;
                if (!withoutROWID && co == 0 && en.length == 0) {
                    row.append(new SqliteElementData(en, rowid));
                } else if (en.length == 0) {
                    if (en.type == SerialTypes.INT0) {
                        row.append(new SqliteElementData(en, 0L));
                    } else {
                        row.append(new SqliteElementData(null, this.job.db_encoding));
                    }
                } else {
                    int len = en.length;
                    if (bf.limit() - bf.position() < len) {
                        this.info(" Bufferunderflow ", bf.limit() - bf.position(), " is lower than", len);
                        len = bf.limit() - bf.position();
                    }
                    try {
                        if (len > 0) {
                            byte[] value = BufferUtil.allocateByteBuffer(len);
                            bf.get(value);
                            row.append(new SqliteElementData(en, value));
                        } else {
                            row.append(new SqliteElementData(null, this.job.db_encoding));
                        }
                    }
                    catch (BufferUnderflowException bue) {
                        row.append(new SqliteElementData(null, this.job.db_encoding));
                        this.err("readRecord():: overflow java.nio.BufferUnderflowException");
                    }
                }
                ++co;
            }
        } else {
            co = 0;
            for (SqliteElement en : columns) {
                if (en == null) {
                    row.append(new SqliteElementData(null, this.job.db_encoding));
                    continue;
                }
                if (!withoutROWID && co == 0 && en.length == 0) {
                    row.append(new SqliteElementData(en, rowid));
                } else if (en.length == 0) {
                    if (en.type == SerialTypes.INT0) {
                        row.append(new SqliteElementData(en, 0L));
                    } else {
                        row.append(new SqliteElementData(null, this.job.db_encoding));
                    }
                } else {
                    byte[] value = null;
                    if (maxlength >= en.length) {
                        value = BufferUtil.allocateByteBuffer(en.length);
                    } else if (maxlength > 0) {
                        value = BufferUtil.allocateByteBuffer(maxlength);
                    }
                    maxlength -= en.length;
                    if (null == value) break;
                    try {
                        buffer.get(value);
                    }
                    catch (BufferUnderflowException err) {
                        this.info("readRecord():: no overflow ERROR ", err);
                        return null;
                    }
                    row.append(new SqliteElementData(en, value));
                }
                ++co;
                if (maxlength > 0) {
                    continue;
                }
                break;
            }
        }
        if (this.job.collectInternalRows) {
            row.setLineSuffix("##header##" + hh);
        }
        this.debug("visted ", cellstart, " to ", buffer.position());
        bs.set(cellstart, buffer.position());
        if (error) {
            this.err("spilles overflow page error ...");
            return null;
        }
        this.debug((Object)row);
        return row;
    }

    private TableDescriptor matchTable(SqliteElement[] header) {
        for (TableDescriptor table : this.job.headers.values()) {
            if (table.getColumntypes().size() != header.length) continue;
            int idx = 0;
            boolean eq = true;
            for (SqliteElement s : header) {
                String type = table.getColumntypes().get(idx);
                if (!s.serial.name().equals(type)) {
                    eq = false;
                    break;
                }
                ++idx;
            }
            if (!eq) continue;
            return table;
        }
        return null;
    }

    private byte[] readOverflowIterativ(int pagenumber) throws IOException {
        LinkedList<ByteBuffer> parts = new LinkedList<ByteBuffer>();
        boolean more = true;
        ByteBuffer overflowpage = null;
        int next = pagenumber;
        while (more) {
            this.info("before Read() ", next);
            overflowpage = this.job.readPageWithNumber(next, this.job.ps);
            if (overflowpage == null) {
                more = false;
                break;
            }
            overflowpage.position(0);
            next = overflowpage.getInt() - 1;
            this.info(" next overflow:: ", next);
            byte[] current = BufferUtil.allocateByteBuffer(this.job.ps - 4);
            overflowpage.position(4);
            overflowpage.get(current, 0, this.job.ps - 4);
            ByteBuffer part = ByteBuffer.wrap(current);
            parts.add(part);
            if (next >= 0 && next <= this.job.numberofpages) continue;
            this.debug("No further overflow pages");
            more = false;
        }
        if (parts == null || parts.size() == 0) {
            return ByteBuffer.allocate(0).array();
        }
        if (parts.size() == 1) {
            return ((ByteBuffer)parts.get(0)).array();
        }
        ByteBuffer fullContent = ByteBuffer.allocate(parts.stream().mapToInt(Buffer::capacity).sum());
        parts.forEach(fullContent::put);
        fullContent.flip();
        return fullContent.array();
    }

    public static byte[] decode(String s) {
        char[] data = s.toCharArray();
        int len = data.length;
        byte[] r = BufferUtil.allocateByteBuffer(len >> 1);
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Character.digit(data[j++], 16) << 4;
            r[i] = (byte)((f |= Character.digit(data[j++], 16)) & 0xFF);
            ++i;
        }
        return r;
    }

    private int computePayloadLength(String header) {
        byte[] bcol = Auxiliary.decode(header);
        long[] columns = Auxiliary.readVarInt(bcol);
        int pll = 0;
        pll += header.length() / 2 + 1;
        block14: for (int i = 0; i < columns.length; ++i) {
            switch ((int)columns[i]) {
                case 0: {
                    continue block14;
                }
                case 1: {
                    ++pll;
                    continue block14;
                }
                case 2: {
                    pll += 2;
                    continue block14;
                }
                case 3: {
                    pll += 3;
                    continue block14;
                }
                case 4: {
                    pll += 4;
                    continue block14;
                }
                case 5: {
                    pll += 6;
                    continue block14;
                }
                case 6: {
                    pll += 8;
                    continue block14;
                }
                case 7: {
                    pll += 8;
                    continue block14;
                }
                case 8: {
                    continue block14;
                }
                case 9: {
                    continue block14;
                }
                case 10: {
                    continue block14;
                }
                case 11: {
                    continue block14;
                }
                default: {
                    pll = columns[i] % 2L == 0L ? (int)((long)pll + (columns[i] - 12L) / 2L) : (int)((long)pll + (columns[i] - 13L) / 2L);
                }
            }
        }
        return pll;
    }

    public static SqliteElement[] toColumns(String header, Charset charset) {
        byte[] bcol = Auxiliary.decode(header);
        return Auxiliary.convertHeaderToSqliteElements(bcol, charset);
    }

    public String getHeaderString(int headerlength, ByteBuffer buffer) {
        byte[] header = BufferUtil.allocateByteBuffer(headerlength);
        try {
            buffer.get(header);
        }
        catch (Exception err) {
            this.err("ERROR ", err);
        }
        String sheader = Auxiliary.bytesToHex(header);
        return sheader;
    }

    public SqliteElement[] getColumns(int headerlength, ByteBuffer buffer, StringBuffer firstcol) throws IOException {
        byte[] header = BufferUtil.allocateByteBuffer(headerlength);
        try {
            buffer.get(header);
        }
        catch (Exception err) {
            this.err("Auxiliary::ERROR ", err);
            return null;
        }
        String sheader = Auxiliary.byteToHex(header[0]);
        if (sheader.length() > 1) {
            firstcol.insert(0, sheader);
        }
        return Auxiliary.convertHeaderToSqliteElements(header, this.job.db_encoding);
    }

    public static SqliteElement[] convertHeaderToSqliteElements(byte[] header, Charset charset) {
        long[] columns = Auxiliary.readVarInt(header);
        if (null == columns) {
            return null;
        }
        SqliteElement[] column = new SqliteElement[columns.length];
        block14: for (int i = 0; i < columns.length; ++i) {
            switch ((int)columns[i]) {
                case 0: {
                    column[i] = new SqliteElement(SerialTypes.PRIMARY_KEY, StorageClasses.INT, 0, charset);
                    continue block14;
                }
                case 1: {
                    column[i] = new SqliteElement(SerialTypes.INT8, StorageClasses.INT, 1, charset);
                    continue block14;
                }
                case 2: {
                    column[i] = new SqliteElement(SerialTypes.INT16, StorageClasses.INT, 2, charset);
                    continue block14;
                }
                case 3: {
                    column[i] = new SqliteElement(SerialTypes.INT24, StorageClasses.INT, 3, charset);
                    continue block14;
                }
                case 4: {
                    column[i] = new SqliteElement(SerialTypes.INT32, StorageClasses.INT, 4, charset);
                    continue block14;
                }
                case 5: {
                    column[i] = new SqliteElement(SerialTypes.INT48, StorageClasses.INT, 6, charset);
                    continue block14;
                }
                case 6: {
                    column[i] = new SqliteElement(SerialTypes.INT64, StorageClasses.INT, 8, charset);
                    continue block14;
                }
                case 7: {
                    column[i] = new SqliteElement(SerialTypes.FLOAT64, StorageClasses.FLOAT, 8, charset);
                    continue block14;
                }
                case 8: {
                    column[i] = new SqliteElement(SerialTypes.INT0, StorageClasses.INT, 0, charset);
                    continue block14;
                }
                case 9: {
                    column[i] = new SqliteElement(SerialTypes.INT1, StorageClasses.INT, 0, charset);
                    continue block14;
                }
                case 10: {
                    columns[i] = 0L;
                    continue block14;
                }
                case 11: {
                    continue block14;
                }
                default: {
                    int len;
                    if (columns[i] % 2L == 0L) {
                        len = (int)(columns[i] - 12L) / 2;
                        if (len < 0) continue block14;
                        column[i] = new SqliteElement(SerialTypes.BLOB, StorageClasses.BLOB, len, charset);
                        continue block14;
                    }
                    len = (int)(columns[i] - 13L) / 2;
                    if (len < 0) continue block14;
                    column[i] = new SqliteElement(SerialTypes.STRING, StorageClasses.TEXT, len, charset);
                }
            }
        }
        return column;
    }

    private int computePayload(int p) {
        int u = this.job.ps;
        int x = u - 35;
        int m = (u - 12) * 32 / 255 - 23;
        int k = m + (p - m) % (u - 4);
        this.info("p ", p);
        this.info("k ", k);
        this.info("m ", m);
        if (p <= x) {
            return p;
        }
        if (p > x && k <= x) {
            return k;
        }
        if (p > x && k > x) {
            return m;
        }
        return p;
    }

    public static long readUnsignedVarInt(ByteBuffer buffer) throws IOException {
        byte b = buffer.get();
        long value = b & 0x7F;
        int counter = 0;
        while ((b & 0x80) != 0 && counter < 8) {
            b = buffer.get();
            value <<= 7;
            if (++counter == 8) {
                value |= (long)(b & 0xFF);
                continue;
            }
            value |= (long)(b & 0x7F);
        }
        return value;
    }

    public static int TwoByteBuffertoInt(ByteBuffer b) {
        byte[] ret = new byte[4];
        ret[2] = b.get(0);
        ret[3] = b.get(1);
        return ByteBuffer.wrap(ret).getInt();
    }

    public static int TwoByteBuffertoInt(byte[] b) {
        byte[] ret = new byte[4];
        ret[2] = b[0];
        ret[3] = b[1];
        return ByteBuffer.wrap(ret).getInt();
    }

    public static void addHeadPattern2Idx(IndexDescriptor id) {
        List<String> colnames = id.columnnames;
        List<String> coltypes = id.columntypes;
        HeaderPattern pattern = new HeaderPattern();
        pattern.addHeaderConstraint(colnames.size() + 1, colnames.size() + 1);
        ListIterator<String> list = coltypes.listIterator();
        while (list.hasNext()) {
            switch (list.next()) {
                case "INT": {
                    pattern.add(new IntegerConstraint(false));
                    break;
                }
                case "TEXT": {
                    pattern.addStringConstraint();
                    break;
                }
                case "BLOB": {
                    pattern.addBLOBConstraint();
                    break;
                }
                case "REAL": {
                    pattern.addFloatingConstraint();
                    break;
                }
                case "NUMERIC": {
                    pattern.addNumericConstraint();
                }
            }
        }
        id.hpattern = pattern;
        Logger.out.info("addHeaderPattern2Idx() :: PATTTERN: ", pattern);
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexBytes = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            hexBytes[i * 2] = HEX_DIGITS[(bytes[i] & 0xFF) >> 4];
            hexBytes[i * 2 + 1] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(hexBytes);
    }

    public static String byteToHex(byte b) {
        byte[] ch = new byte[]{b};
        return Auxiliary.bytesToHex(ch);
    }

    public static String bytesToHex(ByteBuffer bb) {
        int limit = bb.limit();
        StringBuilder sb = new StringBuilder(limit * 2);
        bb.position(0);
        while (bb.position() < limit) {
            int intVal = bb.get() & 0xFF;
            if (intVal < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intVal));
        }
        return sb.toString();
    }

    public static String bytesToHex(byte[] bytes, int fromidx, int toidx) {
        byte[] hexBytes = new byte[(toidx - fromidx) * 2];
        for (int i = fromidx; i < toidx; ++i) {
            hexBytes[(i - fromidx) * 2] = HEX_DIGITS[(bytes[i] & 0xFF) >> 4];
            hexBytes[(i - fromidx) * 2 + 1] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(hexBytes);
    }

    public static long[] readVarInt(byte[] values) {
        ByteBuffer in = ByteBuffer.wrap(values);
        LinkedList<Long> res = new LinkedList<Long>();
        while (in.position() < in.limit()) {
            byte b = in.get();
            long value = b & 0x7F;
            int counter = 0;
            while ((b & 0x80) != 0 && counter < 8) {
                ++counter;
                if (in.position() >= in.limit()) {
                    return null;
                }
                b = in.get();
                value <<= 7;
                if (counter == 8) {
                    value |= (long)(b & 0xFF);
                    continue;
                }
                value |= (long)(b & 0x7F);
            }
            res.add(value);
        }
        return res.stream().mapToLong(i -> i).toArray();
    }

    public static String getSerial(SqliteElement[] columns) {
        String serial = "";
        for (SqliteElement e : columns) {
            serial = serial + (Object)((Object)e.serial);
        }
        return serial;
    }

    public static String getTableFingerPrint(SqliteElement[] columns) {
        String fp = "";
        for (SqliteElement e : columns) {
            fp = fp + (Object)((Object)e.type);
        }
        return fp;
    }

    public static void printStackTrace() {
        Logger.out.info("Printing stack trace:");
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < elements.length; ++i) {
            StackTraceElement s = elements[i];
            Logger.out.info("\tat ", s.getClassName(), ".", s.getMethodName(), "(", s.getFileName(), ":", s.getLineNumber(), ")");
        }
    }

    public static int computePayloadLengthS(String header) {
        Logger.out.info("HEADER", header);
        byte[] bcol = Auxiliary.decode(header);
        long[] columns = Auxiliary.readVarInt(bcol);
        int pll = 0;
        pll += header.length() / 2 + 1;
        block14: for (int i = 0; i < columns.length; ++i) {
            switch ((int)columns[i]) {
                case 0: {
                    continue block14;
                }
                case 1: {
                    ++pll;
                    continue block14;
                }
                case 2: {
                    pll += 2;
                    continue block14;
                }
                case 3: {
                    pll += 3;
                    continue block14;
                }
                case 4: {
                    pll += 4;
                    continue block14;
                }
                case 5: {
                    pll += 6;
                    continue block14;
                }
                case 6: {
                    pll += 8;
                    continue block14;
                }
                case 7: {
                    pll += 8;
                    continue block14;
                }
                case 8: {
                    continue block14;
                }
                case 9: {
                    continue block14;
                }
                case 10: {
                    continue block14;
                }
                case 11: {
                    continue block14;
                }
                default: {
                    pll = columns[i] % 2L == 0L ? (int)((long)pll + (columns[i] - 12L) / 2L) : (int)((long)pll + (columns[i] - 13L) / 2L);
                }
            }
        }
        return pll;
    }

    public static int computePayloadS(int p, int ps) {
        int u = ps;
        int x = u - 35;
        int m = (u - 12) * 32 / 255 - 23;
        int k = m + (p - m) % (u - 4);
        if (p <= x) {
            return p;
        }
        if (p > x && k <= x) {
            return k;
        }
        if (p > x && k > x) {
            return m;
        }
        return p;
    }

    private int[] validateHeaderBytes(byte[] headerBytes, int start) {
        int size = headerBytes[start] - 1;
        if (size < headerBytes.length - start) {
            byte[] headerCols = new byte[size];
            System.arraycopy(headerBytes, start + 1, headerCols, 0, size);
            SqliteElement[] cols = Auxiliary.convertHeaderToSqliteElements(headerCols, this.job.db_encoding);
            if (cols != null) {
                return new int[]{cols.length, size};
            }
        }
        return FALSE_INT_ARRAY_RESP;
    }

    public int[] validateIntactMasterTableHeader(byte[] headerBytes, int start, int end) {
        for (int i = 0; i < 6; ++i) {
            byte firstByte = headerBytes[i + start];
            if (firstByte < 6 || firstByte > 9 || start + i + firstByte != end) continue;
            int[] valData = this.validateHeaderBytes(headerBytes, i + start);
            int numCols = valData[0];
            int sizeHeader = valData[1];
            if (numCols != 5) continue;
            return new int[]{i, sizeHeader + 1};
        }
        return FALSE_INT_ARRAY_RESP;
    }

    public int[] validateIntactMasterTableHeader(byte[] headerBytes, int end) {
        return this.validateIntactMasterTableHeader(headerBytes, 0, end);
    }

    public int[] validateOverwrittenMasterTableHeader(byte[] headerBytes, int end) {
        byte[] headerBytesExtended = new byte[headerBytes.length + 1];
        System.arraycopy(headerBytes, 0, headerBytesExtended, 1, headerBytes.length);
        for (int i = 0; i < 6; ++i) {
            for (int size = 6; size <= 9; ++size) {
                headerBytesExtended[i] = (byte)(size & 0xFF);
                int[] valData = this.validateIntactMasterTableHeader(headerBytesExtended, i, end + 1);
                if (valData[0] < 0) continue;
                return new int[]{i + valData[0] - 1, valData[1]};
            }
        }
        return FALSE_INT_ARRAY_RESP;
    }
}

