/*
 * Decompiled with CFR 0.152.
 */
package fqlite.util;

import fqlite.util.LongPositionByteBuffer;
import java.io.IOException;
import java.util.Arrays;

public class ByteSeqSearcher {
    private byte[] pattern_;
    private int[] borders_;
    public static final int MAX_PATTERN_LENGTH = 2048;

    public ByteSeqSearcher(byte[] pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(byte[] pattern) {
        this.pattern_ = Arrays.copyOf(pattern, pattern.length);
        this.borders_ = new int[this.pattern_.length + 1];
        this.preProcess();
    }

    public long indexOf(LongPositionByteBuffer file, long start) throws IOException {
        file.position(start);
        return this.indexOf(file);
    }

    public long indexOf(LongPositionByteBuffer file) throws IOException {
        int j = 0;
        while (file.position() < file.size()) {
            byte b = file.get();
            while (j >= 0 && (byte)b != this.pattern_[j]) {
                j = this.borders_[j];
            }
            if (++j != this.pattern_.length) continue;
            return file.position();
        }
        return -1L;
    }

    private void preProcess() {
        int j;
        int i = 0;
        this.borders_[i] = j = -1;
        while (i < this.pattern_.length) {
            while (j >= 0 && this.pattern_[i] != this.pattern_[j]) {
                j = this.borders_[j];
            }
            this.borders_[++i] = ++j;
        }
    }
}

