/*
 * Decompiled with CFR 0.152.
 */
package fqlite.util;

import fqlite.util.LongPositionByteBuffer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class RandomAccessFileReader
extends LongPositionByteBuffer {
    private static final int BUFFER_SIZE = 65536;
    private FileChannel channel;
    private ByteBuffer buffer;
    private long position;
    private long size;
    private long bufferPosition;

    public RandomAccessFileReader(Path path) throws IOException {
        this.channel = FileChannel.open(path, StandardOpenOption.READ);
        this.size = this.channel.size();
        this.position = 0L;
        this.bufferPosition = -1L;
        this.buffer = ByteBuffer.allocate(65536);
        this.fillBuffer();
    }

    @Override
    public long position() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(long newPosition) throws IOException {
        if (newPosition > this.size) {
            throw new BufferUnderflowException();
        }
        Object object = this.lock;
        synchronized (object) {
            long oldPosition = this.position;
            this.position = newPosition;
            this.fillBuffer();
            return oldPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.position > this.size) {
                throw new BufferUnderflowException();
            }
            if (this.buffer.remaining() == 0) {
                this.fillBuffer();
            }
            byte resp = this.buffer.get();
            this.position(this.position + 1L);
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongPositionByteBuffer get(byte[] dst, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.position(this.position);
            while (length > 0) {
                int toRead = Math.min(length, this.buffer.remaining());
                if (toRead == 0) {
                    throw new BufferUnderflowException();
                }
                this.buffer.get(dst, offset, toRead);
                this.position(this.position + (long)toRead);
                offset += toRead;
                length -= toRead;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongPositionByteBuffer get(byte[] dst) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.get(dst, 0, dst.length);
        }
    }

    private void fillBuffer() throws IOException {
        long newBufferPos = this.position / 65536L;
        int positionInBuffer = (int)(this.position % 65536L);
        if (newBufferPos != this.bufferPosition) {
            this.bufferPosition = newBufferPos;
            ((Buffer)this.buffer).clear();
            this.channel.position(this.bufferPosition * 65536L);
            this.channel.read(this.buffer);
            this.buffer.flip();
        }
        this.buffer.position(positionInBuffer);
    }

    @Override
    public long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.channel.close();
        }
    }
}

