/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourlastor.harlequin.system;

import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import io.github.fourlastor.harlequin.Harlequin;
import io.github.fourlastor.harlequin.component.ActorComponent;
import java.util.List;
import java.util.function.IntFunction;

public class StageSystem
extends EntitySystem {
    private static final Family FAMILY = Family.all((Class[])new Class[]{ActorComponent.class}).get();
    private static final ComponentMapper<ActorComponent> COMPONENT_MAPPER = ComponentMapper.getFor(ActorComponent.class);
    private final ComponentMapper<ActorComponent> actors = COMPONENT_MAPPER;
    private final Stage stage;
    private final List<Group> layerGroups;
    private final ActorsListener actorsListener = new ActorsListener();

    public StageSystem(Stage stage, Class<? extends Enum<?>> layers) {
        this(stage, layers, ignored -> new Group());
    }

    public StageSystem(Stage stage, Class<? extends Enum<?>> layers, IntFunction<? extends Group> layerFactory) {
        this.stage = stage;
        int layersCount = layers.getEnumConstants().length;
        this.layerGroups = Harlequin.LIST_CREATOR.newList(layersCount);
        for (int i = 0; i < layersCount; ++i) {
            this.layerGroups.add(layerFactory.apply(i));
        }
    }

    public void update(float deltaTime) {
        this.stage.getViewport().apply();
        this.stage.act(deltaTime);
        this.stage.draw();
    }

    public void addedToEngine(Engine engine) {
        engine.addEntityListener(FAMILY, (EntityListener)this.actorsListener);
        for (Group layer : this.layerGroups) {
            this.stage.addActor((Actor)layer);
        }
    }

    public void removedFromEngine(Engine engine) {
        engine.removeEntityListener((EntityListener)this.actorsListener);
        for (Group layer : this.layerGroups) {
            layer.remove();
        }
    }

    private class ActorsListener
    implements EntityListener {
        private ActorsListener() {
        }

        public void entityAdded(Entity entity) {
            if (StageSystem.this.actors.has(entity)) {
                ActorComponent actorComponent = (ActorComponent)StageSystem.this.actors.get(entity);
                Actor actor = actorComponent.actor;
                Enum<?> layer = actorComponent.layer;
                ((Group)StageSystem.this.layerGroups.get(layer.ordinal())).addActor(actor);
            }
        }

        public void entityRemoved(Entity entity) {
            if (StageSystem.this.actors.has(entity)) {
                ((ActorComponent)((StageSystem)StageSystem.this).actors.get((Entity)entity)).actor.remove();
            }
        }
    }
}

