/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api;

import com.freya02.botcommands.api.localization.Localization;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultMessages {
    @NotNull
    private final Localization defaultLocalization;
    @Nullable
    private final Localization localization;

    @ApiStatus.Internal
    public DefaultMessages(@NotNull Locale locale) {
        Localization defaultLocalization = Localization.getInstance("DefaultMessages_default", locale);
        if (defaultLocalization == null) {
            throw new IllegalStateException("Could not find any DefaultMessages_default bundle");
        }
        this.defaultLocalization = defaultLocalization;
        this.localization = Localization.getInstance("DefaultMessages", locale);
    }

    @NotNull
    private LocalizationTemplate getLocalizationTemplate(@NotNull String path) {
        LocalizationTemplate template;
        LocalizationTemplate localizationTemplate = template = this.localization == null ? null : this.localization.get(path);
        if (template == null) {
            template = this.defaultLocalization.get(path);
        }
        if (template == null) {
            throw new IllegalArgumentException("Localization template for default messages '" + path + "' could not be found");
        }
        return template;
    }

    public String getGeneralErrorMsg() {
        return this.getLocalizationTemplate("general_error_message").localize(new Localization.Entry[0]);
    }

    public String getUserPermErrorMsg() {
        return this.getLocalizationTemplate("user.perm.error.message").localize(new Localization.Entry[0]);
    }

    public String getBotPermErrorMsg(String permissionsString) {
        return this.getLocalizationTemplate("bot.perm.error.message").localize(Localization.Entry.entry("permissions", permissionsString));
    }

    public String getOwnerOnlyErrorMsg() {
        return this.getLocalizationTemplate("owner.only.error.message").localize(new Localization.Entry[0]);
    }

    public String getUserCooldownMsg(double cooldown) {
        return this.getLocalizationTemplate("user.cooldown.message").localize(Localization.Entry.entry("cooldown", cooldown));
    }

    public String getChannelCooldownMsg(double cooldown) {
        return this.getLocalizationTemplate("channel.cooldown.message").localize(Localization.Entry.entry("cooldown", cooldown));
    }

    public String getGuildCooldownMsg(double cooldown) {
        return this.getLocalizationTemplate("guild.cooldown.message").localize(Localization.Entry.entry("cooldown", cooldown));
    }

    public String getCommandNotFoundMsg(String suggestions) {
        return this.getLocalizationTemplate("command.not.found.message").localize(Localization.Entry.entry("suggestions", suggestions));
    }

    public String getSlashCommandUnresolvableParameterMsg(String parameterName, String parameterType) {
        return this.getLocalizationTemplate("slash.command.unresolvable.parameter.message").localize(Localization.Entry.entry(parameterName, parameterName), Localization.Entry.entry(parameterType, parameterType));
    }

    public String getClosedDMErrorMsg() {
        return this.getLocalizationTemplate("closed.dm.error.message").localize(new Localization.Entry[0]);
    }

    public String getNsfwDisabledErrorMsg() {
        return this.getLocalizationTemplate("nsfw.disabled.error.message").localize(new Localization.Entry[0]);
    }

    public String getNSFWOnlyErrorMsg() {
        return this.getLocalizationTemplate("nsfw.only.error.message").localize(new Localization.Entry[0]);
    }

    public String getNSFWDMDeniedErrorMsg() {
        return this.getLocalizationTemplate("nsfw.dm.denied.error.message").localize(new Localization.Entry[0]);
    }

    public String getComponentNotAllowedErrorMsg() {
        return this.getLocalizationTemplate("component.not.allowed.error.message").localize(new Localization.Entry[0]);
    }

    public String getComponentExpiredErrorMsg() {
        return this.getLocalizationTemplate("component.expired.error.message").localize(new Localization.Entry[0]);
    }

    public String getComponentNotFoundErrorMsg() {
        return this.getLocalizationTemplate("component.not.found.error.message").localize(new Localization.Entry[0]);
    }

    public String getModalExpiredErrorMsg() {
        return this.getLocalizationTemplate("modal.expired.error.message").localize(new Localization.Entry[0]);
    }
}

