/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.dv8tion.jda.internal.utils.JDALogger;
import org.slf4j.Logger;

public class Logging {
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final Map<Class<?>, Set<String>> loggedMap = Collections.synchronizedMap(new HashMap());

    public static Logger getLogger() {
        return JDALogger.getLog(WALKER.getCallerClass());
    }

    public static Logger getLogger(Object obj) {
        return JDALogger.getLog(obj.getClass());
    }

    public static boolean tryLog(Object ... keyComponents) {
        return Logging.tryLog(WALKER.getCallerClass(), keyComponents);
    }

    public static boolean tryLog(Class<?> clazz, Object ... keyComponents) {
        return loggedMap.computeIfAbsent(clazz, x -> new HashSet()).add(Arrays.stream(keyComponents).map(Object::toString).collect(Collectors.joining("/")));
    }

    public static void removeLogs(Class<?> clazz) {
        loggedMap.computeIfAbsent(clazz, x -> new HashSet()).clear();
    }

    public static void removeLogs() {
        Logging.removeLogs(WALKER.getCallerClass());
    }
}

