/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.application;

import com.freya02.botcommands.internal.application.CommandPathImpl;
import java.util.regex.Pattern;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandPath
extends Comparable<CommandPath> {
    @NotNull
    public static CommandPath of(@NotNull String name, @Nullable String group, @Nullable String subname) {
        return new CommandPathImpl(name, group, subname);
    }

    @NotNull
    public static CommandPath of(@NotNull String name, @Nullable String subname) {
        return new CommandPathImpl(name, null, subname);
    }

    @NotNull
    public static CommandPath ofName(@NotNull String name) {
        return new CommandPathImpl(name, null, null);
    }

    @NotNull
    public static CommandPath of(@NotNull String path) {
        String[] components;
        for (String component : components = path.split(" ")) {
            Checks.matches((String)component, (Pattern)Checks.ALPHANUMERIC_WITH_DASH, (String)"Path component");
        }
        return CommandPath.of(components);
    }

    @NotNull
    public static CommandPath of(String ... components) {
        if (components.length == 1) {
            return new CommandPathImpl(components[0], null, null);
        }
        if (components.length == 2) {
            return new CommandPathImpl(components[0], null, components[1]);
        }
        if (components.length == 3) {
            return new CommandPathImpl(components[0], components[1], components[2]);
        }
        throw new IllegalArgumentException("Invalid path: '" + String.join((CharSequence)" ", components) + "'");
    }

    @NotNull
    public String getName();

    @Nullable
    public String getGroup();

    @Nullable
    public String getSubname();

    public int getNameCount();

    @Nullable
    public CommandPath getParent();

    @NotNull
    public String getFullPath();

    @NotNull
    public String getFullPath(char var1);

    @NotNull
    public String getLastName();

    @Nullable
    public String getNameAt(int var1);

    @NotNull
    public String toString();

    public boolean startsWith(CommandPath var1);

    public boolean equals(Object var1);

    @Override
    default public int compareTo(@NotNull CommandPath o) {
        if (this.getNameCount() == o.getNameCount() && this.equals(o)) {
            return 0;
        }
        return this.getFullPath().compareTo(o.getFullPath());
    }
}

