/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.application.slash.autocomplete;

import com.freya02.botcommands.internal.utils.StringUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import me.xdrop.fuzzywuzzy.ToStringFunction;
import me.xdrop.fuzzywuzzy.model.BoundExtractedResult;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;

public class AutocompleteAlgorithms {
    public static <T> List<BoundExtractedResult<T>> fuzzyMatchingWithContinuity(Collection<T> items, ToStringFunction<T> toStringFunction, CommandAutoCompleteInteractionEvent event) {
        AutoCompleteQuery autoCompleteQuery = event.getFocusedOption();
        String query = autoCompleteQuery.getValue();
        List<Object> list = items.stream().filter(s -> StringUtils.startsWithIgnoreCase(toStringFunction.apply(s), query)).sorted(Comparator.comparing(arg_0 -> toStringFunction.apply(arg_0))).toList();
        return FuzzySearch.extractTop((String)query, list, toStringFunction, FuzzySearch::ratio, (int)25);
    }

    public static <T> List<BoundExtractedResult<T>> fuzzyMatching(Collection<T> items, ToStringFunction<T> toStringFunction, CommandAutoCompleteInteractionEvent event) {
        List<Object> list = items.stream().sorted(Comparator.comparing(arg_0 -> toStringFunction.apply(arg_0))).toList();
        AutoCompleteQuery autoCompleteQuery = event.getFocusedOption();
        List bigLengthDiffResults = FuzzySearch.extractTop((String)autoCompleteQuery.getValue(), list, toStringFunction, FuzzySearch::partialRatio, (int)25);
        return FuzzySearch.extractTop((String)autoCompleteQuery.getValue(), bigLengthDiffResults.stream().map(BoundExtractedResult::getReferent).toList(), toStringFunction, FuzzySearch::ratio, (int)25);
    }
}

