/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.builder;

import com.freya02.botcommands.api.ConstructorParameterSupplier;
import com.freya02.botcommands.api.DynamicInstanceSupplier;
import com.freya02.botcommands.api.InstanceSupplier;
import com.freya02.botcommands.api.application.slash.autocomplete.AutocompletionTransformer;
import com.freya02.botcommands.api.parameters.CustomResolver;
import com.freya02.botcommands.api.parameters.CustomResolverFunction;
import com.freya02.botcommands.api.parameters.ParameterResolver;
import com.freya02.botcommands.api.parameters.ParameterResolvers;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.runner.MethodRunnerFactory;
import java.util.function.Supplier;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;

public class ExtensionsBuilder {
    private final BContextImpl context;

    public ExtensionsBuilder(BContextImpl context) {
        this.context = context;
    }

    public ExtensionsBuilder registerParameterResolver(ParameterResolver resolver) {
        ParameterResolvers.register(resolver);
        return this;
    }

    public <T> ExtensionsBuilder registerConstructorParameter(Class<T> parameterType, ConstructorParameterSupplier<T> parameterSupplier) {
        if (this.context.getParameterSupplier(parameterType) != null) {
            throw new IllegalStateException("Parameter supplier already exists for parameter of type " + parameterType.getName());
        }
        this.context.registerConstructorParameter(parameterType, parameterSupplier);
        return this;
    }

    public <T> ExtensionsBuilder registerInstanceSupplier(Class<T> classType, InstanceSupplier<T> instanceSupplier) {
        if (this.context.getInstanceSupplier(classType) != null) {
            throw new IllegalStateException("Instance supplier already exists for class " + classType.getName());
        }
        this.context.registerInstanceSupplier(classType, instanceSupplier);
        return this;
    }

    public ExtensionsBuilder registerDynamicInstanceSupplier(DynamicInstanceSupplier dynamicInstanceSupplier) {
        this.context.registerDynamicInstanceSupplier(dynamicInstanceSupplier);
        return this;
    }

    public <T> ExtensionsBuilder registerCommandDependency(Class<T> fieldType, Supplier<T> supplier) {
        if (this.context.getCommandDependency(fieldType) != null) {
            throw new IllegalStateException("Command dependency already exists for fields of type " + fieldType.getName());
        }
        this.context.registerCommandDependency(fieldType, supplier);
        return this;
    }

    public <T> ExtensionsBuilder registerCustomResolver(Class<T> parameterType, CustomResolverFunction<T> function) {
        if (ParameterResolvers.exists(parameterType)) {
            throw new IllegalStateException("Custom resolver already exists for parameters of type " + parameterType.getName());
        }
        ParameterResolvers.register(new CustomResolver(parameterType, function));
        return this;
    }

    public <T> ExtensionsBuilder registerAutocompletionTransformer(Class<T> type, AutocompletionTransformer<T> autocompletionTransformer) {
        this.context.registerAutocompletionTransformer(type, autocompletionTransformer);
        return this;
    }

    public ExtensionsBuilder setMethodRunnerFactory(@NotNull MethodRunnerFactory factory) {
        Checks.notNull((Object)factory, (String)"Method runner factory");
        this.context.setMethodRunnerFactory(factory);
        return this;
    }
}

