/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.ButtonConsumer;
import com.freya02.botcommands.api.components.EntitySelectionConsumer;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.StringSelectionConsumer;
import com.freya02.botcommands.api.components.builder.ComponentBuilder;
import com.freya02.botcommands.api.components.builder.buttons.LambdaButtonBuilder;
import com.freya02.botcommands.api.components.builder.buttons.PersistentButtonBuilder;
import com.freya02.botcommands.api.components.builder.selects.LambdaEntitySelectionMenuBuilder;
import com.freya02.botcommands.api.components.builder.selects.LambdaStringSelectionMenuBuilder;
import com.freya02.botcommands.api.components.builder.selects.PersistentEntitySelectionMenuBuilder;
import com.freya02.botcommands.api.components.builder.selects.PersistentStringSelectionMenuBuilder;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.interactions.components.selections.EntitySelectMenu;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Components {
    private static final List<Class<? extends ISnowflake>> RESTRICTED_CLASSES = List.of(Role.class, Channel.class, Guild.class, User.class, Message.class);
    private static final Logger LOGGER = Logging.getLogger();
    private static BContext context;

    static void setContext(BContext context) {
        Components.context = context;
    }

    @NotNull
    public static ActionComponent[] group(ActionComponent ... components) {
        Utils.getComponentManager(context).registerGroup(Arrays.stream(components).map(ActionComponent::getId).collect(Collectors.toList()));
        return components;
    }

    @NotNull
    public static <T extends Collection<ActionComponent>> T group(@NotNull T components) {
        Utils.getComponentManager(context).registerGroup(components.stream().map(ActionComponent::getId).collect(Collectors.toList()));
        return components;
    }

    @NotNull
    public static ActionRow[] groupRows(ActionRow ... rows) {
        Utils.getComponentManager(context).registerGroup(Arrays.stream(rows).flatMap(row -> row.getComponents().stream().filter(ActionComponent.class::isInstance).map(ActionComponent.class::cast)).map(ActionComponent::getId).collect(Collectors.toList()));
        return rows;
    }

    @NotNull
    public static <T extends Collection<ActionRow>> T groupRows(@NotNull T rows) {
        Utils.getComponentManager(context).registerGroup(rows.stream().flatMap(row -> row.getComponents().stream().filter(ActionComponent.class::isInstance).map(ActionComponent.class::cast)).map(ActionComponent::getId).collect(Collectors.toList()));
        return rows;
    }

    @SafeVarargs
    @Contract(value="_, _ -> param2")
    public static <T extends ComponentBuilder<T>> T[] applyConstraints(InteractionConstraints constraints, T ... builders) {
        for (T builder : builders) {
            builder.setConstraints(constraints);
        }
        return builders;
    }

    @Contract(value="_, _ -> param2")
    public static <T extends ComponentBuilder<T>, C extends Collection<T>> C applyConstraints(InteractionConstraints constraints, @NotNull C builders) {
        for (ComponentBuilder builder : builders) {
            builder.setConstraints(constraints);
        }
        return builders;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static LambdaButtonBuilder primaryButton(@NotNull ButtonConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaButtonBuilder(context, consumer, ButtonStyle.PRIMARY);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static LambdaButtonBuilder secondaryButton(@NotNull ButtonConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaButtonBuilder(context, consumer, ButtonStyle.SECONDARY);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static LambdaButtonBuilder dangerButton(@NotNull ButtonConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaButtonBuilder(context, consumer, ButtonStyle.DANGER);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static LambdaButtonBuilder successButton(@NotNull ButtonConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaButtonBuilder(context, consumer, ButtonStyle.SUCCESS);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static LambdaButtonBuilder button(@NotNull ButtonStyle style, @NotNull ButtonConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaButtonBuilder(context, consumer, style);
    }

    private static void checkCapturedVars(Object consumer) {
        for (Field field : consumer.getClass().getDeclaredFields()) {
            for (Class<? extends ISnowflake> aClass : RESTRICTED_CLASSES) {
                if (!aClass.isAssignableFrom(field.getType())) continue;
                LOGGER.warn("A component consumer has a field of type {}, these objects could be invalid when the action is called. Consider having IDs of the objects you need, refer to https://github.com/DV8FromTheWorld/JDA/wiki/19%29-Troubleshooting#cannot-get-reference-as-it-has-already-been-garbage-collected", (Object)aClass.getSimpleName());
            }
        }
    }

    @NotNull
    private static String[] processArgs(Object[] args) {
        String[] strings = new String[args.length];
        for (Object arg : args) {
            strings[i] = arg instanceof ISnowflake ? ((ISnowflake)arg).getId() : arg.toString();
        }
        return strings;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static PersistentButtonBuilder primaryButton(@NotNull String handlerName, Object ... args) {
        return new PersistentButtonBuilder(context, handlerName, Components.processArgs(args), ButtonStyle.PRIMARY);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static PersistentButtonBuilder secondaryButton(@NotNull String handlerName, Object ... args) {
        return new PersistentButtonBuilder(context, handlerName, Components.processArgs(args), ButtonStyle.SECONDARY);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static PersistentButtonBuilder dangerButton(@NotNull String handlerName, Object ... args) {
        return new PersistentButtonBuilder(context, handlerName, Components.processArgs(args), ButtonStyle.DANGER);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static PersistentButtonBuilder successButton(@NotNull String handlerName, Object ... args) {
        return new PersistentButtonBuilder(context, handlerName, Components.processArgs(args), ButtonStyle.SUCCESS);
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static PersistentButtonBuilder button(@NotNull ButtonStyle style, @NotNull String handlerName, Object ... args) {
        return new PersistentButtonBuilder(context, handlerName, Components.processArgs(args), style);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static LambdaStringSelectionMenuBuilder stringSelectionMenu(@NotNull StringSelectionConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaStringSelectionMenuBuilder(context, consumer);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static LambdaEntitySelectionMenuBuilder entitySelectionMenu(@NotNull EntitySelectMenu.SelectTarget type, @NotNull EntitySelectionConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaEntitySelectionMenuBuilder(List.of(type), context, consumer);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static LambdaEntitySelectionMenuBuilder entitySelectionMenu(@NotNull Collection<EntitySelectMenu.SelectTarget> types, @NotNull EntitySelectionConsumer consumer) {
        Components.checkCapturedVars(consumer);
        return new LambdaEntitySelectionMenuBuilder(types, context, consumer);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static PersistentStringSelectionMenuBuilder stringSelectionMenu(@NotNull String handlerName, Object ... args) {
        return new PersistentStringSelectionMenuBuilder(context, handlerName, Components.processArgs(args));
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static PersistentEntitySelectionMenuBuilder entitySelectionMenu(@NotNull EntitySelectMenu.SelectTarget type, @NotNull String handlerName, Object ... args) {
        return new PersistentEntitySelectionMenuBuilder(List.of(type), context, handlerName, Components.processArgs(args));
    }

    @NotNull
    @Contract(value="_, _, _ -> new")
    public static PersistentEntitySelectionMenuBuilder entitySelectionMenu(@NotNull Collection<EntitySelectMenu.SelectTarget> types, @NotNull String handlerName, Object ... args) {
        return new PersistentEntitySelectionMenuBuilder(types, context, handlerName, Components.processArgs(args));
    }
}

