/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import org.jetbrains.annotations.NotNull;

public class InteractionConstraints {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TLongArrayList.class, (Object)new TLongArrayListAdapter()).registerTypeHierarchyAdapter(EnumSet.class, (Object)new EnumSetAdapter()).create();
    private final TLongArrayList userList = new TLongArrayList();
    private final TLongArrayList roleList = new TLongArrayList();
    private final EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);

    public static InteractionConstraints empty() {
        return new InteractionConstraints();
    }

    public static InteractionConstraints ofUserIds(long ... userIds) {
        return InteractionConstraints.empty().addUserIds(userIds);
    }

    public static InteractionConstraints ofUserIds(Collection<Long> userIds) {
        return InteractionConstraints.empty().addUserIds(userIds);
    }

    public static InteractionConstraints ofUsers(User ... users) {
        return InteractionConstraints.empty().addUsers(users);
    }

    public static InteractionConstraints ofUsers(Collection<User> users) {
        return InteractionConstraints.empty().addUsers(users);
    }

    public static InteractionConstraints ofRoleIds(long ... roleIds) {
        return InteractionConstraints.empty().addRoleIds(roleIds);
    }

    public static InteractionConstraints ofRoleIds(@NotNull @NotNull Collection<@NotNull Long> roleIds) {
        return InteractionConstraints.empty().addRoleIds(roleIds);
    }

    public static InteractionConstraints ofRoles(Role ... roles) {
        return InteractionConstraints.empty().addRoles(roles);
    }

    public static InteractionConstraints ofRoles(@NotNull @NotNull Collection<@NotNull Role> roles) {
        return InteractionConstraints.empty().addRoles(roles);
    }

    public static InteractionConstraints ofPermissions(Permission ... permissions) {
        return InteractionConstraints.empty().addPermissions(permissions);
    }

    public InteractionConstraints addUserIds(long ... userIds) {
        this.userList.addAll(userIds);
        return this;
    }

    public InteractionConstraints addUserIds(Collection<@NotNull Long> userIds) {
        this.userList.addAll(userIds);
        return this;
    }

    public InteractionConstraints addUsers(User ... userIds) {
        for (User user : userIds) {
            this.userList.add(user.getIdLong());
        }
        return this;
    }

    public InteractionConstraints addUsers(@NotNull @NotNull Collection<@NotNull User> users) {
        for (User user : users) {
            this.userList.add(user.getIdLong());
        }
        return this;
    }

    public InteractionConstraints addRoleIds(long ... roleIds) {
        this.roleList.addAll(roleIds);
        return this;
    }

    public InteractionConstraints addRoleIds(Collection<Long> roleIds) {
        this.roleList.addAll(roleIds);
        return this;
    }

    public InteractionConstraints addRoles(Role ... roles) {
        for (Role role : roles) {
            this.roleList.add(role.getIdLong());
        }
        return this;
    }

    public InteractionConstraints addRoles(@NotNull @NotNull Collection<@NotNull Role> roles) {
        for (Role role : roles) {
            this.roleList.add(role.getIdLong());
        }
        return this;
    }

    public InteractionConstraints addPermissions(Permission ... permissions) {
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    public TLongArrayList getUserList() {
        return this.userList;
    }

    public TLongArrayList getRoleList() {
        return this.roleList;
    }

    public EnumSet<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isEmpty() {
        return this.getUserList().isEmpty() && this.getRoleList().isEmpty() && this.getPermissions().isEmpty();
    }

    public static InteractionConstraints fromJson(String json) {
        return (InteractionConstraints)GSON.fromJson(json, InteractionConstraints.class);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public InteractionConstraints setConstraints(InteractionConstraints otherConstraints) {
        this.getUserList().clear();
        this.getRoleList().clear();
        this.getPermissions().clear();
        this.getUserList().addAll((TLongCollection)otherConstraints.getUserList());
        this.getRoleList().addAll((TLongCollection)otherConstraints.getRoleList());
        this.getPermissions().addAll(otherConstraints.getPermissions());
        return this;
    }

    private static class TLongArrayListAdapter
    implements JsonSerializer<TLongArrayList>,
    JsonDeserializer<TLongArrayList> {
        private TLongArrayListAdapter() {
        }

        public TLongArrayList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TLongArrayList list = new TLongArrayList();
            for (JsonElement element : json.getAsJsonArray()) {
                list.add(element.getAsLong());
            }
            return list;
        }

        public JsonElement serialize(TLongArrayList src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            src.forEach(value -> {
                array.add((Number)value);
                return true;
            });
            return array;
        }
    }

    private static class EnumSetAdapter
    implements JsonSerializer<EnumSet<Permission>>,
    JsonDeserializer<EnumSet<Permission>> {
        private EnumSetAdapter() {
        }

        public JsonElement serialize(EnumSet<Permission> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)Permission.getRaw(src));
        }

        public EnumSet<Permission> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Permission.getPermissions((long)json.getAsLong());
        }
    }
}

