/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.localization;

import com.freya02.botcommands.api.localization.Localization;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import com.freya02.botcommands.internal.localization.FormattableString;
import com.freya02.botcommands.internal.localization.JavaFormattableString;
import com.freya02.botcommands.internal.localization.LocalizableString;
import com.freya02.botcommands.internal.localization.MessageFormatString;
import com.freya02.botcommands.internal.localization.RawString;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DefaultLocalizationTemplate
implements LocalizationTemplate {
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("\\{.*?}");
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(\\w+?)(?::(%.+))?}");
    private static final Pattern MESSAGE_FORMAT_PATTERN = Pattern.compile("\\{(\\w+)(,?.*?)}");
    private final List<LocalizableString> localizableStrings = new ArrayList<LocalizableString>();
    private final String template;

    public DefaultLocalizationTemplate(@NotNull String template, @NotNull Locale locale) {
        this.template = template;
        Matcher bracketMatcher = BRACKETS_PATTERN.matcher(template);
        int start = 0;
        while (bracketMatcher.find()) {
            this.addRawString(template.substring(start, bracketMatcher.start()));
            Matcher templateMatcher = TEMPLATE_PATTERN.matcher(bracketMatcher.group());
            if (templateMatcher.matches()) {
                String formatterName = templateMatcher.group(1);
                String formatter = templateMatcher.group(2);
                this.localizableStrings.add(new JavaFormattableString(formatterName, formatter));
            } else {
                Matcher messageFormatMatcher = MESSAGE_FORMAT_PATTERN.matcher(bracketMatcher.group());
                if (!messageFormatMatcher.matches()) {
                    throw new IllegalArgumentException("Invalid MessageFormat format '%s' in template '%s'".formatted(bracketMatcher.group(), template));
                }
                String formatterName = messageFormatMatcher.group(1);
                String messageFormatter = messageFormatMatcher.replaceFirst("{0$2}");
                this.localizableStrings.add(new MessageFormatString(formatterName, messageFormatter, locale));
            }
            start = bracketMatcher.end();
        }
        this.addRawString(template.substring(start));
    }

    private void addRawString(String substring) {
        if (substring.isEmpty()) {
            return;
        }
        this.localizableStrings.add(new RawString(substring));
    }

    @Override
    @NotNull
    public String localize(Localization.Entry ... args) {
        StringBuilder sb = new StringBuilder();
        for (LocalizableString localizableString : this.localizableStrings) {
            if (localizableString instanceof RawString) {
                RawString rawString = (RawString)localizableString;
                sb.append(rawString.get());
                continue;
            }
            if (!(localizableString instanceof FormattableString)) continue;
            FormattableString formattableString = (FormattableString)localizableString;
            Object value = this.getValueByFormatterName(args, formattableString.getFormatterName());
            sb.append(formattableString.format(value));
        }
        return sb.toString();
    }

    private Object getValueByFormatterName(Localization.Entry[] args, String formatterName) {
        for (Localization.Entry entry : args) {
            if (!entry.key().equals(formatterName)) continue;
            return entry.value();
        }
        throw new IllegalArgumentException("Could not find format '%s' in template: '%s'".formatted(formatterName, this.template));
    }

    public String toString() {
        return this.template;
    }
}

