/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.localization.providers;

import com.freya02.botcommands.api.localization.DefaultLocalizationMap;
import com.freya02.botcommands.api.localization.DefaultLocalizationTemplate;
import com.freya02.botcommands.api.localization.Localization;
import com.freya02.botcommands.api.localization.LocalizationMap;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import com.freya02.botcommands.api.localization.providers.LocalizationMapProvider;
import com.freya02.botcommands.api.localization.providers.LocalizationMapProviders;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLocalizationMapProvider
implements LocalizationMapProvider {
    @Override
    @Nullable
    public LocalizationMap getBundle(@NotNull String baseName, @NotNull Locale effectiveLocale) throws IOException {
        Map<String, LocalizationTemplate> templateMap = this.readTemplateMap(baseName, effectiveLocale);
        return this.withParentBundles(baseName, effectiveLocale, templateMap);
    }

    @Override
    @Nullable
    public LocalizationMap getBundleNoParent(@NotNull String baseName, @NotNull Locale locale) throws IOException {
        Map<String, LocalizationTemplate> map = this.readTemplateMap(baseName, locale);
        if (map == null) {
            return null;
        }
        return new DefaultLocalizationMap(locale, map);
    }

    @Nullable
    private Map<String, LocalizationTemplate> readTemplateMap(@NotNull String baseName, @NotNull Locale effectiveLocale) throws IOException {
        InputStream stream = Localization.class.getResourceAsStream("/bc_localization/" + this.getBundleName(baseName, effectiveLocale) + ".json");
        if (stream == null) {
            return null;
        }
        HashMap<String, LocalizationTemplate> templateMap = new HashMap<String, LocalizationTemplate>();
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Map map = (Map)new Gson().fromJson((Reader)reader, Map.class);
            this.discoverEntries(templateMap, baseName, effectiveLocale, "", map.entrySet());
        }
        return templateMap;
    }

    @Nullable
    private LocalizationMap withParentBundles(@NotNull String baseName, @NotNull Locale effectiveLocale, @Nullable Map<String, LocalizationTemplate> templateMap) throws IOException {
        List<Locale> candidateLocales = CONTROL.getCandidateLocales(baseName, effectiveLocale);
        for (Locale candidateLocale : candidateLocales) {
            LocalizationMap parentLocalization;
            if (candidateLocale.equals(effectiveLocale) || (parentLocalization = LocalizationMapProviders.cycleProvidersNoParent(baseName, candidateLocale)) == null) continue;
            Map<String, ? extends LocalizationTemplate> parentTemplateMap = parentLocalization.templateMap();
            if (templateMap == null) {
                templateMap = new HashMap<String, LocalizationTemplate>();
                effectiveLocale = candidateLocale;
            }
            for (Map.Entry<String, ? extends LocalizationTemplate> entry : parentTemplateMap.entrySet()) {
                templateMap.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        if (templateMap == null) {
            return null;
        }
        return new DefaultLocalizationMap(effectiveLocale, templateMap);
    }

    private void discoverEntries(Map<String, LocalizationTemplate> templateMap, @NotNull String baseName, Locale effectiveLocale, String currentPath, Set<? extends Map.Entry<String, ?>> entries) {
        for (Map.Entry<String, ?> entry : entries) {
            String key = this.appendPath(currentPath, entry.getKey());
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                Map map = (Map)obj;
                this.discoverEntries(templateMap, baseName, effectiveLocale, key, map.entrySet());
                continue;
            }
            if (!(entry.getValue() instanceof String)) {
                throw new IllegalArgumentException("Key '%s' in bundle '%s' (locale '%s') can only be a String".formatted(key, baseName, effectiveLocale));
            }
            DefaultLocalizationTemplate value = new DefaultLocalizationTemplate((String)entry.getValue(), effectiveLocale);
            if (templateMap.put(key, value) == null) continue;
            throw new IllegalStateException("Got two same localization keys: '" + key + "'");
        }
    }
}

