/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.localization.providers;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.localization.LocalizationMap;
import com.freya02.botcommands.api.localization.providers.DefaultLocalizationMapProvider;
import com.freya02.botcommands.api.localization.providers.LocalizationMapProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;

public final class LocalizationMapProviders {
    private static final Logger LOGGER = Logging.getLogger();
    private static final Set<LocalizationMapProvider> providers = new HashSet<LocalizationMapProvider>();

    @Contract(pure=true)
    @NotNull
    public static @UnmodifiableView Collection<LocalizationMapProvider> getProviders() {
        return Collections.unmodifiableSet(providers);
    }

    @Nullable
    public static LocalizationMap cycleProviders(@NotNull String baseName, @NotNull Locale locale) {
        for (LocalizationMapProvider provider : providers) {
            try {
                LocalizationMap bundle = provider.getBundle(baseName, locale);
                if (bundle == null) continue;
                return bundle;
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while getting a bundle '{}' with locale '{}' with provider '{}'", new Object[]{baseName, locale, provider.getClass().getName()});
            }
        }
        return null;
    }

    @Nullable
    public static LocalizationMap cycleProvidersNoParent(@NotNull String baseName, @NotNull Locale locale) throws IOException {
        for (LocalizationMapProvider provider : providers) {
            LocalizationMap bundle = provider.getBundleNoParent(baseName, locale);
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }

    public static void registerProvider(@NotNull LocalizationMapProvider provider) {
        providers.add(provider);
    }

    static {
        LocalizationMapProviders.registerProvider(new DefaultLocalizationMapProvider());
    }
}

