/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.modals;

import com.freya02.botcommands.api.modals.ModalTimeoutInfo;
import com.freya02.botcommands.api.modals.Modals;
import com.freya02.botcommands.internal.modals.InputData;
import com.freya02.botcommands.internal.modals.ModalData;
import com.freya02.botcommands.internal.modals.ModalMaps;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.modals.Modal;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ModalBuilder
extends Modal.Builder {
    private final ModalMaps modalMaps;
    private final String handlerName;
    private final Object[] userData;
    private ModalTimeoutInfo timeoutInfo;

    @ApiStatus.Internal
    public ModalBuilder(ModalMaps modalMaps, @NotNull String title, @NotNull String handlerName, Object[] userData) {
        super("0", title);
        Checks.notNull((Object)handlerName, (String)"Modal handler name");
        Checks.notNull((Object)userData, (String)"Modal user data");
        this.modalMaps = modalMaps;
        this.handlerName = handlerName;
        this.userData = userData;
    }

    @NotNull
    public ModalBuilder setTimeout(long timeout, @NotNull TimeUnit unit, @NotNull Runnable onTimeout) {
        Checks.positive((long)timeout, (String)"Timeout");
        Checks.notNull((Object)((Object)unit), (String)"Time unit");
        Checks.notNull((Object)onTimeout, (String)"On-timeout runnable");
        this.timeoutInfo = new ModalTimeoutInfo(timeout, unit, onTimeout);
        return this;
    }

    @NotNull
    public ModalBuilder setId(@NotNull String customId) {
        super.setId(customId);
        return this;
    }

    @NotNull
    public Modal build() {
        HashMap<String, InputData> inputDataMap = new HashMap<String, InputData>();
        for (LayoutComponent layoutComponent : this.getComponents()) {
            for (ActionComponent actionComponent : layoutComponent.getActionComponents()) {
                String id = actionComponent.getId();
                InputData data = this.modalMaps.removeInput(id);
                if (data == null) {
                    throw new IllegalStateException("Modal component with id '%s' could not be found in the inputs created with the '%s' class".formatted(id, Modals.class.getSimpleName()));
                }
                inputDataMap.put(id, data);
            }
        }
        String actualId = this.modalMaps.insertModal(new ModalData(this.handlerName, this.userData, inputDataMap, this.timeoutInfo), this.getId());
        this.setId(actualId);
        return super.build();
    }
}

