/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination.menu;

import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.pagination.PaginatorSupplier;
import com.freya02.botcommands.api.pagination.TimeoutInfo;
import com.freya02.botcommands.api.pagination.menu.MenuPage;
import com.freya02.botcommands.api.pagination.menu.RowPrefixSupplier;
import com.freya02.botcommands.api.pagination.paginator.BasicPaginator;
import com.freya02.botcommands.api.pagination.transformer.EntryTransformer;
import com.freya02.botcommands.api.utils.ButtonContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicMenu<E, T extends BasicMenu<E, T>>
extends BasicPaginator<T> {
    protected final Map<Integer, MenuPage<E>> pages;

    protected BasicMenu(InteractionConstraints constraints, TimeoutInfo<T> timeout, boolean hasDeleteButton, ButtonContent firstContent, ButtonContent previousContent, ButtonContent nextContent, ButtonContent lastContent, ButtonContent deleteContent, @NotNull Map<Integer, MenuPage<E>> pages, @Nullable PaginatorSupplier<T> supplier) {
        super(constraints, timeout, pages.size(), supplier, hasDeleteButton, firstContent, previousContent, nextContent, lastContent, deleteContent);
        this.pages = pages;
    }

    @Override
    @NotNull
    protected MessageEmbed getEmbed() {
        EmbedBuilder builder = this.supplier != null ? new EmbedBuilder(this.supplier.get(this, this.messageBuilder, this.components, this.page)) : new EmbedBuilder();
        MenuPage<E> menuPage = this.pages.get(this.page);
        builder.appendDescription((CharSequence)menuPage.content());
        return builder.build();
    }

    @NotNull
    protected static <E> Map<Integer, MenuPage<E>> makePages(@NotNull List<E> entries, @NotNull EntryTransformer<? super E> transformer, @NotNull RowPrefixSupplier rowPrefixSupplier, int maxEntriesPerPage) {
        HashMap<Integer, MenuPage<E>> pages = new HashMap<Integer, MenuPage<E>>();
        int page = 0;
        int oldEntry = 0;
        StringBuilder builder = new StringBuilder();
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            E entry = entries.get(i);
            String s = transformer.toString(entry);
            Checks.notLonger((String)s, (int)2040, (String)("Entry #" + i + " string"));
            if (i - oldEntry >= maxEntriesPerPage || builder.length() + s.length() > 2040) {
                pages.put(page, new MenuPage<E>(builder.toString(), entries.subList(oldEntry, i)));
                ++page;
                oldEntry = i;
                builder.setLength(0);
            }
            builder.append(rowPrefixSupplier.apply(i - oldEntry + 1, maxEntriesPerPage)).append(s).append('\n');
        }
        pages.put(page, new MenuPage<E>(builder.toString(), entries.subList(oldEntry, entries.size())));
        return pages;
    }
}

