/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination.menu;

import com.freya02.botcommands.api.pagination.menu.BasicMenu;
import com.freya02.botcommands.api.pagination.menu.MenuBuilder;
import com.freya02.botcommands.api.pagination.menu.RowPrefixSupplier;
import com.freya02.botcommands.api.pagination.paginator.BasicPaginatorBuilder;
import com.freya02.botcommands.api.pagination.transformer.EntryTransformer;
import com.freya02.botcommands.api.pagination.transformer.StringTransformer;
import java.util.List;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;

public abstract class BasicMenuBuilder<E, T extends BasicMenuBuilder<E, T, R>, R extends BasicMenu<E, R>>
extends BasicPaginatorBuilder<T, R> {
    protected final List<E> entries;
    protected int maxEntriesPerPage = 5;
    protected EntryTransformer<? super E> transformer = new StringTransformer();
    protected RowPrefixSupplier rowPrefixSupplier = (entryNum, maxEntry) -> {
        int spaces = MenuBuilder.getPadding(entryNum, maxEntry);
        return "`" + " ".repeat(spaces) + entryNum + ".` ";
    };

    protected BasicMenuBuilder(@NotNull List<E> entries) {
        this.entries = entries;
    }

    public static int getPadding(int entryNum, int maxEntry) {
        double entryDigits = Math.floor(Math.log10(entryNum) + 1.0);
        double maxEntryDigits = Math.floor(Math.log10(maxEntry) + 1.0);
        return (int)(maxEntryDigits - entryDigits);
    }

    public T setMaxEntriesPerPage(int maxEntriesPerPage) {
        Checks.positive((int)maxEntriesPerPage, (String)"Max entries per page");
        this.maxEntriesPerPage = maxEntriesPerPage;
        return (T)this;
    }

    public T setRowPrefixSupplier(@NotNull RowPrefixSupplier rowPrefixSupplier) {
        this.rowPrefixSupplier = rowPrefixSupplier;
        return (T)this;
    }

    public T setTransformer(@NotNull EntryTransformer<? super E> transformer) {
        Checks.notNull(transformer, (String)"Entry transformer");
        this.transformer = transformer;
        return (T)this;
    }
}

